#ifndef ABSTRACTTAB_H
#define ABSTRACTTAB_H

#include <QWidget>
#include <QApplication>
#include <QDesktopWidget>

class AbstractTab : public QWidget
{
    Q_OBJECT

public:
    explicit AbstractTab(QWidget *parent = 0);
    inline bool inPortrait() const { return m_portrait; }

protected slots:
    void onOrientationChanged();

protected:
    inline virtual void setLandscapeLayout() {}
    inline virtual void setPortraitLayout() {}

private:
    bool m_portrait;
};

#endif // ABSTRACTTAB_H
