#include "aboutdialog.h"
#include "utils.h"
#include <QDesktopServices>
#include <QUrl>
#include <QPixmap>

AboutDialog::AboutDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_icon(new QLabel(this)),
    m_title(new QLabel("toBuntu " + Utils::versionNumberString(), this)),
    m_details(new QLabel(tr("A client for Ubuntu One.") + "<br><br> &copy; Stuart Howarth 2012", this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_donateButton(m_buttonBox->addButton(tr("Donate"), QDialogButtonBox::ActionRole)),
    m_bugButton(m_buttonBox->addButton(tr("Report bug"), QDialogButtonBox::ActionRole)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("About"));
    setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Expanding);

    m_icon->setPixmap(QPixmap(":/tobuntu.png"));
    m_icon->setFixedWidth(m_icon->pixmap()->width());
    QFont font;
    font.setBold(true);
    font.setPixelSize(32);
    m_title->setFont(font);
    m_details->setWordWrap(true);
    connect(m_donateButton, SIGNAL(clicked()), this, SLOT(donate()));
    connect(m_bugButton, SIGNAL(clicked()), this, SLOT(reportBug()));

    onOrientationChanged();
}

void AboutDialog::setLandscapeLayout() {
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_icon, 0, 0);
        m_grid->addWidget(m_title, 0, 1);
        m_grid->addWidget(m_details, 1, 0, 1, 2, Qt::AlignBottom);
        m_grid->addWidget(m_buttonBox, 1, 2);
    }
    else {
        m_grid->setAlignment(m_details, Qt::AlignBottom);
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 2);
    }
}

void AboutDialog::setPortraitLayout() {
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_icon, 0, 0);
        m_grid->addWidget(m_title, 0, 1);
        m_grid->addWidget(m_details, 1, 0, 1, 2, Qt::AlignHCenter);
        m_grid->addWidget(m_buttonBox, 2, 0, 1, 2);
    }
    else {
        m_grid->setAlignment(m_details, Qt::AlignHCenter);
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 2, 0, 1, 2);
    }
}

void AboutDialog::donate() {
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=stuhowarth77@gmail.com&lc=GB&item_name=toBuntu%20for%20Maemo5&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted"));
    close();
}

void AboutDialog::reportBug() {
    QDesktopServices::openUrl(QUrl("mailto:stuhowarth77@gmail.com?subject=toBuntu for Maemo5"));
    close();
}
