#ifndef SETTINGS_H
#define SETTINGS_H

#include "enums.h"
#include "transferitem.h"
#include <QSettings>

class Settings : public QSettings
{
    Q_OBJECT

public:
    explicit Settings(QObject *parent = 0);
    void restoreSettings();
    inline QString downloadPath() const { return m_downloadPath; }
    inline bool useDefaultDownloadPath() const { return m_useDefaultPath; }
    inline QString musicDownloadPath() const { return m_musicPath; }
    inline TransferItem::Status defaultTransferStatus() const { return m_transferStatus; }
    inline QString language() const { return m_language; }
    inline ScreenOrientation::Orientation screenOrientation() const { return m_orientation; }
    inline bool scrobbleTracks() const { return m_scrobble; }
    inline bool syncToUbuntuOne() const { return m_sync; }
    inline QVariantMap fileHandlers() const { return m_fileHandlers; }

    void setDownloadPath(const QString &path);
    void setUseDefaultDownloadPath(bool useDefault);
    void setMusicDownloadPath(const QString &path);
    void setDefaultTransferStatus(TransferItem::Status status);
    void setTheme(const QString &aTheme);
    void setActiveColor(const QString &color);
    void setActiveColorString(const QString &colorString);
    void setLanguage(const QString &lang);
    void setScreenOrientation(ScreenOrientation::Orientation orientation);
    void setScrobbleTracks(bool scrobble);
    void setSyncToUbuntuOne(bool sync);
    void setFileHandlers(const QVariantMap &handlers);

signals:
    void downloadPathChanged(const QString &path);
    void useDefaultDownloadPathChanged(bool useDefault);
    void musicDownloadPathChanged(const QString &path);
    void defaultTransferStatusChanged(TransferItem::Status status);
    void languageChanged(const QString &language);
    void screenOrientationChanged(ScreenOrientation::Orientation orientation);
    void alert(const QString &message);
    void scrobbleTracksChanged(bool scrobble);
    void syncToUbuntuOneChanged(bool sync);
    void fileHandlersChanged(const QVariantMap &handlers);

public slots:
    void saveSettings();

private:
    QString m_downloadPath;
    bool m_useDefaultPath;
    QString m_musicPath;
    TransferItem::Status m_transferStatus;
    QString m_language;
    ScreenOrientation::Orientation m_orientation;
    bool m_scrobble;
    bool m_sync;
    QVariantMap m_fileHandlers;
};

#endif // SETTINGS_H
