#ifndef FOLDERLISTDIALOG_H
#define FOLDERLISTDIALOG_H

#include "abstractdialog.h"
#include "selectionmodels.h"
#include "session.h"
#include <QListView>
#include <QGridLayout>

class FolderListDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit FolderListDialog(Session *session, const QModelIndex &index = QModelIndex(), QWidget *parent = 0);
    void setCurrentIndex(const QModelIndex &index);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void folderChosen(const QString &resourcePath);

private:
    Session *m_session;
    SelectionModel *m_model;
    QListView *m_listView;
    QGridLayout *m_grid;
};

#endif // FOLDERLISTDIALOG_H
