#ifndef FILEITEM_H
#define FILEITEM_H

#include <QObject>
#include <QVariantMap>

class FileItem : public QObject
{
    Q_OBJECT

public:
    enum MimeType {
        Folder = 0,
        Document,
        PDF,
        Image,
        Audio,
        Video,
        Package,
        Playlist,
        Flash,
        Unknown
    };

public:
    explicit FileItem(FileItem *parent = 0);
    explicit FileItem(const QString &fileName, qint64 size, bool isFolder, bool hasChildren, const QString &hash,
                      const QString &created, const QString &modified, const QString &path, const QString &resourcePath,
                      const QString &contentPath, const QString &volumePath, const QString &parentPath,
                      const QString &key, const QString &publicUrl, bool isLive, bool isPublic, FileItem *parent = 0);
    explicit FileItem(const QVariantMap &fileMap, FileItem *parent = 0);
    inline QString fileName() const { return m_filename; }
    inline void setFileName(const QString &name) { m_filename = name; }
    inline qint64 size() const { return m_size; }
    inline void setSize(qint64 size) { m_size = size; }
    inline bool isFolder() const { return m_folder; }
    inline void setIsFolder(bool isFolder) { m_folder = isFolder; }
    inline bool hasChildren() const { return m_hasChildren; }
    inline void setHasChildren(bool hasChildren) { m_hasChildren = hasChildren; }
    inline QString hash() const { return m_hash; }
    inline void setHash(const QString &hash) { m_hash = hash; }
    inline QString created() const { return m_created; }
    inline void setCreated(const QString &created) { m_created = created; }
    inline QString modified() const { return m_modified; }
    inline void setModified(const QString &modified) { m_modified = modified; }
    inline QString suffix() const { return isFolder() ? QString() : fileName().section('.', -1).toLower(); }
    FileItem::MimeType mimeType() const;
    inline QString path() const { return m_path; }
    inline void setPath(const QString &path) { m_path = path; }
    inline QString resourcePath() const { return m_resourcePath; }
    inline void setResourcePath(const QString &path) { m_resourcePath = path; }
    inline QString contentPath() const { return m_contentPath; }
    inline void setContentPath(const QString &path) { m_contentPath = path; }
    inline QString volumePath() const { return m_volumePath; }
    inline void setVolumePath(const QString &path) { m_volumePath = path; }
    inline QString parentPath() const { return m_parentPath; }
    inline void setParentPath(const QString &path) { m_parentPath = path; }
    inline QString key() const { return m_key; }
    inline void setKey(const QString &key) { m_key = key; }
    inline QString url() const { return m_url; }
    inline void setUrl(const QString &url) { m_url = url; }
    inline bool isLive() const { return m_live; }
    inline void setLive(bool isLive) { m_live = isLive; }
    inline bool isPublic() const { return m_public; }
    inline void setPublic(bool isPublic) { m_public = isPublic; }
    void appendChildFile(FileItem *file);
    void insertChildFile(int position, FileItem *file);
    void removeChildFile(int position);
    FileItem * takeChildFile(int position);
    inline QList<FileItem*> childFiles() const { return m_children; }
    FileItem* childFile(int row) const;
    inline FileItem* parentFile() const { return m_parent; }
    int childNumber() const;

private:
    QString m_filename;
    qint64 m_size;
    bool m_folder;
    bool m_hasChildren;
    QString m_hash;
    QString m_created;
    QString m_modified;
    QString m_suffix;
    QString m_path;
    QString m_resourcePath;
    QString m_contentPath;
    QString m_volumePath;
    QString m_parentPath;
    QString m_key;
    QString m_url;
    bool m_live;
    bool m_public;
    QList<FileItem*> m_children;
    FileItem *m_parent;
};

#endif // FILEITEM_H
