#ifndef FILEDETAILSDIALOG_H
#define FILEDETAILSDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include <QModelIndex>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QGridLayout>

class FileDetailsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit FileDetailsDialog(Session *session, const QModelIndex &file, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void loadFileData();
    void openLink(const QString &link);
    void onFileNameChanged(const QString &name);
    void openFile();
    void renameFile();
    void deleteFile();
    void toggleFilePublished();

private:
    Session *m_session;
    const QModelIndex m_file;
    QLineEdit *m_nameEdit;
    QLabel *m_createdLabel;
    QLabel *m_modifiedLabel;
    QLabel *m_publicUrlLabel;
    QLabel *m_sizeLabel;
    QPushButton *m_publishButton;
    QPushButton *m_openButton;
    QPushButton *m_renameButton;
    QPushButton *m_deleteButton;
    QGridLayout *m_grid;
};

#endif // FILEDETAILSDIALOG_H
