#ifndef DATABASE_H
#define DATABASE_H

#include "transferitem.h"
#include <QObject>
#include <QSqlDatabase>
#include <QVariantMap>
#include <QSharedPointer>

class Database : public QObject
{

    Q_OBJECT

public:
    explicit Database(QObject *parent = 0);
    void restoreAccounts();

public slots:
    void initialize();
    void storeUbuntuOneAccount(const QVariantMap &account);
    void getStoredDownloads();
    bool storeDownload(QSharedPointer<TransferItem> transfer);
    void removeStoredDownload(QSharedPointer<TransferItem> transfer);

private:
    void restoreUbunutOneAccount();

signals:
    void alert(const QString &message);
    void warning(const QString &message);
    void credentialsChanged(const QVariantMap &token);
    void storedDownloadRemoved(QSharedPointer<TransferItem> transfer);
    void gotStoredDownloads(QList< QSharedPointer<TransferItem> > transfers);

private:
    QSqlDatabase m_database;
};

#endif // DATABASE_H
