/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class JDKDigestSignature
extends SignatureSpi {
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private AlgorithmIdentifier algId;

    protected JDKDigestSignature(DERObjectIdentifier dERObjectIdentifier, Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.digest = digest;
        this.cipher = asymmetricBlockCipher;
        this.algId = new AlgorithmIdentifier(dERObjectIdentifier, DERNull.INSTANCE);
    }

    @Override
    protected void engineInitVerify(PublicKey object) throws InvalidKeyException {
        if (!(object instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + JDKDigestSignature.getType(object) + ") is not a RSAPublicKey instance");
        }
        object = (RSAPublicKey)object;
        object = new RSAKeyParameters(false, object.getModulus(), object.getPublicExponent());
        this.digest.reset();
        this.cipher.init(false, (CipherParameters)object);
    }

    @Override
    protected void engineInitSign(PrivateKey object) throws InvalidKeyException {
        RSAKeyParameters rSAKeyParameters;
        if (!(object instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + JDKDigestSignature.getType(object) + ") is not a RSAPrivateKey instance");
        }
        if ((object = (RSAPrivateKey)object) instanceof RSAPrivateCrtKey) {
            object = (RSAPrivateCrtKey)object;
            rSAKeyParameters = new RSAPrivateCrtKeyParameters(object.getModulus(), object.getPublicExponent(), object.getPrivateExponent(), object.getPrimeP(), object.getPrimeQ(), object.getPrimeExponentP(), object.getPrimeExponentQ(), object.getCrtCoefficient());
        } else {
            rSAKeyParameters = new RSAKeyParameters(true, object.getModulus(), object.getPrivateExponent());
        }
        object = rSAKeyParameters;
        this.digest.reset();
        this.cipher.init(true, (CipherParameters)object);
    }

    private static String getType(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[20];
        this.digest.doFinal(byArray, 0);
        try {
            byArray = this.derEncode(byArray);
            return this.cipher.processBlock(byArray, 0, byArray.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        byte[] byArray3 = new byte[20];
        this.digest.doFinal(byArray3, 0);
        try {
            byArray = this.cipher.processBlock(byArray, 0, byArray.length);
            byArray2 = this.derEncode(byArray3);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray.length == byArray2.length) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        } else if (byArray.length == byArray2.length - 2) {
            int n;
            int n2 = byArray.length - byArray3.length - 2;
            int n3 = byArray2.length - byArray3.length - 2;
            byArray2[1] = (byte)(byArray2[1] - 2);
            byArray2[3] = (byte)(byArray2[3] - 2);
            for (n = 0; n < byArray3.length; ++n) {
                if (byArray[n2 + n] == byArray2[n3 + n]) continue;
                return false;
            }
            for (n = 0; n < n2; ++n) {
                if (byArray[n] == byArray2[n]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] derEncode(byte[] object) throws IOException {
        if (this.algId == null) {
            return object;
        }
        DigestInfo digestInfo = new DigestInfo(this.algId, (byte[])object);
        object = digestInfo;
        return digestInfo.getEncoded("DER");
    }

    public class SHA1WithRSAEncryption
    extends JDKDigestSignature {
        public SHA1WithRSAEncryption() {
            super(X509ObjectIdentifiers.id_SHA1, new SHA1Digest(), new PKCS1Encoding(new RSABlindedEngine()));
        }
    }
}

