/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.bouncycastle.jce.provider.asymmetric.ec.ECUtil;

public abstract class JDKKeyPairGenerator
extends KeyPairGenerator {
    public JDKKeyPairGenerator(String string) {
        super(string);
    }

    public final class RSA
    extends JDKKeyPairGenerator {
        private static BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        private RSAKeyGenerationParameters param;
        private RSAKeyPairGenerator engine = new RSAKeyPairGenerator();

        public RSA() {
            super("RSA");
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 12);
            this.engine.init$7345ead7(this.param);
        }

        @Override
        public final void initialize(int n, SecureRandom secureRandom) {
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, secureRandom, n, 12);
            this.engine.init$7345ead7(this.param);
        }

        @Override
        public final void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
            }
            algorithmParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
            this.param = new RSAKeyGenerationParameters(((RSAKeyGenParameterSpec)algorithmParameterSpec).getPublicExponent(), secureRandom, ((RSAKeyGenParameterSpec)algorithmParameterSpec).getKeysize(), 12);
            this.engine.init$7345ead7(this.param);
        }

        @Override
        public final KeyPair generateKeyPair() {
            Object object = this.engine.generateKeyPair$4c63f72c();
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)((ECUtil)object).getPublic();
            object = (RSAPrivateCrtKeyParameters)((ECUtil)object).getPrivate();
            return new KeyPair(new JCERSAPublicKey(rSAKeyParameters), new JCERSAPrivateCrtKey((RSAPrivateCrtKeyParameters)object));
        }
    }
}

