/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public final class JCEDHPublicKey
implements DHPublicKey {
    private BigInteger y;
    private DHParameterSpec dhSpec;

    JCEDHPublicKey(SubjectPublicKeyInfo aSN1Encodable) {
        DHParameter dHParameter = new DHParameter((ASN1Sequence)((SubjectPublicKeyInfo)aSN1Encodable).getAlgorithmId().getParameters());
        try {
            aSN1Encodable = (DERInteger)((SubjectPublicKeyInfo)aSN1Encodable).getPublicKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DH public key");
        }
        this.y = ((DERInteger)aSN1Encodable).getValue();
        if (dHParameter.getL() != null) {
            this.dhSpec = new DHParameterSpec(dHParameter.getP(), dHParameter.getG(), dHParameter.getL().intValue());
            return;
        }
        this.dhSpec = new DHParameterSpec(dHParameter.getP(), dHParameter.getG());
    }

    @Override
    public final String getAlgorithm() {
        return "DH";
    }

    @Override
    public final String getFormat() {
        return "X.509";
    }

    @Override
    public final byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DHParameter(this.dhSpec.getP(), this.dhSpec.getG(), this.dhSpec.getL()).getDERObject()), new DERInteger(this.y));
        return subjectPublicKeyInfo.getDEREncoded();
    }

    @Override
    public final DHParameterSpec getParams() {
        return this.dhSpec;
    }

    @Override
    public final BigInteger getY() {
        return this.y;
    }
}

