/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public final class RSAPublicKeyStructure
extends ASN1Encodable {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public RSAPublicKeyStructure(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
    }

    public RSAPublicKeyStructure(ASN1Sequence object) {
        if (((ASN1Sequence)object).size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + ((ASN1Sequence)object).size());
        }
        object = ((ASN1Sequence)object).getObjects();
        this.modulus = DERInteger.getInstance(object.nextElement()).getPositiveValue();
        this.publicExponent = DERInteger.getInstance(object.nextElement()).getPositiveValue();
    }

    public final BigInteger getModulus() {
        return this.modulus;
    }

    public final BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        RSAPublicKeyStructure rSAPublicKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPublicKeyStructure.modulus));
        rSAPublicKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPublicKeyStructure.publicExponent));
        return new DERSequence(aSN1EncodableVector);
    }
}

