/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public final class DERUTCTime
extends ASN1Object {
    private String time;

    public DERUTCTime(String object) {
        this.time = object;
        try {
            object = this;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmssz");
            simpleDateFormat.parse(((DERUTCTime)object).getTime());
            return;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    DERUTCTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.time = new String(cArray);
    }

    public final String getTime() {
        if (this.time.indexOf(45) < 0 && this.time.indexOf(43) < 0) {
            if (this.time.length() == 11) {
                return this.time.substring(0, 10) + "00GMT+00:00";
            }
            return this.time.substring(0, 12) + "GMT+00:00";
        }
        int n = this.time.indexOf(45);
        if (n < 0) {
            n = this.time.indexOf(43);
        }
        String string = this.time;
        if (n == this.time.length() - 3) {
            string = string + "00";
        }
        if (n == 10) {
            return string.substring(0, 10) + "00GMT" + string.substring(10, 13) + ":" + string.substring(13, 15);
        }
        return string.substring(0, 12) + "GMT" + string.substring(12, 15) + ":" + string.substring(15, 17);
    }

    public final String getAdjustedTime() {
        String string = this.getTime();
        if (string.charAt(0) < '5') {
            return "20" + string;
        }
        return "19" + string;
    }

    @Override
    final void encode(DEROutputStream object) throws IOException {
        DEROutputStream dEROutputStream = object;
        object = this;
        char[] cArray = ((DERUTCTime)object).time.toCharArray();
        object = cArray;
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != ((Object)object).length; ++i) {
            byArray[i] = (byte)object[i];
        }
        dEROutputStream.writeEncoded(23, byArray);
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERUTCTime)) {
            return false;
        }
        return this.time.equals(((DERUTCTime)dERObject).time);
    }

    @Override
    public final int hashCode() {
        return this.time.hashCode();
    }

    public final String toString() {
        return this.time;
    }
}

