/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.gui.shell;

import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.kxml2.kdom.Element;
import to_do_o.core.config.SWTConstants;
import to_do_o.core.settings.SettingsStore;
import to_do_o.core.settings.SettingsStoreSingleton;
import to_do_o.gui.IconProvider;
import to_do_o.gui.listener.FitItemTextListenerLinux;
import to_do_o.gui.tree.AbstractItem;
import to_do_o.gui.tree.ToDoItem;
import to_do_o.gui.tree.ToDoTree;

public final class DesktopWidget
implements Listener {
    private Display display;
    private Shell shell;
    private Shell dummyShell;
    private int startX;
    private int startY;
    private int style = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private ToDoTree toDoTree;
    private Composite composite;
    private Table table;
    private static HashMap<String, Comparator<ToDoItem>> comparators = new HashMap<String, 1>();

    public DesktopWidget(Display object, ToDoTree object2) {
        this.display = object;
        this.toDoTree = object2;
        object = SettingsStoreSingleton.getInstance();
        boolean bl = ((SettingsStore)object).getBoolean("DesktopWidgetAlwaysOnTop");
        object2 = this;
        this.style = bl ? ((DesktopWidget)object2).style | 0x4000 : ((DesktopWidget)object2).style & 0xFFFFBFFF;
        this.x = ((SettingsStore)object).getInt("DesktopWidgetX");
        this.y = ((SettingsStore)object).getInt("DesktopWidgetY");
        this.width = ((SettingsStore)object).getInt("DesktopWidgetWidth");
        this.height = ((SettingsStore)object).getInt("DesktopWidgetHeight");
        boolean bl2 = SettingsStoreSingleton.getInstance().getBoolean("ShowDesktopWidgetOnStart");
        if (bl2) {
            this.open();
        }
    }

    private void addDummyRegion() {
        Region region = new Region();
        Point size = this.dummyShell.getSize();
        if (size.x < 60) {
            size.x = 60;
        }
        if (size.y < 60) {
            size.y = 60;
        }
        region.add(0, 0, size.x - 1, size.y - 1);
        region.subtract(10, 10, size.x - 21, size.y - 21);
        this.dummyShell.setRegion(region);
    }

    public final void close() {
        if (!this.isDisposed()) {
            this.shell.dispose();
        }
    }

    private void createTable() {
        this.table = new Table(this.composite, 16);
        this.table.setBackground(this.display.getSystemColor(29));
        if (!SWTConstants.IS_WINDOWS) {
            this.table.addListener(42, (Listener)new FitItemTextListenerLinux());
        }
        TableColumn tableColumn = new TableColumn(this.table, 0);
        TableColumn tableColumn2 = new TableColumn(this.table, 0);
        this.createTableItems(this.toDoTree.getToDoDocument().getRootElement());
        DesktopWidget desktopWidget = this;
        Object object = SettingsStoreSingleton.getInstance();
        object = ((SettingsStore)object).get("DesktopWidgetSortBy");
        if (!((String)object).equals("None")) {
            Object[] objectArray = desktopWidget.table.getItems();
            objectArray = DesktopWidget.getToDoItems(objectArray);
            Arrays.sort(objectArray, comparators.get(object));
            desktopWidget.table.clearAll();
            desktopWidget.fillTable((ToDoItem[])objectArray);
        }
        tableColumn.pack();
        tableColumn2.pack();
        this.composite.layout(true);
    }

    private void fillTable(ToDoItem[] toDoItemArray) {
        for (ToDoItem toDoItem : toDoItemArray) {
            ToDoItem toDoItem2 = (ToDoItem)AbstractItem.newInstance(toDoItem.getElement(), (Widget)this.table, 0);
            this.setColorAndText(toDoItem2);
            toDoItem.getTableItem().dispose();
        }
    }

    private static ToDoItem[] getToDoItems(TableItem[] tableItems) {
        ToDoItem[] ret = new ToDoItem[tableItems.length];
        for (int i = 0; i < tableItems.length; ++i) {
            ret[i] = (ToDoItem)tableItems[i].getData();
        }
        return ret;
    }

    private void createTableItems(Element element) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            Object object = element.getElement(i);
            if (object == null) continue;
            Object object2 = AbstractItem.newInstance((Element)object, (Widget)this.table, 0);
            TableItem tableItem = ((AbstractItem)object2).getTableItem();
            if (!(object2 instanceof ToDoItem)) {
                tableItem.dispose();
                continue;
            }
            this.createTableItems((Element)object);
            object = (ToDoItem)object2;
            object2 = ((ToDoItem)object).getIconColor();
            String string = SettingsStoreSingleton.getInstance().get("DesktopWidgetDisplayedColors");
            if (((ToDoItem)object).isDone() || object2 == null || string.indexOf((String)object2) == -1) {
                tableItem.dispose();
                continue;
            }
            this.setColorAndText((ToDoItem)object);
        }
    }

    private void setColorAndText(ToDoItem object) {
        TableItem tableItem = ((AbstractItem)object).getTableItem();
        if (tableItem == null) {
            return;
        }
        try {
            object = ((ToDoItem)object).getIconColor();
            object = SWT.class.getField("COLOR_DARK_" + (object != null ? ((String)object).toUpperCase() : "BLUE"));
            tableItem.setBackground(0, this.display.getSystemColor(((Field)object).getInt(null)));
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        tableItem.setText(new String[]{"  ", tableItem.getText()});
    }

    public final void handleEvent(Event e) {
        if (((Event)e).type == 24 && !this.shell.isDisposed()) {
            e = this;
            ((DesktopWidget)e).table.dispose();
            super.createTable();
        }
    }

    public final boolean isDisposed() {
        return this.shell == null || this.shell.isDisposed();
    }

    public final void open() {
        if (this.isDisposed()) {
            try {
                DesktopWidget desktopWidget;
                DesktopWidget desktopWidget2 = desktopWidget = this;
                desktopWidget.shell = new Shell(desktopWidget2.display, 8 | desktopWidget2.style);
                desktopWidget2.shell.setText("To-Do-O Desktop Widget");
                desktopWidget2.shell.setLocation(desktopWidget2.x, desktopWidget2.y);
                desktopWidget2.shell.setSize(desktopWidget2.width, desktopWidget2.height);
                Object object = new FormLayout();
                desktopWidget2.shell.setLayout((Layout)object);
                desktopWidget2.shell.setImage(IconProvider.getIconImage("/icons/small_icon.png"));
                desktopWidget2 = desktopWidget;
                object = desktopWidget2;
                Composite composite = new Composite((Composite)object.shell, 0);
                composite.setBackground(object.display.getSystemColor(29));
                Image image = (object.style & 0x4000) != 0 ? IconProvider.getIconImage("/icons/desktop_widget_frame_top_right.png") : IconProvider.getIconImage("/icons/desktop_widget_frame_top_right_empty.png");
                composite.addPaintListener(new PaintListener((DesktopWidget)object, image){
                    private /* synthetic */ Image val$topRightImg;
                    {
                        this.val$topRightImg = image;
                    }

                    public final void paintControl(PaintEvent e) {
                        e.gc.drawImage(this.val$topRightImg, 0, 0);
                    }
                });
                FormData formData = new FormData();
                new FormData().top = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.height = 20;
                formData.width = 20;
                composite.setLayoutData((Object)formData);
                composite.addMouseListener(new MouseListener((DesktopWidget)object){
                    private int deltaX = 0;
                    private int deltaY = 0;
                    private /* synthetic */ DesktopWidget this$0;
                    {
                        this.this$0 = desktopWidget;
                    }

                    public final void mouseDoubleClick(MouseEvent e) {
                        DesktopWidget.access$200(this.this$0);
                    }

                    public final void mouseDown(MouseEvent e) {
                        this.deltaX = e.x;
                        this.deltaY = e.y;
                    }

                    public final void mouseUp(MouseEvent e) {
                        if (this.this$0.dummyShell != null && !this.this$0.dummyShell.isDisposed()) {
                            this.this$0.dummyShell.dispose();
                        }
                        if (e == null || (e.stateMask & 0x80000) == 0 || this.deltaX == 0 || this.deltaY == 0) {
                            return;
                        }
                        MouseEvent mouseEvent = e;
                        e = this;
                        e.deltaX -= mouseEvent.x;
                        e.deltaY -= mouseEvent.y;
                        e.this$0.x = ((DesktopWidget)e.this$0).shell.getLocation().x - e.deltaX;
                        e.this$0.y = ((DesktopWidget)e.this$0).shell.getLocation().y - e.deltaY;
                        e.this$0.shell.setLocation(e.this$0.x, e.this$0.y);
                        e.deltaX = 0;
                        e.deltaY = 0;
                    }
                });
                composite.addMouseMoveListener(new MouseMoveListener((DesktopWidget)object){
                    private /* synthetic */ DesktopWidget this$0;
                    {
                        this.this$0 = desktopWidget;
                    }

                    public final void mouseMove(MouseEvent e) {
                        if (e == null || (e.stateMask & 0x80000) == 0) {
                            if (this.this$0.dummyShell != null && !this.this$0.dummyShell.isDisposed()) {
                                this.this$0.dummyShell.dispose();
                            }
                            return;
                        }
                        DesktopWidget.access$600(this.this$0, e);
                        this.this$0.dummyShell.setLocation(((DesktopWidget)this.this$0).shell.getLocation().x + e.x - this.this$0.startX, ((DesktopWidget)this.this$0).shell.getLocation().y + e.y - this.this$0.startY);
                    }
                });
                object = desktopWidget2;
                composite = new Composite((Composite)object.shell, 0);
                composite.setBackground(object.display.getSystemColor(29));
                image = IconProvider.getIconImage("/icons/desktop_widget_frame_bottom_right.png");
                composite.addPaintListener(new PaintListener((DesktopWidget)object, image){
                    private /* synthetic */ Image val$bottomRightImg;
                    {
                        this.val$bottomRightImg = image;
                    }

                    public final void paintControl(PaintEvent e) {
                        e.gc.drawImage(this.val$bottomRightImg, 0, 0);
                    }
                });
                formData = new FormData();
                new FormData().bottom = new FormAttachment(100, 0);
                formData.right = new FormAttachment(100, 0);
                formData.height = 20;
                formData.width = 20;
                composite.setLayoutData((Object)formData);
                composite.addMouseListener(new MouseListener((DesktopWidget)object){
                    private int deltaX;
                    private int deltaY;
                    private /* synthetic */ DesktopWidget this$0;
                    {
                        this.this$0 = desktopWidget;
                    }

                    public final void mouseDoubleClick(MouseEvent arg0) {
                    }

                    public final void mouseDown(MouseEvent e) {
                        this.deltaX = e.x;
                        this.deltaY = e.y;
                    }

                    public final void mouseUp(MouseEvent e) {
                        if (this.this$0.dummyShell != null && !this.this$0.dummyShell.isDisposed()) {
                            this.this$0.dummyShell.dispose();
                        }
                        if (e == null || (e.stateMask & 0x80000) == 0) {
                            return;
                        }
                        MouseEvent mouseEvent = e;
                        e = this;
                        e.deltaX -= mouseEvent.x;
                        e.deltaY -= mouseEvent.y;
                        e.this$0.width = ((DesktopWidget)e.this$0).shell.getSize().x - e.deltaX;
                        e.this$0.height = ((DesktopWidget)e.this$0).shell.getSize().y - e.deltaY;
                        if (e.this$0.width < 60) {
                            e.this$0.width = 60;
                        }
                        if (e.this$0.height < 60) {
                            e.this$0.height = 60;
                        }
                        e.this$0.shell.setSize(e.this$0.width, e.this$0.height);
                    }
                });
                composite.addMouseMoveListener(new MouseMoveListener((DesktopWidget)object){
                    private /* synthetic */ DesktopWidget this$0;
                    {
                        this.this$0 = desktopWidget;
                    }

                    public final void mouseMove(MouseEvent object) {
                        if (object == null || (object.stateMask & 0x80000) == 0) {
                            if (this.this$0.dummyShell != null && !this.this$0.dummyShell.isDisposed()) {
                                this.this$0.dummyShell.dispose();
                            }
                            return;
                        }
                        MouseEvent mouseEvent = object;
                        object = this;
                        DesktopWidget.access$600(object.this$0, mouseEvent);
                        int n = ((DesktopWidget)object.this$0).shell.getSize().x + mouseEvent.x - object.this$0.startX;
                        int n2 = ((DesktopWidget)object.this$0).shell.getSize().y + mouseEvent.y - object.this$0.startY;
                        if (n < 60) {
                            n = 60;
                        }
                        if (n2 < 60) {
                            n2 = 60;
                        }
                        object.this$0.dummyShell.setSize(n, n2);
                    }
                });
                desktopWidget2 = desktopWidget;
                object = new Composite((Composite)desktopWidget2.shell, 0);
                object.setBackground(desktopWidget2.display.getSystemColor(15));
                composite = new FormData();
                new FormData().top = new FormAttachment(0, 0);
                composite.left = new FormAttachment(0, 0);
                composite.right = new FormAttachment(100, 0);
                composite.height = 1;
                object.setLayoutData((Object)composite);
                image = new Composite((Composite)desktopWidget2.shell, 0);
                image.setBackground(desktopWidget2.display.getSystemColor(15));
                formData = new FormData();
                new FormData().bottom = new FormAttachment(100, 0);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.height = 1;
                image.setLayoutData((Object)formData);
                object = new Composite((Composite)desktopWidget2.shell, 0);
                object.setBackground(desktopWidget2.display.getSystemColor(15));
                composite = new FormData();
                new FormData().top = new FormAttachment(0, 0);
                composite.bottom = new FormAttachment(100, 0);
                composite.left = new FormAttachment(0, 0);
                composite.width = 1;
                object.setLayoutData((Object)composite);
                object = new Composite((Composite)desktopWidget2.shell, 0);
                object.setBackground(desktopWidget2.display.getSystemColor(15));
                desktopWidget2 = new FormData();
                new FormData().top = new FormAttachment(0, 0);
                ((FormData)desktopWidget2).bottom = new FormAttachment(100, 0);
                ((FormData)desktopWidget2).right = new FormAttachment(100, 0);
                ((FormData)desktopWidget2).width = 1;
                object.setLayoutData((Object)desktopWidget2);
                desktopWidget.composite = new Composite((Composite)desktopWidget.shell, 0);
                desktopWidget.composite.setLayout((Layout)new FillLayout());
                desktopWidget2 = new FormData();
                desktopWidget.composite.setBackground(desktopWidget.display.getSystemColor(29));
                ((FormData)desktopWidget2).top = new FormAttachment(0, 0);
                ((FormData)desktopWidget2).bottom = new FormAttachment(100, 0);
                ((FormData)desktopWidget2).left = new FormAttachment(0, 0);
                ((FormData)desktopWidget2).right = new FormAttachment(100, 0);
                desktopWidget.composite.setLayoutData((Object)desktopWidget2);
                desktopWidget2 = desktopWidget;
                desktopWidget2.shell.addDisposeListener(new DisposeListener(desktopWidget2){
                    private /* synthetic */ DesktopWidget this$0;
                    {
                        this.this$0 = desktopWidget;
                    }

                    public final void widgetDisposed(DisposeEvent e) {
                        SettingsStore settingsStore = SettingsStoreSingleton.getInstance();
                        settingsStore.set("DesktopWidgetWidth", String.valueOf(((DesktopWidget)this.this$0).shell.getSize().x));
                        settingsStore.set("DesktopWidgetHeight", String.valueOf(((DesktopWidget)this.this$0).shell.getSize().y));
                        settingsStore.set("DesktopWidgetX", String.valueOf(((DesktopWidget)this.this$0).shell.getLocation().x));
                        settingsStore.set("DesktopWidgetY", String.valueOf(((DesktopWidget)this.this$0).shell.getLocation().y));
                        settingsStore.storeSettings();
                    }
                });
                desktopWidget.shell.layout();
                desktopWidget.shell.open();
                this.createTable();
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                fileNotFoundException.printStackTrace();
            }
        }
    }

    public final void setToDoTree(ToDoTree toDoTree) {
        this.toDoTree = toDoTree;
        toDoTree.addListener(24, this);
    }

    static /* synthetic */ void access$200(DesktopWidget x0) {
        v0.style = x0.style ^ 0x4000;
        x0.shell.dispose();
        x0.open();
    }

    static /* synthetic */ void access$600(DesktopWidget x0, MouseEvent x1) {
        if (x0.dummyShell == null || x0.dummyShell.isDisposed()) {
            x0.startX = x1.x;
            x0.startY = x1.y;
            x0.dummyShell = new Shell(x0.display, 16392);
            x0.dummyShell.setSize(x0.shell.getSize());
            x0.dummyShell.setLocation(x0.shell.getLocation());
            x0.addDummyRegion();
            x0.dummyShell.addControlListener(new ControlListener(x0){
                private /* synthetic */ DesktopWidget this$0;
                {
                    this.this$0 = desktopWidget;
                }

                public final void controlResized(ControlEvent arg0) {
                    this.this$0.addDummyRegion();
                }

                public final void controlMoved(ControlEvent arg0) {
                }
            });
            x0.dummyShell.layout();
            x0.dummyShell.open();
        }
    }

    static {
        comparators.put("Text", new Comparator<ToDoItem>(){});
        comparators.put("Color", new Comparator<ToDoItem>(){});
        comparators.put("Date", new Comparator<ToDoItem>(){});
        comparators.put("Color+Text", new Comparator<ToDoItem>(){});
        comparators.put("Color+Date", new Comparator<ToDoItem>(){});
        comparators.put("Date+Text", new Comparator<ToDoItem>(){});
        comparators.put("Color+Date+Text", new Comparator<ToDoItem>(){});
    }
}

