/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509Extension;

public final class X509Extensions
extends ASN1Encodable {
    public static final DERObjectIdentifier KeyUsage;
    public static final DERObjectIdentifier SubjectAlternativeName;
    public static final DERObjectIdentifier BasicConstraints;
    public static final DERObjectIdentifier CRLNumber;
    public static final DERObjectIdentifier DeltaCRLIndicator;
    public static final DERObjectIdentifier IssuingDistributionPoint;
    public static final DERObjectIdentifier NameConstraints;
    public static final DERObjectIdentifier CRLDistributionPoints;
    public static final DERObjectIdentifier CertificatePolicies;
    public static final DERObjectIdentifier PolicyMappings;
    public static final DERObjectIdentifier AuthorityKeyIdentifier;
    public static final DERObjectIdentifier PolicyConstraints;
    public static final DERObjectIdentifier FreshestCRL;
    public static final DERObjectIdentifier InhibitAnyPolicy;
    private Hashtable extensions = new Hashtable();
    private Vector ordering = new Vector();

    public static X509Extensions getInstance(Object object) {
        while (true) {
            if (object == null || object instanceof X509Extensions) {
                return (X509Extensions)object;
            }
            if (object instanceof ASN1Sequence) {
                return new X509Extensions((ASN1Sequence)object);
            }
            if (!(object instanceof ASN1TaggedObject)) break;
            object = ((ASN1TaggedObject)object).getObject();
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    private X509Extensions(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        while (object.hasMoreElements()) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(object.nextElement());
            if (aSN1Sequence.size() == 3) {
                this.extensions.put(aSN1Sequence.getObjectAt(0), new X509Extension(DERBoolean.getInstance(aSN1Sequence.getObjectAt(1)), ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2))));
            } else if (aSN1Sequence.size() == 2) {
                this.extensions.put(aSN1Sequence.getObjectAt(0), new X509Extension(false, ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1))));
            } else {
                throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
            }
            this.ordering.addElement(aSN1Sequence.getObjectAt(0));
        }
    }

    public X509Extensions(Vector enumeration, Hashtable hashtable) {
        enumeration = enumeration == null ? hashtable.keys() : ((Vector)((Object)enumeration)).elements();
        while (enumeration.hasMoreElements()) {
            this.ordering.addElement(enumeration.nextElement());
        }
        enumeration = this.ordering.elements();
        while (enumeration.hasMoreElements()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
            X509Extension x509Extension = (X509Extension)hashtable.get(dERObjectIdentifier);
            this.extensions.put(dERObjectIdentifier, x509Extension);
        }
    }

    public final Enumeration oids() {
        return this.ordering.elements();
    }

    public final X509Extension getExtension(DERObjectIdentifier dERObjectIdentifier) {
        return (X509Extension)this.extensions.get(dERObjectIdentifier);
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.ordering.elements();
        while (enumeration.hasMoreElements()) {
            Object object = (DERObjectIdentifier)enumeration.nextElement();
            X509Extension x509Extension = (X509Extension)this.extensions.get(object);
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((DEREncodable)object);
            object = x509Extension;
            if (((X509Extension)object).critical) {
                aSN1EncodableVector2.add(new DERBoolean(true));
            }
            object = x509Extension;
            aSN1EncodableVector2.add(((X509Extension)object).value);
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    static {
        new DERObjectIdentifier("2.5.29.9");
        new DERObjectIdentifier("2.5.29.14");
        KeyUsage = new DERObjectIdentifier("2.5.29.15");
        new DERObjectIdentifier("2.5.29.16");
        SubjectAlternativeName = new DERObjectIdentifier("2.5.29.17");
        new DERObjectIdentifier("2.5.29.18");
        BasicConstraints = new DERObjectIdentifier("2.5.29.19");
        CRLNumber = new DERObjectIdentifier("2.5.29.20");
        new DERObjectIdentifier("2.5.29.21");
        new DERObjectIdentifier("2.5.29.23");
        new DERObjectIdentifier("2.5.29.24");
        DeltaCRLIndicator = new DERObjectIdentifier("2.5.29.27");
        IssuingDistributionPoint = new DERObjectIdentifier("2.5.29.28");
        new DERObjectIdentifier("2.5.29.29");
        NameConstraints = new DERObjectIdentifier("2.5.29.30");
        CRLDistributionPoints = new DERObjectIdentifier("2.5.29.31");
        CertificatePolicies = new DERObjectIdentifier("2.5.29.32");
        PolicyMappings = new DERObjectIdentifier("2.5.29.33");
        AuthorityKeyIdentifier = new DERObjectIdentifier("2.5.29.35");
        PolicyConstraints = new DERObjectIdentifier("2.5.29.36");
        new DERObjectIdentifier("2.5.29.37");
        FreshestCRL = new DERObjectIdentifier("2.5.29.46");
        InhibitAnyPolicy = new DERObjectIdentifier("2.5.29.54");
        new DERObjectIdentifier("1.3.6.1.5.5.7.1.1");
        new DERObjectIdentifier("1.3.6.1.5.5.7.1.11");
        new DERObjectIdentifier("1.3.6.1.5.5.7.1.12");
        new DERObjectIdentifier("1.3.6.1.5.5.7.1.2");
        new DERObjectIdentifier("1.3.6.1.5.5.7.1.3");
        new DERObjectIdentifier("1.3.6.1.5.5.7.1.4");
        new DERObjectIdentifier("2.5.29.56");
        new DERObjectIdentifier("2.5.29.55");
    }
}

