/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class SubjectPublicKeyInfo
extends ASN1Encodable {
    private AlgorithmIdentifier algId;
    private DERBitString keyData;

    public static SubjectPublicKeyInfo getInstance(Object object) {
        if (object instanceof SubjectPublicKeyInfo) {
            return (SubjectPublicKeyInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SubjectPublicKeyInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, DEREncodable dEREncodable) {
        this.keyData = new DERBitString(dEREncodable);
        this.algId = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.keyData = new DERBitString(byArray);
        this.algId = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(ASN1Sequence object) {
        if (((ASN1Sequence)object).size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + ((ASN1Sequence)object).size());
        }
        object = ((ASN1Sequence)object).getObjects();
        this.algId = AlgorithmIdentifier.getInstance(object.nextElement());
        this.keyData = DERBitString.getInstance(object.nextElement());
    }

    public final AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public final DERObject getPublicKey() throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(this.keyData.getBytes());
        return aSN1InputStream.readObject();
    }

    public final DERBitString getPublicKeyData() {
        return this.keyData;
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.algId);
        aSN1EncodableVector.add(this.keyData);
        return new DERSequence(aSN1EncodableVector);
    }
}

