/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.gui.shell;

import org.bouncycastle.asn1.util.ASN1Dump;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import to_do_o.core.Constants;
import to_do_o.core.io.net.SyncClient;
import to_do_o.core.settings.SettingsStore;
import to_do_o.core.settings.SettingsStoreSingleton;
import to_do_o.gui.dialog.AboutDialog;
import to_do_o.gui.dialog.CancelDialog;
import to_do_o.gui.dialog.SettingsDialog;
import to_do_o.gui.dialog.TextInputDialog;
import to_do_o.gui.dialog.TodoIconSelectorDialog;
import to_do_o.gui.tree.AbstractItem;
import to_do_o.gui.tree.NoteItem;
import to_do_o.gui.tree.ToDoItem;
import to_do_o.gui.tree.ToDoTree;
import to_do_o.gui.tree.action.tree_item.DeleteDoneItemsAction;
import to_do_o.gui.tree.action.tree_item.EditItemAction;
import to_do_o.gui.tree.action.tree_item.MarkDoneAction;
import to_do_o.gui.tree.action.tree_item.MarkToDoAction;
import to_do_o.gui.tree.action.tree_item.MoveDoneItemsToBottomAction;

public class MainShell
implements SelectionListener,
Listener {
    protected Shell shell;
    private Display display;
    private boolean hasChanged = false;
    protected ToDoTree toDoTree;
    protected SettingsDialog settingsDialog;
    private AbstractItem from;
    private boolean deleteFrom = false;
    private Command cmdExit;
    private Menu menuBar;
    private Menu menuItem;
    private Menu menuFile;
    private Menu menuNew;
    private Menu menuNewSub;
    protected Menu menuTools;
    private MenuItem itmMenuItem;
    private MenuItem itmMenuFile;
    private MenuItem itmMenuNew;
    private MenuItem itmMenuTools;
    protected MenuItem itmMenuAbout;
    private MenuItem itmLoad;
    private MenuItem itmSave;
    private MenuItem itmImport;
    private MenuItem itmExport;
    private MenuItem itmSettings;
    private MenuItem itmExit;
    private MenuItem itmNewMainTodo;
    private MenuItem itmMenuNewSub;
    private MenuItem itmNewSubTodo;
    private MenuItem itmNewSubNote;
    private MenuItem itmEdit;
    private MenuItem itmSetTodoIcon;
    private MenuItem itmMarkDone;
    private MenuItem itmMarkAllDone;
    private MenuItem itmMarkTodo;
    private MenuItem itmMarkAllTodo;
    private MenuItem itmCut;
    private MenuItem itmCopy;
    private MenuItem itmPaste;
    private MenuItem itmDelete;
    private MenuItem itmClearSelection;
    private MenuItem itmMoveDoneToBottom;
    private MenuItem itmMoveAllDoneToBottom;
    private MenuItem itmDeleteDone;
    private MenuItem itmDeleteAllDone;
    private MenuItem itmSync;
    protected Menu popupMenu;
    protected SelectionListener lstAbout = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetSelected(SelectionEvent arg0) {
            new AboutDialog(this.this$0.shell).open();
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }
    };
    protected SelectionListener lstCut = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent selectionEvent) {
            this.this$0.from = this.this$0.toDoTree.getSelection();
            this.this$0.deleteFrom = true;
            this.this$0.enablePaste();
        }
    };
    protected SelectionListener lstCopy = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent selectionEvent) {
            this.this$0.from = this.this$0.toDoTree.getSelection();
            this.this$0.deleteFrom = false;
            this.this$0.enablePaste();
        }
    };
    protected SelectionListener lstPaste = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            AbstractItem to = this.this$0.toDoTree.getSelection();
            if (!(to == null || to == this.this$0.from && this.this$0.deleteFrom)) {
                this.this$0.toDoTree.moveTreeItem(this.this$0.from.getTreeItem(), to.getTreeItem(), this.this$0.deleteFrom);
                if (this.this$0.deleteFrom) {
                    this.this$0.disablePaste();
                }
            }
        }
    };
    protected SelectionListener lstMarkTodo = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            this.this$0.toDoTree.executeActionOnSelectedTreeItem(new MarkToDoAction(this.this$0.toDoTree), false);
        }
    };
    protected SelectionListener lstMarkAllTodo = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            MarkToDoAction markToDoAction = new MarkToDoAction(this.this$0.toDoTree);
            this.this$0.toDoTree.executeActionOnSelectedTreeItem(markToDoAction, true);
        }
    };
    protected SelectionListener lstMarkDone = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            this.this$0.toDoTree.executeActionOnSelectedTreeItem(new MarkDoneAction(this.this$0.toDoTree), false);
        }
    };
    protected SelectionListener lstMarkAllDone = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            MarkDoneAction markDoneAction = new MarkDoneAction(this.this$0.toDoTree);
            this.this$0.toDoTree.executeActionOnSelectedTreeItem(markDoneAction, true);
        }
    };
    protected SelectionListener lstEdit = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            this.this$0.toDoTree.executeActionOnSelectedTreeItem(new EditItemAction(this.this$0.toDoTree), false);
        }
    };
    protected SelectionListener lstDelete = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            AbstractItem tid = this.this$0.toDoTree.getSelection();
            ASN1Dump d = new ASN1Dump(this.this$0.shell, "Delete:\n'" + tid.getText() + "' ?");
            if (d.answerYes()) {
                tid.delete();
            }
        }
    };
    protected SelectionListener lstSetIcon = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent object) {
            AbstractItem abstractItem;
            object = new TodoIconSelectorDialog(this.this$0.shell);
            if ((object = object.open()) != null && (abstractItem = this.this$0.toDoTree.getSelection()) instanceof ToDoItem) {
                ((ToDoItem)abstractItem).setIconColor((String)object);
            }
        }
    };
    private SelectionListener lstSync = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent object) {
            object = new CancelDialog(this.this$0.shell, "Performing sync...");
            SyncClient syncClient = new SyncClient((CancelDialog)((Object)object));
            Thread thread = new Thread(syncClient);
            thread.start();
            boolean bl = ((CancelDialog)((Object)object)).open();
            if (bl) {
                if (!thread.isAlive()) {
                    syncClient.closeSockets();
                    try {
                        thread.join();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedException interruptedException2 = interruptedException;
                        interruptedException.printStackTrace();
                        return;
                    }
                }
            } else {
                this.this$0.loadTreeFromRecordStore();
                this.this$0.shell.layout();
                this.this$0.createMenu();
                this.this$0.widgetSelected(null);
                this.this$0.unsetChanged();
            }
        }
    };
    protected SelectionListener lstNewSubTodo = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent e) {
            MainShell.access$200(this.this$0, "New Sub To-Do", "to-do");
        }
    };
    protected SelectionListener lstNewSubNote = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent e) {
            MainShell.access$200(this.this$0, "New Note", "note");
        }
    };
    private SelectionListener lstExit = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void widgetSelected(SelectionEvent object) {
            if (!this.this$0.hasChanged) {
                this.this$0.shell.dispose();
                return;
            }
            object = SettingsStoreSingleton.getInstance();
            if (!((SettingsStore)object).getBoolean("SaveOnClose")) {
                object = new ASN1Dump(this.this$0.shell, "Exit without saving?");
                if (!object.answerYes()) return;
                this.this$0.shell.dispose();
                return;
            }
            if (((SettingsStore)object).getBoolean("AutoSaveOnClose")) {
                this.this$0.toDoTree.saveTreeToRecordStore();
                this.this$0.shell.dispose();
                return;
            }
            object = new ASN1Dump(this.this$0.shell, "Save and exit?");
            if (!object.answerYes()) return;
            this.this$0.toDoTree.saveTreeToRecordStore();
            this.this$0.shell.dispose();
        }
    };
    protected SelectionListener lstMoveDoneToBottom = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            ASN1Dump d = new ASN1Dump(this.this$0.shell, "Move items marked as done to the bottom?");
            if (d.answerYes()) {
                new MoveDoneItemsToBottomAction(this.this$0.toDoTree).execute();
            }
        }
    };
    protected SelectionListener lstMoveAllDoneToBottom = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            ASN1Dump d = new ASN1Dump(this.this$0.shell, "Move all items, including subitems, marked as done to the bottom?");
            if (d.answerYes()) {
                this.this$0.toDoTree.executeActionOnSelectedTreeItem(new MoveDoneItemsToBottomAction(this.this$0.toDoTree), true);
            }
        }
    };
    protected SelectionListener lstDeleteDone = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            ASN1Dump d = new ASN1Dump(this.this$0.shell, "Delete items marked as done?");
            if (d.answerYes()) {
                this.this$0.toDoTree.executeActionOnSelectedTreeItem(new DeleteDoneItemsAction(this.this$0.toDoTree), false);
            }
        }
    };
    protected SelectionListener lstDeleteAllDone = new SelectionListener(this){
        private /* synthetic */ MainShell this$0;
        {
            this.this$0 = mainShell;
        }

        public final void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public final void widgetSelected(SelectionEvent arg0) {
            ASN1Dump d = new ASN1Dump(this.this$0.shell, "Delete all items from the whole tree which are marked as done?");
            if (d.answerYes()) {
                this.this$0.toDoTree.executeActionOnTree(new DeleteDoneItemsAction(this.this$0.toDoTree), true);
            }
        }
    };

    public MainShell(Display display) {
        this.display = display;
        this.openShell();
    }

    private void addListeners() {
        this.toDoTree.addSelectionListener(this);
        this.toDoTree.addListener(24, this);
    }

    public final void closeShell() {
        this.lstExit.widgetSelected(null);
    }

    protected void createMenu() {
        this.menuBar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(this.menuBar);
        this.menuFile = new Menu(this.menuBar);
        this.itmMenuFile = new MenuItem(this.menuBar, 64);
        this.itmMenuFile.setText("File");
        this.itmMenuFile.setMenu(this.menuFile);
        this.menuNew = new Menu(this.menuBar);
        this.itmMenuNew = new MenuItem(this.menuBar, 64);
        this.itmMenuNew.setText("New");
        this.itmMenuNew.setMenu(this.menuNew);
        if (!Constants.EMBEDDED) {
            this.menuItem = new Menu(this.menuBar);
            this.itmMenuItem = new MenuItem(this.menuBar, 64);
        } else {
            this.popupMenu = new Menu((Decorations)this.shell, 8);
            this.menuItem = new Menu(this.popupMenu);
            this.itmMenuItem = new MenuItem(this.popupMenu, 64);
            this.toDoTree.setMenu(this.popupMenu);
        }
        this.itmMenuItem.setText("Item");
        this.itmMenuItem.setMenu(this.menuItem);
        this.menuNewSub = new Menu(this.menuNew);
        this.menuTools = new Menu(this.menuBar);
        this.itmMenuTools = new MenuItem(this.menuBar, 64);
        this.itmMenuTools.setText("Tools");
        this.itmMenuTools.setMenu(this.menuTools);
        this.itmMenuAbout = new MenuItem(this.menuBar, 8);
        this.itmMenuAbout.setText("About");
        this.itmMenuAbout.addSelectionListener(this.lstAbout);
        this.itmLoad = new MenuItem(this.menuFile, 8);
        this.itmLoad.setText("Load");
        this.itmLoad.addSelectionListener(new SelectionListener(this){
            private /* synthetic */ MainShell this$0;
            {
                this.this$0 = mainShell;
            }

            public final void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public final void widgetSelected(SelectionEvent arg0) {
                ASN1Dump d = new ASN1Dump(this.this$0.shell, "Load?");
                if (d.answerYes()) {
                    this.this$0.loadTreeFromRecordStore();
                    this.this$0.shell.layout();
                    this.this$0.createMenu();
                    this.this$0.widgetSelected(null);
                    this.this$0.unsetChanged();
                }
            }
        });
        this.itmSave = new MenuItem(this.menuFile, 8);
        this.itmSave.setText("Save");
        this.itmSave.addSelectionListener(new SelectionListener(this){
            private /* synthetic */ MainShell this$0;
            {
                this.this$0 = mainShell;
            }

            public final void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public final void widgetSelected(SelectionEvent e) {
                ASN1Dump d = new ASN1Dump(this.this$0.shell, "Save?");
                if (d.answerYes()) {
                    this.this$0.toDoTree.saveTreeToRecordStore();
                    this.this$0.unsetChanged();
                }
            }
        });
        new MenuItem(this.menuFile, 2);
        this.itmImport = new MenuItem(this.menuFile, 8);
        this.itmImport.setText("Import");
        this.itmImport.addSelectionListener(new SelectionListener(this){
            private /* synthetic */ MainShell this$0;
            {
                this.this$0 = mainShell;
            }

            public final void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public final void widgetSelected(SelectionEvent arg0) {
                ASN1Dump d = new ASN1Dump(this.this$0.shell, "Import File?");
                if (d.answerYes()) {
                    SettingsStore s = SettingsStoreSingleton.getInstance();
                    this.this$0.loadTreeFromXMLFile(s.get("FileName"));
                    this.this$0.createMenu();
                    this.this$0.shell.layout();
                    this.this$0.toDoTree.getTree().notifyListeners(24, null);
                }
            }
        });
        this.itmExport = new MenuItem(this.menuFile, 8);
        this.itmExport.setText("Export");
        this.itmExport.addSelectionListener(new SelectionListener(this){
            private /* synthetic */ MainShell this$0;
            {
                this.this$0 = mainShell;
            }

            public final void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public final void widgetSelected(SelectionEvent arg0) {
                ASN1Dump d = new ASN1Dump(this.this$0.shell, "Export File?");
                if (d.answerYes()) {
                    SettingsStore s = SettingsStoreSingleton.getInstance();
                    this.this$0.toDoTree.saveTreeToXMLFile(s.get("FileName"));
                    this.this$0.shell.layout();
                }
            }
        });
        new MenuItem(this.menuFile, 2);
        this.itmSettings = new MenuItem(this.menuFile, 8);
        this.itmSettings.setText("Settings");
        this.itmSettings.addSelectionListener(new SelectionListener(this){
            private /* synthetic */ MainShell this$0;
            {
                this.this$0 = mainShell;
            }

            public final void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public final void widgetSelected(SelectionEvent e) {
                this.this$0.settingsDialog.open();
            }
        });
        this.itmNewMainTodo = new MenuItem(this.menuNew, 8);
        this.itmNewMainTodo.setText("Main To-Do Entry");
        this.itmNewMainTodo.addSelectionListener(new SelectionListener(this){
            private /* synthetic */ MainShell this$0;
            {
                this.this$0 = mainShell;
            }

            public final void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public final void widgetSelected(SelectionEvent e) {
                TextInputDialog textInput = new TextInputDialog(this.this$0.shell, "New Main To-Do Entry");
                String text = textInput.open();
                if (text != null) {
                    this.this$0.toDoTree.createTreeEntry(text, "to-do");
                }
            }
        });
        this.itmMenuNewSub = new MenuItem(this.menuNew, 64);
        this.itmMenuNewSub.setText("Sub");
        this.itmMenuNewSub.setMenu(this.menuNewSub);
        this.itmNewSubTodo = new MenuItem(this.menuNewSub, 8);
        this.itmNewSubTodo.setText("To-Do");
        this.itmNewSubTodo.addSelectionListener(this.lstNewSubTodo);
        this.itmNewSubNote = new MenuItem(this.menuNewSub, 8);
        this.itmNewSubNote.setText("Note");
        this.itmNewSubNote.addSelectionListener(this.lstNewSubNote);
        this.itmEdit = new MenuItem(this.menuItem, 8);
        this.itmEdit.setText("Edit");
        this.itmEdit.addSelectionListener(this.lstEdit);
        this.itmSetTodoIcon = new MenuItem(this.menuItem, 8);
        this.itmSetTodoIcon.setText("Set Icon");
        this.itmSetTodoIcon.addSelectionListener(this.lstSetIcon);
        this.itmMarkDone = new MenuItem(this.menuItem, 8);
        this.itmMarkDone.setText("Mark Done");
        this.itmMarkDone.addSelectionListener(this.lstMarkDone);
        this.itmMarkAllDone = new MenuItem(this.menuItem, 8);
        this.itmMarkAllDone.setText("Mark All Done");
        this.itmMarkAllDone.addSelectionListener(this.lstMarkAllDone);
        this.itmMarkTodo = new MenuItem(this.menuItem, 8);
        this.itmMarkTodo.setText("Mark To-Do");
        this.itmMarkTodo.addSelectionListener(this.lstMarkTodo);
        this.itmMarkAllTodo = new MenuItem(this.menuItem, 8);
        this.itmMarkAllTodo.setText("Mark All To-Do");
        this.itmMarkAllTodo.addSelectionListener(this.lstMarkAllTodo);
        new MenuItem(this.menuItem, 2);
        this.itmCut = new MenuItem(this.menuItem, 8);
        this.itmCut.setText("Cut");
        this.itmCut.addSelectionListener(this.lstCut);
        this.itmCopy = new MenuItem(this.menuItem, 8);
        this.itmCopy.setText("Copy");
        this.itmCopy.addSelectionListener(this.lstCopy);
        this.itmPaste = new MenuItem(this.menuItem, 8);
        this.itmPaste.setText("Paste");
        this.itmPaste.setEnabled(false);
        this.itmPaste.addSelectionListener(this.lstPaste);
        new MenuItem(this.menuItem, 2);
        this.itmClearSelection = new MenuItem(this.menuItem, 8);
        this.itmClearSelection.setText("Clear Selection");
        this.itmClearSelection.addSelectionListener(new SelectionListener(this){
            private /* synthetic */ MainShell this$0;
            {
                this.this$0 = mainShell;
            }

            public final void widgetSelected(SelectionEvent arg0) {
                this.this$0.toDoTree.getTree().deselectAll();
                this.this$0.widgetSelected(null);
            }

            public final void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        new MenuItem(this.menuItem, 2);
        this.itmDelete = new MenuItem(this.menuItem, 8);
        this.itmDelete.setText("Delete");
        this.itmDelete.addSelectionListener(this.lstDelete);
        this.itmMoveDoneToBottom = new MenuItem(this.menuTools, 8);
        this.itmMoveDoneToBottom.setText("Move Done To Bottom");
        this.itmMoveDoneToBottom.addSelectionListener(this.lstMoveDoneToBottom);
        this.itmMoveAllDoneToBottom = new MenuItem(this.menuTools, 8);
        this.itmMoveAllDoneToBottom.setText("Move All Done To Bottom");
        this.itmMoveAllDoneToBottom.addSelectionListener(this.lstMoveAllDoneToBottom);
        new MenuItem(this.menuTools, 2);
        this.itmDeleteDone = new MenuItem(this.menuTools, 8);
        this.itmDeleteDone.setText("Delete Done Items");
        this.itmDeleteDone.addSelectionListener(this.lstDeleteDone);
        this.itmDeleteAllDone = new MenuItem(this.menuTools, 8);
        this.itmDeleteAllDone.setText("Delete All Done Items");
        this.itmDeleteAllDone.addSelectionListener(this.lstDeleteAllDone);
        new MenuItem(this.menuTools, 2);
        this.itmSync = new MenuItem(this.menuTools, 8);
        this.itmSync.setText("Sync");
        this.itmSync.addSelectionListener(this.lstSync);
        if (Constants.EMBEDDED) {
            this.cmdExit = new Command();
            return;
        }
        new MenuItem(this.menuFile, 2);
        this.itmExit = new MenuItem(this.menuFile, 8);
        this.itmExit.setText("Exit");
        this.itmExit.addSelectionListener(this.lstExit);
    }

    protected void createTree() {
        if (this.toDoTree != null) {
            this.toDoTree.dispose();
        }
        this.toDoTree = new ToDoTree((Composite)this.shell);
    }

    protected void disablePaste() {
        if (this.itmPaste.getEnabled()) {
            this.itmPaste.setEnabled(false);
        }
    }

    protected void enablePaste() {
        if (!this.itmPaste.getEnabled()) {
            this.itmPaste.setEnabled(true);
        }
    }

    public final ToDoTree getToDoTree() {
        return this.toDoTree;
    }

    public void handleEvent(Event e) {
        if (((Event)e).type == 24) {
            e = this;
            if (!((MainShell)e).hasChanged) {
                ((MainShell)e).hasChanged = true;
                ((MainShell)e).shell.setText("To-Do-O *");
            }
            ((MainShell)e).widgetSelected(null);
        }
    }

    public final boolean isDisposed() {
        return this.shell.isDisposed();
    }

    protected void loadTreeFromRecordStore() {
        this.createTree();
        this.toDoTree.loadTreeFromRecordStore();
        this.addListeners();
        MainShell mainShell = this;
        mainShell = mainShell.toDoTree.getTree();
        if (mainShell == null || mainShell.isDisposed()) {
            return;
        }
        TreeItem treeItem = mainShell.getItems();
        if (treeItem == null || ((TreeItem[])treeItem).length <= 0) {
            return;
        }
        if ((treeItem = treeItem[0]) == null || treeItem.isDisposed()) {
            return;
        }
        mainShell.setSelection(new TreeItem[]{treeItem});
    }

    protected final void loadTreeFromXMLFile(String fileName) {
        this.createTree();
        this.toDoTree.loadTreeFromXMLFile(fileName);
        this.addListeners();
    }

    public void openShell() {
        this.shell = new Shell(this.display, 1264);
        this.shell.setText("To-Do-O");
        this.shell.setLayout((Layout)new FillLayout(512));
        this.loadTreeFromRecordStore();
        this.createMenu();
        this.shell.layout();
        this.shell.open();
        this.settingsDialog = new SettingsDialog(this.shell);
        this.widgetSelected(null);
    }

    final void unsetChanged() {
        this.hasChanged = false;
        this.shell.setText("To-Do-O");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void updateMenu() {
        AbstractItem abstractItem = this.toDoTree.getSelection();
        if (!(abstractItem instanceof ToDoItem) && !(abstractItem instanceof NoteItem)) {
            this.itmDelete.setEnabled(false);
            this.itmClearSelection.setEnabled(false);
            this.itmEdit.setEnabled(false);
            this.itmCopy.setEnabled(false);
            this.itmCut.setEnabled(false);
            this.itmSetTodoIcon.setEnabled(false);
            this.itmMenuNewSub.setEnabled(false);
            this.itmMarkDone.setEnabled(true);
            this.itmMarkTodo.setEnabled(true);
            return;
        }
        this.itmDelete.setEnabled(true);
        this.itmClearSelection.setEnabled(true);
        this.itmEdit.setEnabled(true);
        this.itmCopy.setEnabled(true);
        this.itmCut.setEnabled(true);
        if (!(abstractItem instanceof ToDoItem)) {
            if (!(abstractItem instanceof NoteItem)) return;
            this.itmMenuNewSub.setEnabled(false);
            this.itmSetTodoIcon.setEnabled(false);
            this.itmMarkDone.setEnabled(false);
            this.itmMarkTodo.setEnabled(false);
            return;
        }
        this.itmMenuNewSub.setEnabled(true);
        abstractItem = (ToDoItem)abstractItem;
        if (((ToDoItem)abstractItem).isDone()) {
            this.itmSetTodoIcon.setEnabled(false);
            this.itmMarkDone.setEnabled(false);
            this.itmMarkTodo.setEnabled(true);
            return;
        }
        this.itmSetTodoIcon.setEnabled(true);
        this.itmMarkDone.setEnabled(true);
        this.itmMarkTodo.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateMenu();
    }

    static /* synthetic */ void access$200(MainShell mainShell, String object, String string) {
        AbstractItem abstractItem = mainShell.toDoTree.getSelection();
        if (abstractItem != null) {
            object = new TextInputDialog(mainShell.shell, (String)object);
            if ((object = ((TextInputDialog)((Object)object)).open()) != null) {
                mainShell.toDoTree.createTreeItemEntry((String)object, string);
            }
        }
    }
}

