/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.asymmetric.ec;

import java.security.SecureRandom;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;

public class ECUtil {
    private SecureRandom random;
    private int strength;

    public ECUtil() {
    }

    public static DERObjectIdentifier getNamedCurveOid(String string) {
        DERObjectIdentifier dERObjectIdentifier = X962NamedCurves.getOID(string);
        if (dERObjectIdentifier == null) {
            dERObjectIdentifier = SECNamedCurves.getOID(string);
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = NISTNamedCurves.getOID(string);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = TeleTrusTNamedCurves.getOID(string);
            }
            if (dERObjectIdentifier == null) {
                dERObjectIdentifier = ECGOST3410NamedCurves.getOID(string);
            }
        }
        return dERObjectIdentifier;
    }

    public static X9ECParameters getNamedCurveByOid(DERObjectIdentifier dERObjectIdentifier) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(dERObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(dERObjectIdentifier);
            if (x9ECParameters == null) {
                x9ECParameters = NISTNamedCurves.getByOID(dERObjectIdentifier);
            }
            if (x9ECParameters == null) {
                x9ECParameters = TeleTrusTNamedCurves.getByOID(dERObjectIdentifier);
            }
        }
        return x9ECParameters;
    }

    public static String getCurveName(DERObjectIdentifier dERObjectIdentifier) {
        String string = X962NamedCurves.getName(dERObjectIdentifier);
        if (string == null) {
            string = SECNamedCurves.getName(dERObjectIdentifier);
            if (string == null) {
                string = NISTNamedCurves.getName(dERObjectIdentifier);
            }
            if (string == null) {
                string = TeleTrusTNamedCurves.getName(dERObjectIdentifier);
            }
            if (string == null) {
                string = ECGOST3410NamedCurves.getName(dERObjectIdentifier);
            }
        }
        return string;
    }

    public ECUtil(SecureRandom secureRandom, int n) {
        this.random = secureRandom;
        this.strength = n;
    }

    public SecureRandom getRandom() {
        return this.random;
    }

    public int getStrength() {
        return this.strength;
    }
}

