/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.util;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERApplicationSpecific;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import to_do_o.core.settings.SettingsStoreSingleton;

public class ASN1Dump {
    private MessageBox mb;
    private int answer;

    public ASN1Dump() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void _dumpAsString(String object, boolean bl, DERObject dERObject, StringBuffer stringBuffer) {
        String string;
        block52: {
            block51: {
                block50: {
                    String string2;
                    Enumeration enumeration;
                    block46: {
                        block47: {
                            block49: {
                                block48: {
                                    string = System.getProperty("line.separator");
                                    if (!(dERObject instanceof ASN1Sequence)) break block47;
                                    enumeration = ((ASN1Sequence)dERObject).getObjects();
                                    string2 = (String)object + "    ";
                                    stringBuffer.append((String)object);
                                    if (!(dERObject instanceof BERConstructedSequence)) break block48;
                                    stringBuffer.append("BER ConstructedSequence");
                                    break block46;
                                }
                                if (!(dERObject instanceof DERConstructedSequence)) break block49;
                                stringBuffer.append("DER ConstructedSequence");
                                break block46;
                            }
                            if (dERObject instanceof BERSequence) {
                                stringBuffer.append("BER Sequence");
                                break block46;
                            } else if (dERObject instanceof DERSequence) {
                                stringBuffer.append("DER Sequence");
                                break block46;
                            } else {
                                stringBuffer.append("Sequence");
                            }
                            break block46;
                        }
                        if (dERObject instanceof DERTaggedObject) {
                            String string3 = (String)object + "    ";
                            stringBuffer.append((String)object);
                            if (dERObject instanceof BERTaggedObject) {
                                stringBuffer.append("BER Tagged [");
                            } else {
                                stringBuffer.append("Tagged [");
                            }
                            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
                            stringBuffer.append(Integer.toString(dERTaggedObject.getTagNo()));
                            stringBuffer.append(']');
                            if (!dERTaggedObject.isExplicit()) {
                                stringBuffer.append(" IMPLICIT ");
                            }
                            stringBuffer.append(string);
                            object = dERTaggedObject;
                            ASN1Dump._dumpAsString(string3, bl, dERTaggedObject.getObject(), stringBuffer);
                            return;
                        }
                        if (dERObject instanceof DERConstructedSet) break block50;
                        if (dERObject instanceof BERSet) break block51;
                        if (!(dERObject instanceof DERSet)) {
                            if (dERObject instanceof DERObjectIdentifier) {
                                stringBuffer.append((String)object + "ObjectIdentifier(" + ((DERObjectIdentifier)dERObject).getId() + ")" + string);
                                return;
                            }
                            if (dERObject instanceof DERBoolean) {
                                stringBuffer.append((String)object + "Boolean(" + ((DERBoolean)dERObject).isTrue() + ")" + string);
                                return;
                            }
                            if (dERObject instanceof DERInteger) {
                                stringBuffer.append((String)object + "Integer(" + ((DERInteger)dERObject).getValue() + ")" + string);
                                return;
                            }
                            if (dERObject instanceof BERConstructedOctetString) {
                                ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
                                stringBuffer.append((String)object + "BER Constructed Octet String" + "[" + aSN1OctetString.getOctets().length + "] ");
                                if (bl) {
                                    stringBuffer.append(ASN1Dump.dumpBinaryDataAsString((String)object, aSN1OctetString.getOctets()));
                                    return;
                                }
                                stringBuffer.append(string);
                                return;
                            }
                            if (dERObject instanceof DEROctetString) {
                                ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
                                stringBuffer.append((String)object + "DER Octet String" + "[" + aSN1OctetString.getOctets().length + "] ");
                                if (bl) {
                                    stringBuffer.append(ASN1Dump.dumpBinaryDataAsString((String)object, aSN1OctetString.getOctets()));
                                    return;
                                }
                                stringBuffer.append(string);
                                return;
                            }
                            if (dERObject instanceof DERBitString) {
                                DERBitString dERBitString = (DERBitString)dERObject;
                                stringBuffer.append((String)object + "DER Bit String" + "[" + dERBitString.getBytes().length + ", " + dERBitString.getPadBits() + "] ");
                                if (bl) {
                                    stringBuffer.append(ASN1Dump.dumpBinaryDataAsString((String)object, dERBitString.getBytes()));
                                    return;
                                }
                                stringBuffer.append(string);
                                return;
                            }
                            if (dERObject instanceof DERIA5String) {
                                stringBuffer.append((String)object + "IA5String(" + ((DERIA5String)dERObject).getString() + ") " + string);
                                return;
                            }
                            if (dERObject instanceof DERUTF8String) {
                                stringBuffer.append((String)object + "UTF8String(" + ((DERUTF8String)dERObject).getString() + ") " + string);
                                return;
                            }
                            if (dERObject instanceof DERPrintableString) {
                                stringBuffer.append((String)object + "PrintableString(" + ((DERPrintableString)dERObject).getString() + ") " + string);
                                return;
                            }
                            if (dERObject instanceof DERVisibleString) {
                                stringBuffer.append((String)object + "VisibleString(" + ((DERVisibleString)dERObject).getString() + ") " + string);
                                return;
                            }
                            if (dERObject instanceof DERBMPString) {
                                stringBuffer.append((String)object + "BMPString(" + ((DERBMPString)dERObject).getString() + ") " + string);
                                return;
                            }
                            if (dERObject instanceof DERT61String) {
                                stringBuffer.append((String)object + "T61String(" + ((DERT61String)dERObject).getString() + ") " + string);
                                return;
                            }
                            if (dERObject instanceof DERUTCTime) {
                                stringBuffer.append((String)object + "UTCTime(" + ((DERUTCTime)dERObject).getTime() + ") " + string);
                                return;
                            }
                            if (dERObject instanceof DERGeneralizedTime) {
                                stringBuffer.append((String)object + "GeneralizedTime(" + ((DERGeneralizedTime)dERObject).getTime() + ") " + string);
                                return;
                            }
                            if (dERObject instanceof DERUnknownTag) {
                                stringBuffer.append((String)object + "Unknown " + Integer.toString(((DERUnknownTag)dERObject).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)dERObject).getData())) + string);
                                return;
                            }
                            if (dERObject instanceof BERApplicationSpecific) {
                                stringBuffer.append(ASN1Dump.outputApplicationSpecific("BER", (String)object, bl, dERObject, string));
                                return;
                            }
                            if (dERObject instanceof DERApplicationSpecific) {
                                stringBuffer.append(ASN1Dump.outputApplicationSpecific("DER", (String)object, bl, dERObject, string));
                                return;
                            }
                            if (dERObject instanceof DEREnumerated) {
                                DEREnumerated dEREnumerated = (DEREnumerated)dERObject;
                                stringBuffer.append((String)object + "DER Enumerated(" + dEREnumerated.getValue() + ")" + string);
                                return;
                            }
                            if (!(dERObject instanceof DERExternal)) {
                                stringBuffer.append((String)object + dERObject.toString() + string);
                                return;
                            }
                            DERExternal dERExternal = (DERExternal)dERObject;
                            stringBuffer.append((String)object + "External " + string);
                            String string4 = (String)object + "    ";
                            if (dERExternal.getDirectReference() != null) {
                                stringBuffer.append(string4 + "Direct Reference: " + dERExternal.getDirectReference().getId() + string);
                            }
                            if (dERExternal.getIndirectReference() != null) {
                                stringBuffer.append(string4 + "Indirect Reference: " + dERExternal.getIndirectReference().toString() + string);
                            }
                            if (dERExternal.getDataValueDescriptor() != null) {
                                ASN1Dump._dumpAsString(string4, bl, dERExternal.getDataValueDescriptor(), stringBuffer);
                            }
                            stringBuffer.append(string4 + "Encoding: " + dERExternal.getEncoding() + string);
                            ASN1Dump._dumpAsString(string4, bl, dERExternal.getExternalContent(), stringBuffer);
                            return;
                        }
                        break block52;
                    }
                    stringBuffer.append(string);
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        if (object == null || object.equals(new DERNull())) {
                            stringBuffer.append(string2);
                            stringBuffer.append("NULL");
                            stringBuffer.append(string);
                            continue;
                        }
                        if (object instanceof DERObject) {
                            ASN1Dump._dumpAsString(string2, bl, (DERObject)object, stringBuffer);
                            continue;
                        }
                        ASN1Dump._dumpAsString(string2, bl, ((DEREncodable)object).getDERObject(), stringBuffer);
                    }
                    return;
                }
                Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
                String string5 = (String)object + "    ";
                stringBuffer.append((String)object);
                stringBuffer.append("ConstructedSet");
                stringBuffer.append(string);
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (object == null) {
                        stringBuffer.append(string5);
                        stringBuffer.append("NULL");
                        stringBuffer.append(string);
                        continue;
                    }
                    if (object instanceof DERObject) {
                        ASN1Dump._dumpAsString(string5, bl, (DERObject)object, stringBuffer);
                        continue;
                    }
                    ASN1Dump._dumpAsString(string5, bl, ((DEREncodable)object).getDERObject(), stringBuffer);
                }
                return;
            }
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string6 = (String)object + "    ";
            stringBuffer.append((String)object);
            stringBuffer.append("BER Set");
            stringBuffer.append(string);
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object == null) {
                    stringBuffer.append(string6);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string);
                    continue;
                }
                if (object instanceof DERObject) {
                    ASN1Dump._dumpAsString(string6, bl, (DERObject)object, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string6, bl, ((DEREncodable)object).getDERObject(), stringBuffer);
            }
            return;
        }
        Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
        String string7 = (String)object + "    ";
        stringBuffer.append((String)object);
        stringBuffer.append("DER Set");
        stringBuffer.append(string);
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object == null) {
                stringBuffer.append(string7);
                stringBuffer.append("NULL");
                stringBuffer.append(string);
                continue;
            }
            if (object instanceof DERObject) {
                ASN1Dump._dumpAsString(string7, bl, (DERObject)object, stringBuffer);
                continue;
            }
            ASN1Dump._dumpAsString(string7, bl, ((DEREncodable)object).getDERObject(), stringBuffer);
        }
    }

    private static String outputApplicationSpecific(String object, String string, boolean bl, DERObject dERObject, String string2) {
        dERObject = (DERApplicationSpecific)dERObject;
        StringBuffer stringBuffer = new StringBuffer();
        if (((DERApplicationSpecific)dERObject).isConstructed()) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(((DERApplicationSpecific)dERObject).getObject(16));
                stringBuffer.append(string + (String)object + " ApplicationSpecific[" + ((DERApplicationSpecific)dERObject).getApplicationTag() + "]" + string2);
                object = aSN1Sequence.getObjects();
                while (object.hasMoreElements()) {
                    ASN1Dump._dumpAsString(string + "    ", bl, (DERObject)object.nextElement(), stringBuffer);
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException);
            }
            return stringBuffer.toString();
        }
        return string + (String)object + " ApplicationSpecific[" + ((DERApplicationSpecific)dERObject).getApplicationTag() + "] (" + new String(Hex.encode(((DERApplicationSpecific)dERObject).getContents())) + ")" + string2;
    }

    public static String dumpAsString(Object object) {
        boolean bl = false;
        Object object2 = object;
        StringBuffer stringBuffer = new StringBuffer();
        if (object2 instanceof DERObject) {
            ASN1Dump._dumpAsString("", false, (DERObject)object2, stringBuffer);
        } else if (object2 instanceof DEREncodable) {
            ASN1Dump._dumpAsString("", false, ((DEREncodable)object2).getDERObject(), stringBuffer);
        } else {
            return "unknown object type " + object2.toString();
        }
        return stringBuffer.toString();
    }

    private static String dumpBinaryDataAsString(String string, byte[] byArray) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        string = string + "    ";
        stringBuffer.append(string2);
        for (int i = 0; i < byArray.length; i += 32) {
            if (byArray.length - i > 32) {
                stringBuffer.append(string);
                stringBuffer.append(new String(Hex.encode(byArray, i, 32)));
                stringBuffer.append("    ");
                stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, 32));
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append(new String(Hex.encode(byArray, i, byArray.length - i)));
            for (int j = byArray.length - i; j != 32; ++j) {
                stringBuffer.append("  ");
            }
            stringBuffer.append("    ");
            stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, byArray.length - i));
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String calculateAscString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i != n + n2; ++i) {
            if (byArray[i] < 32 || byArray[i] > 126) continue;
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public ASN1Dump(Shell shell, String string) {
        if (SettingsStoreSingleton.getInstance().getBoolean("ConfirmAllActions")) {
            this.mb = new MessageBox(shell, 196);
            this.mb.setText("Confirmation");
            this.mb.setMessage(string);
            this.answer = this.mb.open();
            return;
        }
        this.answer = 64;
    }

    public boolean answerYes() {
        return this.answer == 64;
    }
}

