//*****************************************************************************
//*
//*
//*     SmbMisc.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2007    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//

#include    "Smb.h"

#ifndef _MSC_VER
#ifndef  SMB_NO_ASM
#define  SMB_NO_ASM
#endif
#endif


//*****************************************************************************
//*
//*     StrUpper
//*
//*****************************************************************************
//  Converts a sting from lower case to upper case
//  pString : is the pinter to the sting
SMB_API void StrUpper(char *pString)
{
char    cSign;


    for(;;pString++)
        {
            cSign = *pString;
        if(!cSign    )break;
        if( cSign<'a')continue;
        if( cSign>'z')continue;

        *pString = cSign-('a'-'A');
        }

}


//*****************************************************************************
//*
//*     StrLower
//*
//*****************************************************************************
//  Converts a sting from upper case to lower case
//  pString : is the pinter to the sting
SMB_API void StrLower(char *pString)
{
char    cSign;


    for(;;pString++)
        {
            cSign = *pString;
        if(!cSign    )break;
        if( cSign<'A')continue;
        if( cSign>'Z')continue;

        *pString = cSign+('a'-'A');
        }

}


//*****************************************************************************
//*
//*     StrCmpI
//*
//*****************************************************************************
//  Compares two strings with out case sensitifity
//  pString1    : pointer to the first string
//  pString2    : pointer to the second string
//  returns          0 = equal
//                  >0 = pString1 is greater
//                  <0 = pString2 is greater
SMB_API int StrCmpI(const char *pString1,const char *pString2)
{
unsigned char   uSign1;
unsigned char   uSign2;
int             iDiff;
int             iPos;


    for(iPos=0;;iPos++)
        {
        uSign1 = pString1[iPos];
        uSign2 = pString2[iPos];

        if(uSign1>='a' && uSign1<='z')uSign1-='a'-'A';
        if(uSign2>='a' && uSign2<='z')uSign2-='a'-'A';

           iDiff = uSign1-uSign2;
        if(iDiff)return iDiff;
        if(uSign1==0)break;
        }



return 0;
}


//*****************************************************************************
//*
//*     StrCmpNI
//*
//*****************************************************************************
//  Compares two strings with out case sensitifity and size limith.
//  pString1    : pointer to the first string
//  pString2    : pointer to the second string
//  iSize       : is the maximum string size
//  returns          0 = equal
//                  >0 = pString1 is greater
//                  <0 = pString2 is greater
SMB_API int StrCmpNI(const char *pString1,const char *pString2,int iSize)
{
unsigned char   uSign1;
unsigned char   uSign2;
int             iDiff;
int             iPos;


    for(iPos=0;iPos<iSize;iPos++)
        {
        uSign1 = pString1[iPos];
        uSign2 = pString2[iPos];

        if(uSign1>='a' && uSign1<='z')uSign1-='a'-'A';
        if(uSign2>='a' && uSign2<='z')uSign2-='a'-'A';

           iDiff = uSign1-uSign2;
        if(iDiff)return iDiff;
        if(uSign1==0)break;
        }



return 0;
}

//*****************************************************************************
//*
//*     MemCmpI
//*
//*****************************************************************************
//  Compares two memory areas with out case sensitifity and size limith.
//  pMem1   : pointer to the first memory area
//  pMem2   : pointer to the second memory area
//  iSize   : is the maximum string size
//  Returns          0 = equal
//                  >0 = pMem1 is greater
//                  <0 = pMem2 is greater
SMB_API int MemCmpI(const void *pMem1,const char *pMem2,int iSize)
{
const char     *pString1=(const char*)pMem1;
const char     *pString2=(const char*)pMem2;
unsigned char   uSign1;
unsigned char   uSign2;
int             iDiff;
int             iPos;


    for(iPos=0;iPos<iSize;iPos++)
        {
        uSign1 = pString1[iPos];
        uSign2 = pString2[iPos];

        if(uSign1>='a' && uSign1<='z')uSign1-='a'-'A';
        if(uSign2>='a' && uSign2<='z')uSign2-='a'-'A';

           iDiff = uSign1-uSign2;
        if(iDiff)return iDiff;
        }



return 0;
}


//*****************************************************************************
//*
//*     MemCmpF
//*
//*****************************************************************************
//  Vergleich zwei Speicherbereiche
//  Alle Zeichen in pBuffer1 die '?' sind werden bersprungen
//  Ist iCase==0 wird zwischen Gro und Klein Buchstaben unterschieden
//  Ist iCase!=0 wird zwischen Gro und Klein Buchstaben nicht unterschieden
//           Ist pToUpperCase==0 so wird die Vergleichsfunktion memcmpi verwendet
//           sontst wird nach der 256 Byte langen Umwandlungs Tabelle verglichen
//  Ist iCase!=0 wird zwischen Gro und Klein Buchstaben nicht unterschieden
//  Ergibt:  0 wenn Speicherbereiche gleich sind
//          >0 wenn pBuffer1 > pBuffer2
//          <0 wenn pBuffer1 < pBuffer2

#ifdef  _MSC_VER
#pragma warning( disable :4035 )
#endif

SMB_API int MemCmpF(const void *pBuffer1,const void *pBuffer2,unsigned int iCount,int iCase)
{

//********************** ohne Assembler ***************************************
#ifdef  SMB_NO_ASM


register unsigned char *pPtr1,*pPtr2;
register int            iDelta;
unsigned char           a,b;

    pPtr1=(unsigned char*)pBuffer1;
    pPtr2=(unsigned char*)pBuffer2;


    if(iCase)
        {
        while(iCount>0)
            {
            if(*pPtr1!='?')
                {
                a=*pPtr1;
                b=*pPtr2;

                if(a>='a' && a<='z')a+='A'-'a';
                if(b>='a' && b<='z')b+='A'-'a';
                   iDelta=a-b;
                if(iDelta)return iDelta;
                }

            pPtr1++;
            pPtr2++;
            }
        }
    else{
        while(iCount>0)
            {
            if(*pPtr1!='?')
                {
                   iDelta=*pPtr1-*pPtr2;
                if(iDelta)return iDelta;
                }

            pPtr1++;
            pPtr2++;
            }
        }

return 0;

//********************** mit Assembler ****************************************
#else


    if(iCase)
        {
    __asm
        {
        cmp  dword ptr iCount,0     ;// Lng ist <= null ?
        jle  e_2                    ;//         *

        mov  esi,pBuffer1           ;//         *
        mov  edi,pBuffer2           ;//         *

        xor  eax,eax                ;// EAX = 0
        xor  ecx,ecx                ;// ECX = 0


    sc1:mov  al,[esi]               ;// Bytes laden
        mov  cl,al                  ;// Zwei Gleiche Zeichen
        cmp  al,'?'                 ;// Ist Zeichen == '?'
        je   nx1                    ;//         *
        cmp  al,'a'                 ;// Ist Zeichen <  'a'
        jl   wt1                    ;//         *
        cmp  al,'z'                 ;// Ist Zeichen >  'z'
        jg   wt1                    ;//         *
        sub  al,32                  ;//         *

    wt1:mov  cl,[edi]               ;//         *
        cmp  cl,'a'                 ;// Ist Zeichen <  'a'
        jl   wt2                    ;//         *
        cmp  cl,'z'                 ;// Ist Zeichen >  'z'
        jg   wt2                    ;//         *
        sub  cl,32                  ;//         *

    wt2:cmp  al,cl                  ;// Bytes vergleichen
        jne  e_1                    ;//         *

    nx1:dec  dword ptr iCount       ;//         *
        jz   e_2                    ;//         *
        inc  esi                    ;// Nchstes Byte
        inc  edi                    ;//         *
        jmp  sc1                    ;//         *

    e_2:xor  eax,eax;               ;// Null zurck geben
        jmp  e_e                    ;//         *
    e_1:sub  eax,ecx                ;// Unterschied berechen
    e_e:
        }}
    else{
    __asm
        {
        cmp  dword ptr iCount,0     ;// Ist Lnge <= null ?
        jle  e_4                    ;//         *

        mov  esi,pBuffer1           ;//         *
        mov  edi,pBuffer2           ;//         *

        xor  eax,eax                ;// EAX = 0
        xor  ecx,ecx                ;// ECX = 0

    scg:mov  al,[esi]               ;// Bytes laden
        mov  cl,al                  ;// Zwei Gleiche Zeichen
        cmp  al,'?'                 ;// Ist Zeichen == '?'
        je   nxg                    ;//         *
        mov  cl,[edi]               ;//         *
        cmp  al,cl                  ;// Bytes vergleichen
        jne  e_3                    ;//         *
    nxg:dec  dword ptr iCount       ;//         *
        jz   e_4                    ;//         *
        inc  esi                    ;// Nchstes Byte
        inc  edi                    ;//         *
        jmp  scg                    ;//         *

    e_4:xor  eax,eax;               ;// Null zurck geben
        jmp  e_f                    ;//         *
    e_3:sub  eax,ecx                ;// Unterschied berechen
    e_f:
        }}


#endif
}

#ifdef  _MSC_VER
#pragma warning( default :4035 )
#endif

//*****************************************************************************
//*
//*     MemCmpX
//*
//*****************************************************************************
//  Compares a text with a filer. The filer could contain wildcards. (?*)
//  pFind       : pointer to the filter
//  iFindLen    : lenght of the filter
//  pText       : pointer to the text
//  iTextLen    : lenght of the text
//  iCase       : lower/upper case mode
//  Returns 0 if equal.
SMB_API int MemCmpX(const char *pFind,int iFindLen,const char *pText,int iTextLen,int iCase)
{
int     iTextPos,iFindPos;
int     i,iLen,iStar,iQuest,iMode,iNum=0;


    if(iFindLen<=0)return 0;
    if(iCase&2 && iFindLen>=3)                  // "*.*" in "*" umwandeln
    if(pFind[iFindLen-1]=='*')
    if(pFind[iFindLen-2]=='.')
    if(pFind[iFindLen-3]=='*')iFindLen-=2;


    iStar=0;                                    // Sterne am Ende suchen
    while(iFindLen>0)
        {
        if(pFind[iFindLen-1]!='*')break;
        iFindLen--;
        iStar++;
        }

    iMode  = iCase;
    iCase &= 1;

//*****************************************************************************

    iFindPos = 0;
    iTextPos = 0;
    iNum     = 0;


    for(;;)                                     // Suchen Schleife
        {
        if(iFindLen<=0)break;
        if(iTextLen<=0)return (iMode&4)? 0:1;

        iLen=0;
        
        while(iLen<iFindLen)                    // Wort Lnge holen
            {
            if(pFind[iLen]=='*')break;
            iLen++;
            }
        
        if(iTextLen<iLen)return (iMode&4)? 0:1;
        if(iLen)
            {
            if(MemCmpF(pFind,pText,iLen,iCase))return (iMode&4)? 0:1;
            iFindLen-=iLen;pFind+=iLen;
            iTextLen-=iLen;pText+=iLen;
                            iNum+=iLen;
            continue;
            }

        iQuest=0;

        while(iFindLen>0)                       // Wildcard berspringen
            {
            if(*pFind=='?'){iQuest++;pFind++;iFindLen--;continue;}
            if(*pFind!='*')break;
                pFind++;iFindLen--;
            }

        if(iTextLen<iQuest)return (iMode&4)? 0:1;
        if(iFindLen<=  0  ){iStar=1;break;}

        iTextLen-=iQuest;
           pText+=iQuest;
            iNum+=iQuest;

        iLen=0;

        while(iLen<iFindLen)                    // Wort Lnge holen
            {
            if(pFind[iLen]=='*')break;
            iLen++;
            }

        while(iTextLen>=iLen)                   // Suche Wortteil
            {
            if(!MemCmpF(pFind,pText,iLen,iCase))
                {
                if(iFindLen==iLen)              // Ende des Such-Strings
                    {
                    if(iMode&4)return (iStar)? iNum+iTextLen:iNum+iLen;
                    if(iStar || iTextLen==iLen)return 0;
                    }
                else{                           // Weiter suchen
                    i=MemCmpX(pFind+iLen,iFindLen-iLen,
                               pText+iLen, iTextLen-iLen,iCase|0x04);

                    if(i == 0 )return (iMode&4)? 0:1;
                    if(iMode&4)return (iStar)?  iNum+iTextLen:iNum+iLen+i;
                               return (i+iLen)!=(iTextLen);
                    }
                }

            iTextLen--;
            pText++;
            iNum++;
            }

        return (iMode&4)? 0:1;
        }

//*********************** Suchen_len <= 0 *************************************

    if(iMode&4)return (iStar)? iNum+iTextLen:iNum;
    if((iTextLen>0)&& !iStar)return 1;          // Stern am Wortende




return 0;
}

