//*****************************************************************************
//*
//*
//*     SmbDemo.cpp
//*
//*
//*****************************************************************************
//
//  this is a demo for an smb server for linux
//
//
//  Copyright  2007    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
#include <time.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#include "NmbServer.h"
#include "SmbServer.h"

#define SHARE               1

#ifndef FALSE
#define FALSE               0
#endif

#ifndef TRUE
#define TRUE                1
#endif

//*****************************************************************************
//*
//*     GetPassword
//*
//*****************************************************************************
//  callback to get the password vor a user
//  pUser       : is the user name
//  pPassword   : buffer for the password
//  iSize       : is the buffer size in bytes
//  returns the size of the saved password or 0 if the password
//  for this user should not be ckecked, or 10000 for an invalid user
int _cdecl GetPassword(const char *pUser,char *pPassword,int iSize)
{

    printf("Password:    %s \n",pUser);

    #if SHARE
    pPassword[0] = 0;
    return 0;                                   // all other user didn't need a password
    #else

    if(!stricmp(pUser,"guest"))                 // a guest user
        {
        strncpy(pPassword,"abc123",iSize);
        return strlen("abc123");
        }

    if(!strnicmp(pUser,"user",4) && pUser[4]>='0' && pUser[4]<='9'&& pUser[5]==0)
        {
        strncpy(pPassword,"xyz0",iSize);
        pPassword[3] = pUser[4];
        return strlen("xyz0");
        }

    pPassword[0] = '#';                         // create a dummy pass word
    pPassword[1] =  0;

    return 1;
    #endif
}

//*****************************************************************************
//*
//*     UserLogon
//*
//*****************************************************************************
//  callback for user logons
//  pTree   : pointer to the tree data, here you can insert seveal paths
//  pUser   : is the user name
//  returns TRUE if the userer is valid, or FALSE if a wrong user was logged on.
int _cdecl UserLogon(void *pTree,const char *pUser)
{


    printf("UserLogon:   %s \n",pUser);

    #if SHARE

    SmbInsertTreeEntry(pTree,"./DemoDir","C_Drive" ,"This share is writable" ,SMB_MODE_READWRITE ,NULL);
    SmbInsertTreeEntry(pTree,"./DemoDir","C_Mirror","This share is read only",SMB_MODE_READONLY  ,NULL);

    return TRUE;

    #else

    char   *pMem;
    char    cPath[256];
    int     iLen;


    if(stricmp (pUser,"guest"))             // check the user, only guest and user0...9 are allowed
    if(strnicmp(pUser,"user",4) || pUser[4]<'0' || pUser[4]>'9'|| pUser[5]!=0)
        {
        return FALSE;
        }


    SmbInsertTreeEntry(pTree,"./DemoDir","C_Drive" ,"This share is writable" ,SMB_MODE_READWRITE ,NULL);
    SmbInsertTreeEntry(pTree,"./DemoDir","C_Mirror","This share is read only",SMB_MODE_READONLY  ,NULL);


    if(stricmp(pUser,"guest"))              // add a user depenting directory
        {
        iLen = sprintf(cPath,"./DemoDir/Users/%s",pUser)+1;
        pMem = (char*)SmbMemAlloc(iLen);

        if(!pMem)return FALSE;

        mkdir(cPath,0777);
        memcpy(pMem,cPath,iLen);
        SmbInsertTreeEntry(pTree,pMem,"Own","User depent directory",SMB_MODE_READWRITE,pMem);
        }

    return TRUE;

    #endif
}

//*****************************************************************************
//*
//*     TreeCheck
//*
//*****************************************************************************
//  callback to check the access attributs of trees
//  return: -4 unknown error
//          -3 wrong server name
//          -2 wrong path
//          -1 wrong username/pasword
//           0 connect with common access
//           1 connect with readonly access
int _cdecl TreeCheck(const SmbTreeData *pData)
{


    printf("TreeCheck:   %s : %s\n",pData->cUsername,pData->cService);

    #if SHARE

    return 0;

    #else

    if(!stricmp(pData->cService,"C_Drive"))
        {
        if(!stricmp(pData->cUsername,"unknown"))
            {
            return 1;                           // this user has read only access on C_Drive
            }
        }

    #endif


return 0;
}

//******************************************************************************
//*
//*     InitDirs
//*
//******************************************************************************
//  Creates a demo directory with a file,
void InitDirs()
{
FILE *f;

    mkdir("./DemoDir",0777);                    // path for user directories

    f=fopen("./DemoDir/ReadMe.txt","w");
    fprintf(f,"This is a Demo File.");
    fclose(f);

    mkdir("./DemoDir/Users",0777);              // path for user directories
}

//*****************************************************************************
//*
//*     main
//*
//*****************************************************************************
int main(int iArgc,char **pArgv)
{
SmbConfigData   sSmbConfig;
NmbConfigData   sNmbConfig;
hostent        *pEntry;
char          **pAddesess;
const char     *pSubNet  ="255.255.255.0";
const char     *pWorkgrop="WORKGROUP";
char           *pHostname=NULL;
char           *pIpAddr  =NULL;
char           *pParam;
char            cHostname[64];
char            cIpAddr  [64];
int             iNum,iErr,iKey;



    for(iNum=1;iNum<iArgc;iNum++)               // scan command line
        {
        pParam = pArgv[iNum];

        if(!strcmp(pParam,"-help") || !strcmp(pParam,"?"))
            {
            printf("\n\n");
            printf("\tSmbDemo   [-i ipaddress] [-s subnetmask] [-h hostname] [-w workgroup]\n\n");
            printf("\n\n");
            return -2;
            }

        if(!strcmp(pParam,"-i") && iNum+1<iArgc)
            {
            iNum++;
            pIpAddr = pArgv[iNum];
            continue;
            }

        if(!strcmp(pParam,"-s") && iNum+1<iArgc)
            {
            iNum++;
            pSubNet = pArgv[iNum];
            continue;
            }

        if(!strcmp(pParam,"-h") && iNum+1<iArgc)
            {
            iNum++;
            pHostname = pArgv[iNum];
            continue;
            }

        if(!strcmp(pParam,"-w") && iNum+1<iArgc)
            {
            iNum++;
            pWorkgrop = pArgv[iNum];
            continue;
            }
        }




//*********************** check parameters *************************************


    if(!pHostname || !pIpAddr)
        {
        if(gethostname(cHostname,sizeof(cHostname)))
            {
            printf("Can't hostname !\n");
            return -1;
            }

        if(!pHostname)pHostname=cHostname;


        pEntry    = gethostbyname(cHostname);

        if(!pEntry)
            {
            printf("Can't get ip infos !\n");
            return -1;
            }

        pAddesess = pEntry->h_addr_list;

        if(!pIpAddr)                                // use the first ip address
            {
            for(iNum=0;pAddesess[iNum];iNum++)
                {
                if(pAddesess[iNum][0]!=127)break;
                if(pAddesess[iNum][1]!=  0)break;
                if(pAddesess[iNum][2]!=  0)break;
                if(pAddesess[iNum][3]!=  1)break;
                }

            if(!pAddesess[iNum])
                {
                printf("Can't get local IP address !\n");
                return -1;
                }

            sprintf(cIpAddr,"%i.%i.%i.%i",  pAddesess[iNum][0]&0xFF,
                                            pAddesess[iNum][1]&0xFF,
                                            pAddesess[iNum][2]&0xFF,
                                            pAddesess[iNum][3]&0xFF);
            pIpAddr = cIpAddr;
            }
        }


//*********************** startup server ***************************************


    InitDirs();

    printf("\n");
    printf("workgroup  : '%s'\n",pWorkgrop);
    printf("hostname   : '%s'\n",pHostname);
    printf("local ip   : '%s'\n",pIpAddr);
    printf("subnetmask : '%s'\n",pSubNet);


    memset(&sSmbConfig,0,sizeof(sSmbConfig));
    memset(&sNmbConfig,0,sizeof(sNmbConfig));

    sSmbConfig.pGetPassword     = GetPassword;
    sSmbConfig.pUserLogon       = UserLogon;
    sSmbConfig.pTreeCheck       = TreeCheck;
    sSmbConfig.iMaxBufferSize   = 0xFFFF;
    sSmbConfig.iSecurityMode    = SMB_USER;
    sSmbConfig.iPriority        = 24;

    strncpy(sSmbConfig.cIpAddress ,pIpAddr  ,sizeof(sSmbConfig.cIpAddress ));
    strncpy(sNmbConfig.cIpAddress ,pIpAddr  ,sizeof(sNmbConfig.cIpAddress ));
    strncpy(sNmbConfig.cSubNetMask,pSubNet  ,sizeof(sNmbConfig.cSubNetMask));
    strncpy(sNmbConfig.cHostname  ,pHostname,sizeof(sNmbConfig.cHostname  ));
    strncpy(sNmbConfig.cWorkgroup ,pWorkgrop,sizeof(sNmbConfig.cWorkgroup ));
            sNmbConfig.iPriority = 24;


       iErr=NmbDaemon(&sNmbConfig);
    if(iErr!=NMB_ERR_NONE)
        {
        printf("\nNMB-Error: %i\n",iErr);
        SmbStopDaemon();
        NmbStopDaemon();
        printf("\n...exit...\n");
        return -1;
        }

       iErr=SmbDaemon(&sSmbConfig);
    if(iErr!=SMB_ERR_NONE)
        {
        printf("\nSMB-Error: %i\n",iErr);
        SmbStopDaemon();
        NmbStopDaemon();
        printf("\n...exit...\n");
        return -1;
        }

    printf("\n\nshutdown server with  ESC+ENTER \n\n\n");


    for(;;)
        {
           iKey =getchar();
        if(iKey==27)break;
        }


    printf("\nshutdown server\n");
    SmbStopDaemon();
    NmbStopDaemon();
    printf("\n...exit...\n\n");


return 0;
}
