/*
** Copyright (c) 2010  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef TIMEGROUP_H
#define TIMEGROUP_H

#include "rotator.h"
#include "numberitem.h"

class CTimeGroup : public QObject
{
    Q_OBJECT

public:
    CTimeGroup(QObject* pParent = 0);
    virtual ~CTimeGroup();

    void initialize(QGraphicsScene* pScene);

    void setFixedValues(const QList<int>& listValues, int selectedValue);
    QList<int> fixedValues();

    void setValue(int value);
    int value() { return m_CurrentValue; }

    void setReflection(bool bEnable);
    void enableEditMode(bool bEnable);
    bool isEditMode() { return m_bEditMode; }
    void setOpacity(qreal opacity);
    void setVisible(bool bVisible);

    void stopUpdates(bool bStop) { m_bStopUpdates = bStop; }
    void stopMovement();

    void setPosition(int x, int y);

public slots:
    void onHoursChanged(int value);
    void onMinutesChanged(int value);
    void onSecondsChanged(int value);
    void onPresetSelected(int index);

signals:
    void valueChanged(int value);
    void presetChanged();

private:
    CRotator* m_pHours;              ///< The rotator for the hours
    CRotator* m_pMinutes;            ///< The rotator for the minutes
    CRotator* m_pSeconds;            ///< The rotator for the seconds
    CNumberItem* m_pSeparator1;      ///< The hour:minute separator
    CNumberItem* m_pSeparator2;      ///< The minute:seconds separator

    bool m_bEditMode;                ///< True if the time group is in the edit mode
    int m_CurrentValue;              ///< The current time value in seconds
    bool m_bCountDown;               ///< True if timer counts down
    bool m_bStopUpdates;             ///< If true the backlight is dimmed so no need top update the UI
};

#endif // TIMEGROUP_H
