/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef DEBUGTEXT_H
#define DEBUGTEXT_H

#ifdef WITH_DEBUGTEXT
#define DEBUGTEXT(t, v) CDebugText::instance()->setText((t), (v))
#else
#define DEBUGTEXT(t, v)
#endif

class CDebugText : public QGraphicsItem
{
public:
    CDebugText();
    virtual ~CDebugText();

    QRectF boundingRect() const;
    void paint(QPainter* pPainter, const QStyleOptionGraphicsItem* pOption, QWidget* pWidget);

    void setText(QString strText, QString strValue);

    static CDebugText* instance();

private:
    QString createText() const;

    QMap<QString, QString> m_DebugValues;    ///< The texts to be shown
    static CDebugText* c_Instance;
};

#endif // DEBUGTEXT_H
