#include <QApplication>
#include <QDesktopWidget>
#include <QSize>

#include "thriftydrinker.h"
#include "ui_thriftydrinker.h"
#include <stdio.h>

#define MILLERFACTOR 15.615

thriftydrinker::thriftydrinker(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::thriftydrinker)
{

    ui->setupUi(this);
    connect(ui->doubleSpinBox,SIGNAL(valueChanged(double)),this,SLOT(calculate()));
    connect(ui->doubleSpinBox_2, SIGNAL(valueChanged(double)),this,SLOT(calculate()));
    connect(ui->comboBox,SIGNAL(currentIndexChanged(int)),this,SLOT(calculate()));
    connect(QApplication::desktop(),SIGNAL(resized(int)),this,SLOT(orientationChanged()));
}

thriftydrinker::~thriftydrinker()
{
    delete ui;
}

void thriftydrinker::orientationChanged()
{
    QSize size = QApplication::desktop()->size();
    int w = size.width();
    int h = size.height()-80;
    //printf("Height: %d x Width: %d\n",h,w);
    if(w < h){ //portrait
	ui->spinnerLayout->setMaximumSize(w, .8*h);
	ui->label_4->setMaximumSize(w,.2*h);
	this->resize(w,h);


	delete ui->costFrame->layout();
	ui->costFrame->setLayout(new QHBoxLayout);
	ui->costFrame->layout()->addWidget(ui->label_3);
	ui->costFrame->layout()->addWidget(ui->doubleSpinBox);

	delete ui->sizeFrame->layout();
	ui->sizeFrame->setLayout(new QHBoxLayout);
	ui->sizeFrame->layout()->addWidget(ui->label_2);
	ui->sizeFrame->layout()->addWidget(ui->comboBox);

	delete ui->proofFrame->layout();
	ui->proofFrame->setLayout(new QHBoxLayout);
	ui->proofFrame->layout()->addWidget(ui->label);
	ui->proofFrame->layout()->addWidget(ui->doubleSpinBox_2);

	delete ui->spinnerLayout->layout();
	ui->spinnerLayout->setLayout(new QVBoxLayout);
	ui->spinnerLayout->layout()->addWidget(ui->costFrame);
	ui->spinnerLayout->layout()->addWidget(ui->proofFrame);
	ui->spinnerLayout->layout()->addWidget(ui->sizeFrame);

	delete ui->centralWidget->layout();
	ui->centralWidget->setLayout(new QVBoxLayout);
	ui->centralWidget->layout()->addWidget(ui->spinnerLayout);
	ui->centralWidget->layout()->addWidget(ui->label_4);

	this->show();

    }else{ //landscape

	ui->spinnerLayout->setMaximumSize(w, .8*h);
	ui->label_4->setMaximumSize(w,.2*h);
	this->resize(w,h);

	delete ui->costFrame->layout();
	ui->costFrame->setLayout(new QVBoxLayout);
	ui->costFrame->layout()->addWidget(ui->label_3);
	ui->costFrame->layout()->addWidget(ui->doubleSpinBox);

	delete ui->sizeFrame->layout();
	ui->sizeFrame->setLayout(new QVBoxLayout);
	ui->sizeFrame->layout()->addWidget(ui->label_2);
	ui->sizeFrame->layout()->addWidget(ui->comboBox);

	delete ui->proofFrame->layout();
	ui->proofFrame->setLayout(new QVBoxLayout);
	ui->proofFrame->layout()->addWidget(ui->label);
	ui->proofFrame->layout()->addWidget(ui->doubleSpinBox_2);

	delete ui->spinnerLayout->layout();
	ui->spinnerLayout->setLayout(new QHBoxLayout);
	ui->spinnerLayout->layout()->addWidget(ui->costFrame);
	ui->spinnerLayout->layout()->addWidget(ui->proofFrame);
	ui->spinnerLayout->layout()->addWidget(ui->sizeFrame);


	delete ui->centralWidget->layout();
	ui->centralWidget->setLayout(new QVBoxLayout);
	ui->centralWidget->layout()->addWidget(ui->spinnerLayout);
	ui->centralWidget->layout()->addWidget(ui->label_4);
	ui->label_4->setAlignment(Qt::AlignTop | Qt::AlignHCenter);
	this->show();
    }
}

void thriftydrinker::calculate()
{
    char test[80];
    float volumes[]= {354.882355 ,750 , 44.3602943, 58673.8827};//can,bottle,shot,keg
    //double result=0;
    float proof= ui->doubleSpinBox_2->value(); //0-200
    float volume = volumes[ui->comboBox->currentIndex()]; //mL
    float cost = ui->doubleSpinBox->value();
    if(cost)
	snprintf(test,80,"That is equivalent to paying $%.02lf for a can of lite beer!", cost/(proof/2*volume*.01)*MILLERFACTOR);
    ui->label_4->setText(test);
}
