// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//	Database thread

#pragma once


#include <string>

#include <ting/Thread.hpp>

#include "SQLite.hpp"
#include "Client.hpp"

//forward declarations
class Therver;



class DatabaseThread : public ting::Thread{
	friend class QueryUserPasswordMessage;
	friend class RegisterNewUserMessage;

	Therver* const t;

	sqlite::Database db;
public:

	DatabaseThread(Therver *mt, const std::string& dataDir);


	//override
	void Run();

private:
};



class QueryUserPasswordMessage : public ting::Message{
	DatabaseThread *t;

	//NOTE: the client should not be modified in Database thread,
	//this reference kept here just to pass it back to main server thread in
	//operation result message.
	ting::Ref< ::Client> c;

	std::string un;

public:
	QueryUserPasswordMessage(
			DatabaseThread* dbThr,
			ting::Ref< ::Client> client,
			const std::string& username
		) :
			t(dbThr),
			c(client),
			un(username.c_str())//copy string (as std::string is copy-on-write)
	{
		ASSERT(this->t)
		ASSERT(this->c)
	}
	
	//override
	void Handle();
};



class RegisterNewUserMessage : public ting::Message{
	DatabaseThread *t;

	//NOTE: the client should not be modified in Database thread,
	//this reference kept here just to pass it back to main server thread in
	//operation result message.
	ting::Ref< ::Client> c;

	std::string un;
	std::string pw;

public:
	RegisterNewUserMessage(
			DatabaseThread* dbThr,
			ting::Ref< ::Client> client,
			const std::string& username,
			const std::string& password
		) :
			t(dbThr),
			c(client),
			un(username.c_str()),//copy string (as std::string is copy-on-write)
			pw(password.c_str())//copy string (as std::string is copy-on-write)
	{
		ASSERT(this->t)
		ASSERT(this->c)
	}

private:
	//override
	void Handle();
};
