#include "managethemes.h"
#include "ui_managethemes.h"

managethemes::managethemes(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::managethemes)
{
    ui->setupUi(this);
    readthemes();
}

managethemes::~managethemes()
{
    delete ui;
}

void managethemes::readthemes()
{
    QDir colors("/opt/usr/share/themes");
    QStringList temp = colors.entryList(QDir::AllDirs | QDir::NoDotAndDotDot, QDir::DirsFirst);
    QStringList items;
    int count = temp.count();
    for(int i=0;i<count;i++)
    {
        if (QFile::exists("/opt/usr/share/themes/" + temp.at(i) + "/createdbythemecustomizer")) {
        //    ui->themelist->addItem(temp.at(i));
            items << temp.at(i);
        }
    }

    if ( items.isEmpty() ) {
        ui->themelist->addItem(tr("No themes created by Theme Customizer found"));
        ui->deletebutton->setDisabled(true);
    } else {
        ui->themelist->addItems(items);
        ui->themelist->setCurrentRow(0);
        ui->deletebutton->setEnabled(true);
    }
}
