#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#include <QtCore>
#include <QMainWindow>
#include <QProgressDialog>
#include <QColorDialog>
#include <QHash>
#include <QFile>
#include <QTextStream>
#include <QMessageBox>
#include <QRegExpValidator>
#include <QRegExp>
#include <QPixmap>
#include <QImage>
#include "backgrounds.h"
#include <QFileInfo>
#include <QPainter>
#include "savepreset.h"
#include "ui_savepreset.h"
#include "managepresets.h"
#include "ui_managepresets.h"
#include "savenewtheme.h"
#include "ui_savenewtheme.h"
#include "managethemes.h"
#include "ui_managethemes.h"
#include <QtMaemo5/QMaemo5InformationBox>
#include <QFileDialog>
#include <QDirIterator>
#include <QFileInfo>
#include <QFont>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    void oldfonts(QString preset);
    QString loadpr;
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    QProgressDialog progress;
    QProgressDialog progress2;
    QProgressDialog progress3;
    QProgressDialog progress4;
    QColorDialog colors;
    QString themepath;
    QString icontheme;
    QString wall1;
    QString wall2;
    QString wall3;
    QString wall4;
    void readdirs();
    void readthemes();
    void readgtkrc(QString themedir);
    QStringList fonts;
    QHash<QString, QString> variables;
    QHash<QString, QString> gtkrc;
    void readSettings();
    void writeSettings();
    void clean();
    void SetOpacity(QString imagefile, int opacity);
    void runscript(QString command);
    QString f1;
    QString f2;
    QString f3;
    QString f4;
    QString f5;
    QString f6;
    QString f7;
    QString f8;
    QString lastpath;
    QString saveasnew;
    QString checkboxstate;
    QString Icons;
    QString Transitions;
    QString themename;
    QString themedir;
    QString currenttheme;
    backgrounds* newWin;
    savepreset* SaveWin;
    managepresets* ManWin;
    savenewtheme* ThemeWin;
    managethemes* ManThemeWin;

private slots:
    void on_pushButton_2_clicked();
    void on_Fonter_currentFontChanged(QFont f);
    void on_theme_currentIndexChanged(int index);
    void on_actionImport_theme_triggered();
    void on_actionExport_theme_triggered();
    void deletetheme();
    void on_actionDelete_saved_themes_triggered();
    void on_actionSave_as_new_theme_triggered();
    void on_Opacity_top_editingFinished();
    void on_horizontalSlider_5_valueChanged(int value);
    void on_actionRestore_theme_files_triggered();
    void loadclicked();
    void delclicked();
    void on_pushButton_4_clicked();
    void savedone();
    void savetheme();
    void on_pushButton_3_clicked();
    void on_actionChange_backgrounds_triggered();
    void on_horizontalSlider_4_valueChanged(int value);
    void on_Opacity_editingFinished();
    void on_font8_editingFinished();
    void on_font7_editingFinished();
    void on_fontbuttonpressed_clicked();
    void on_fontbutton_clicked();
    void on_font6_editingFinished();
    void on_font5_editingFinished();
    void on_font4_editingFinished();
    void on_font3_editingFinished();
    void on_font2_editingFinished();
    void on_font1_editingFinished();
    void on_about_triggered();
    void on_fontimport_triggered();
    void on_fontdisabled_2_clicked();
    void on_fontpainted_clicked();
    void on_Snap_editingFinished();
    void on_horizontalSlider_3_valueChanged(int value);
    void on_checkBoxActivate_stateChanged(int );
    void on_lineEdit_2_editingFinished();
    void on_lineEdit_editingFinished();
    void on_horizontalSlider_2_valueChanged(int value);
    void on_fontdisabled_clicked();
    void on_fontactive_clicked();
    void on_fontsecondary_clicked();
    void on_fontprimary_clicked();
    void on_horizontalSlider_valueChanged(int);
    void on_pushButton_clicked();
//    void processFinished(int exitCode);
    void process2Finished(int exitCode);
    void process2Finished2(int exitCode);
};

#endif // MAINWINDOW_H
