#include <QtGui/QApplication>
#include "mainwindow.h"
#include <QTranslator>
#include <QLocale>

int main(int argc,
         char *argv[])
{
    QApplication a(argc, argv);

    //Reading /etc/osso-af-init/locale to check language
    QString langPath = "/opt/theme-customizer/lang/";
    QString line, lang;
    QFile data( "/etc/osso-af-init/locale" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
        QTextStream out(&data);
        while ( !out.atEnd() )
        {
            line = out.readLine();
            if ( line.indexOf("export LANG") == 0 )
            {
                lang = line;
                lang.replace("export LANG=","");
            }
        }
    }
    data.close();

    // Converting "en_GB" to "English"...
    QLocale::setDefault(lang);
    lang = QLocale::languageToString(QLocale(lang).language());

    // Installing language file
    QTranslator translator;
    if (!lang.isEmpty() && !langPath.isEmpty())
    {
        if (QFile::exists(langPath + lang + ".qm"))
        {
            translator.load(langPath + lang);
            a.installTranslator(&translator);
        }
    }

    MainWindow w;
#if defined(Q_WS_S60)
    w.showMaximized();
#else
    w.show();
#endif

    return a.exec();
}
