#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    progress(tr("Setting up the theme, please wait..."), tr("Abort"), 0, 0, this),
    progress2(tr("Searching and importing fonts, please wait..."), tr("Abort"), 0, 0, this),
    progress3(tr("Reading settings..."), tr("Abort"), 0, 100, this),
    progress4(tr("Restoring files, please wait..."), tr("Abort"), 0, 0, this),
    colors()
{
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);
    QString varattu3;
    varattu3 = tr("Reading settings");
    progress3.setWindowModality(Qt::WindowModal);
    progress3.setWindowTitle(varattu3);
    progress3.setCancelButton(0);
    progress3.setValue(0);
    progress3.show();
    progress3.setValue(5);
    readdirs();
    oldfonts("/etc/hildon/theme/colors.config");
    progress3.setValue(20);
    readSettings();
    progress3.setValue(30);
    QRegExp regexer("^\\#[0-9a-fA-F]{6,6}$");
    progress3.setValue(35);
    QRegExp regexer_icon("^[0-9]{2,3}$");
    QRegExp regexer_opaasi("^[0-9]{1,3}$");
    progress3.setValue(45);
    QRegExp regexer_book("^[0-9]{2,3}$");
    progress3.setValue(50);
    QRegExp regexer_snap("^[0-9]{1,2}$");
    progress3.setValue(60);
    ui->font1->setValidator(new QRegExpValidator(regexer, ui->font1));
    ui->font2->setValidator(new QRegExpValidator(regexer, ui->font2));
    ui->font3->setValidator(new QRegExpValidator(regexer, ui->font3));
    ui->font4->setValidator(new QRegExpValidator(regexer, ui->font4));
    ui->font5->setValidator(new QRegExpValidator(regexer, ui->font5));
    ui->font6->setValidator(new QRegExpValidator(regexer, ui->font6));
    ui->font7->setValidator(new QRegExpValidator(regexer, ui->font7));
    ui->font8->setValidator(new QRegExpValidator(regexer, ui->font8));
    progress3.setValue(70);
    ui->lineEdit->setValidator(new QRegExpValidator(regexer_icon, ui->lineEdit));
    ui->lineEdit_2->setValidator(new QRegExpValidator(regexer_book, ui->lineEdit_2));
    ui->Snap->setValidator(new QRegExpValidator(regexer_snap, ui->Snap));
    ui->Opacity->setValidator(new QRegExpValidator(regexer_opaasi, ui->Opacity));
    progress3.setValue(80);
    readgtkrc();
    progress3.setValue(100);
    progress3.cancel();

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::oldfonts(QString preset)
{

    QFile file(preset);
    file.open(QFile::ReadOnly);

    QTextStream stream ( &file );
    QString line;
    QHash<QString, QString> variables;
    do {
        line = stream.readLine();

        QStringList splittedLine = line.split("=");

        if (splittedLine.count()==2) {
        variables.insert(splittedLine.at(0), splittedLine.at(1));
    }
    } while (!line.isNull());

    file.close();


    fonts.clear();
    fonts.append(variables.value("DefaultTextColor"));
    fonts.append(variables.value("SecondaryTextColor"));
    fonts.append(variables.value("ActiveTextColor"));
    fonts.append(variables.value("DisabledTextColor"));


    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    const QString COLOR_STYLE2("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(variables.value("DefaultTextColor"), variables.value("DefaultBackgroundColor"), variables.value("DefaultTextColor")));
    ui->font1->setText(variables.value("DefaultTextColor"));
    f1=variables.value("DefaultTextColor");

    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(variables.value("SecondaryTextColor"), variables.value("DefaultBackgroundColor"), variables.value("SecondaryTextColor")));
    ui->font2->setText(variables.value("SecondaryTextColor"));
    f2=variables.value("SecondaryTextColor");

    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(variables.value("ActiveTextColor"), variables.value("DefaultBackgroundColor"), variables.value("ActiveTextColor")));
    ui->font3->setText(variables.value("ActiveTextColor"));
    f3=variables.value("ActiveTextColor");

    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(variables.value("DisabledTextColor"), variables.value("DefaultBackgroundColor"), variables.value("DisabledTextColor")));
    ui->font4->setText(variables.value("DisabledTextColor"));
    f4=variables.value("DisabledTextColor");

    ui->fontpainted->setStyleSheet(COLOR_STYLE2.arg(variables.value("PaintedTextColor"), variables.value("SelectionColor"), variables.value("PaintedTextColor")));
    ui->font5->setText(variables.value("PaintedTextColor"));
    f5=variables.value("PaintedTextColor");

    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(variables.value("SelectionColor"), variables.value("DefaultBackgroundColor"), variables.value("SelectionColor")));
    ui->font6->setText(variables.value("SelectionColor"));
    f6=variables.value("SelectionColor");

    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(variables.value("ButtonTextColor"), variables.value("DefaultBackgroundColor"), variables.value("ButtonTextColor")));
    ui->font7->setText(variables.value("ButtonTextColor"));
    f7=variables.value("ButtonTextColor");

    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(variables.value("ButtonTextPressedColor"), variables.value("DefaultBackgroundColor"), variables.value("ButtonTextPressedColor")));
    ui->font8->setText(variables.value("ButtonTextPressedColor"));
    f8=variables.value("ButtonTextPressedColor");
}

void MainWindow::readdirs()
{
    QDir colors("/usr/share/icons");
    QStringList colorstobox = colors.entryList(QDir::AllDirs | QDir::NoDotAndDotDot, QDir::DirsFirst);
    colorstobox.removeOne("default");
    ui->Iconset->addItems(colorstobox);
}

void MainWindow::readgtkrc()
{
    QFile file2("/etc/hildon/theme/gtk-2.0/gtkrc");
    file2.open(QFile::ReadOnly);

    QTextStream stream2 ( &file2 );
    QString line2;
    QHash<QString, QString> gtkrc;
    do {
        line2 = stream2.readLine();

        QStringList splittedLine = line2.split("=");

        if (splittedLine.count()==2) {
        gtkrc.insert(splittedLine.at(0), splittedLine.at(1));
    }
    } while (!line2.isNull());

    file2.close();

    QString icontheme;
    icontheme = gtkrc.value("gtk-icon-theme-name ");
    icontheme.remove(QChar('\"'));
    icontheme.remove(QChar(' '));
    icontheme.simplified();
    int indeksi = ui->Iconset->findText(icontheme);
    ui->Iconset->setCurrentIndex(indeksi);
}

void MainWindow::writeSettings()
{
    QSettings sett("ThemeCustomizer", "Boxes");
    sett.setValue("snap", ui->Snap->text());
    sett.setValue("fontsize", ui->FontSize->currentIndex());
    sett.setValue("iconset", ui->Iconset->currentIndex());
    sett.setValue("appsize", ui->lineEdit->text());
    sett.setValue("booksize", ui->lineEdit_2->text());
    sett.setValue("opacity", ui->Opacity->text());

    QString Icons;
    if ( ui->Icons->checkState() == Qt::Checked ) {
        sett.setValue("icons", "1");
    }
    else {
        sett.setValue("icons", "0");
    }
}

void MainWindow::readSettings()
{
    QSettings sett("ThemeCustomizer", "Boxes");
    int icons = sett.value("icons").toInt();
    int snap = sett.value("snap").toInt();
    int fontsize = sett.value("fontsize").toInt();
//    int iconset = sett.value("iconset").toInt();
    int appsize = sett.value("appsize").toInt();
    int booksize = sett.value("booksize").toInt();
    int opacity = sett.value("opacity").toInt();
    QString appsizestring = sett.value("appsize").toString();
    QString booksizestring = sett.value("booksize").toString();
    QString snapstring = sett.value("snap").toString();
    QString opacitystring = sett.value("opacity").toString();
    // ui->Icons->setCurrentIndex(icons);
    // ui->Snap->setCurrentIndex(snap);

    if ( icons == 1 ) {
        ui->Icons->setCheckState(Qt::Checked);
    } else {
        ui->Icons->setCheckState(Qt::Unchecked);
    }

    ui->FontSize->setCurrentIndex(fontsize);
//    ui->Iconset->setCurrentIndex(iconset);

    if ( appsize > 15 ) {
    ui->lineEdit->setText(appsizestring);
    ui->horizontalSlider->setValue(appsize);
    }

    if ( booksize > 25 ) {
    ui->lineEdit_2->setText(booksizestring);
    ui->horizontalSlider_2->setValue(booksize);
    }

    if ( snap > 3 ) {
    ui->Snap->setText(snapstring);
    ui->horizontalSlider_3->setValue(snap);
    }

 //   if ( opacity > 0 ) {
    ui->Opacity->setText(opacitystring);
    ui->horizontalSlider_4->setValue(opacity);
 //   }

}

void MainWindow::SetOpacity(QString imagefile, int opacity)
{

    QPixmap temp;
    QString realimagefile = QFileInfo("/etc/hildon/theme/images/" + imagefile).canonicalFilePath();
    QString imagebackup = "/opt/theme-customizer/backups/" + realimagefile;
    temp = QPixmap(imagebackup);
    QPixmap transparent(temp.size());
    transparent.fill(Qt::transparent);
    QPainter p(&transparent);
    p.setCompositionMode(QPainter::CompositionMode_Source);
    p.drawPixmap(0, 0, temp);
    p.setCompositionMode(QPainter::CompositionMode_DestinationIn);
    p.fillRect(transparent.rect(), QColor(0, 0, 0, opacity));  // opacity value can be 0-255
    p.end();
    // Save the new image
    transparent.save(realimagefile);
    // system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:'Image saved!' uint32:0 string:'OK'");

}

void MainWindow::on_pushButton_clicked()
{
        QString checkboxstate;
        if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
            checkboxstate = "Reboot";
        }
        else {
            checkboxstate = "0";
        }

        QString Icons;
        if ( ui->Icons->checkState() == Qt::Checked ) {
            Icons = "Show icons";
        }
        else {
            Icons = "Don't show icon backgrounds";
        }

        writeSettings();
        QString varattu;
        varattu = "Theme Customizer";
        progress.setWindowModality(Qt::WindowModal);
        progress.setWindowTitle(varattu);
        progress.setCancelButton(0);
        QStringList arguments;
        arguments << ui->FontSize->currentText() << ui->Fonter->currentText() << ui->Iconset->currentText() << Icons << ui->lineEdit->text() << ui->Snap->text() << checkboxstate << fonts << f1 << f2 << f3 << f4 << ui->lineEdit_2->text() << f5 << f6 << f7 << f8 << ui->Opacity->text();
        QProcess *process = new QProcess(this);
        connect(process, SIGNAL(finished(int)), this, SLOT(processFinished(int)));
        process->start("/sbin/launchcustomizer", arguments);
        progress.show();

}

void MainWindow::processFinished(int)
{
    int opasity = ui->Opacity->text().toInt();
    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Setting up widget opacities...'");
    SetOpacity("ApplicationShortcutApplet.png", opasity);
    SetOpacity("CalendarAppletBackground.png", opasity);
    SetOpacity("ContactsAppletFrame.png", opasity);
    SetOpacity("MapAppletButton.png", opasity);
    SetOpacity("MapAppletHead.png", opasity);
    SetOpacity("MediaPlayerAppletHead.png", opasity);
    SetOpacity("MediaPlayerAppletNext.png", opasity);
    SetOpacity("MediaPlayerAppletPrevious.png", opasity);
    SetOpacity("MediaPlayerAppletStopPlay.png", opasity);
    SetOpacity("OviCenter.png", opasity);
    SetOpacity("OviLeft.png", opasity);
    SetOpacity("OviRight.png", opasity);
    SetOpacity("RSSAppletHead.png", opasity);
    SetOpacity("WebShortcutAppletBackground.png", opasity);

    if ( ui->checkBoxActivate->checkState() == Qt::Unchecked ) {

        system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:'Restarting services, your screen will blink! After all is done, rebooting the device is recommended to reload all new values' uint32:0 string:'OK'");
        system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Restarting hildon-home...'");
        system("run-standalone.sh /usr/sbin/dsmetool -k /usr/bin/hildon-home");
        system("sleep 2");
        system("run-standalone.sh /usr/sbin/dsmetool -t /usr/bin/hildon-home");
        system("sleep 2 && killall hildon-status-menu");
        system("sleep 2 && killall systemui");
        system("sleep 2 && killall hildon-desktop");
        system("killall theme-customizer");

    } else {

    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Rebooting in 5 seconds, fasten your seatbelts!'");
    system("/sbin/launchcustomizer rebootnow");
    progress.cancel();
    // oldfonts();

}

}

void MainWindow::on_horizontalSlider_valueChanged(int value)
{
    QString slaideri = QString::number(value);
    ui->lineEdit->setText(slaideri);
}

void MainWindow::on_horizontalSlider_2_valueChanged(int value)
{
    QString slaideri2 = QString::number(value);
    ui->lineEdit_2->setText(slaideri2);
}

void MainWindow::on_horizontalSlider_3_valueChanged(int value)
{
    QString slaideri3 = QString::number(value);
    ui->Snap->setText(slaideri3);
}

void MainWindow::on_horizontalSlider_4_valueChanged(int value)
{
    QString slaideri4 = QString::number(value);
    ui->Opacity->setText(slaideri4);
}

void MainWindow::on_fontprimary_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f1;
    QColor color1 = colors.getColor(current.name());

    if (!color1.isValid()) return;
    f1 = color1.name();
    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(f1, variables.value("DefaultBackgroundColor"), f1));
    ui->font1->setText(f1);
}


void MainWindow::on_fontsecondary_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f2;
    QColor color2 = colors.getColor(current.name());


    if (!color2.isValid()) return;
    f2 = color2.name();
    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(f2, variables.value("DefaultBackgroundColor"), f2));
    ui->font2->setText(f2);
}

void MainWindow::on_fontactive_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f3;
    QColor color3 = colors.getColor(current.name());


    if (!color3.isValid()) return;
    f3 = color3.name();
    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(f3, variables.value("DefaultBackgroundColor"), f3));
    ui->font3->setText(f3);
}

void MainWindow::on_fontdisabled_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f4;
    QColor color4 = colors.getColor(current.name());


    if (!color4.isValid()) return;
    f4 = color4.name();
    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(f4, variables.value("DefaultBackgroundColor"), f4));
    ui->font4->setText(f4);
}

void MainWindow::on_fontpainted_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f5;
    QColor color5 = colors.getColor(current.name());


    if (!color5.isValid()) return;
    f5 = color5.name();
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
    ui->font5->setText(f5);
}

void MainWindow::on_fontdisabled_2_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f6;
    QColor color6 = colors.getColor(current.name());


    if (!color6.isValid()) return;
    f6 = color6.name();
    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(f6, variables.value("DefaultBackgroundColor"), f6));
    ui->font6->setText(f6);
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_fontbutton_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f7;
    QColor color7 = colors.getColor(current.name());


    if (!color7.isValid()) return;
    f7 = color7.name();
    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(f7, variables.value("DefaultBackgroundColor"), f7));
    ui->font7->setText(f7);
}

void MainWindow::on_fontbuttonpressed_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f8;
    QColor color8 = colors.getColor(current.name());


    if (!color8.isValid()) return;
    f8 = color8.name();
    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(f8, variables.value("DefaultBackgroundColor"), f8));
    ui->font8->setText(f8);
}

void MainWindow::on_lineEdit_editingFinished()
{
    QString slvalue = ui->lineEdit->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider->setValue(svalue);
}

void MainWindow::on_lineEdit_2_editingFinished()
{
    QString slvalue = ui->lineEdit_2->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_2->setValue(svalue);
}

void MainWindow::on_Snap_editingFinished()
{
    QString slvalue = ui->Snap->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_3->setValue(svalue);
}

void MainWindow::on_Opacity_editingFinished()
{
    QString slvalue = ui->Opacity->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_4->setValue(svalue);
}

void MainWindow::on_checkBoxActivate_stateChanged(int )
{
    if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
        ui->pushButton->setText(tr("Save and reboot"));
    }
    else {
        ui->pushButton->setText(tr("Apply changes"));
    }
}

void MainWindow::on_fontimport_triggered()
{

    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("Theme Customizer - font import"));
    msgBox.setText(tr("Do you want to import fonts from MyDocs?"));
    msgBox.setInformativeText(tr("Note: this function will only import .ttf and .otf fonts from root of MyDocs"));
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    msgBox.setDefaultButton(QMessageBox::Yes);
    msgBox.button(msgBox.Yes)->setText(tr("Yes"));
    msgBox.button(msgBox.No)->setText(tr("No"));
    int ret = msgBox.exec();

    if ( ret == QMessageBox::Yes ) {

        QString varattu2;
        varattu2 = tr("Importing fonts");
        progress2.setWindowModality(Qt::WindowModal);
        progress2.setWindowTitle(varattu2);
        progress2.setCancelButton(0);
        QStringList arguments2;
        arguments2 << "importfontspushed";
        QProcess *process2 = new QProcess(this);
        connect(process2, SIGNAL(finished(int)), this, SLOT(process2Finished(int)));
        process2->start("/sbin/launchcustomizer", arguments2);
        progress2.show();

    }

}

void MainWindow::process2Finished(int)
{
    progress2.cancel();
}

void MainWindow::on_about_triggered()
{
    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("About Theme Customizer"));
    msgBox.setText("Author: D-Iivil - Licence: Freeware & open source");
    msgBox.setTextFormat(Qt::RichText);
    msgBox.setInformativeText("<html>Version: 0.9-23<br /><a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=ricky%40hevikaraoke%2efi&lc=FI&item_name=Here%27s%20some%20money%20for%20beer%2e&no_note=0&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHostedGuest\">Be a nice guy and <b>donate some money for beer</b> to author</a></html>");
    msgBox.setStandardButtons(QMessageBox::Ok);
    msgBox.setDefaultButton(QMessageBox::Ok);
    msgBox.button(msgBox.Ok)->setText(tr("Ok, thanks."));
    msgBox.exec();
}

void MainWindow::on_font1_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f1 = ui->font1->text();
    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(f1, variables.value("DefaultBackgroundColor"), f1));

}

void MainWindow::on_font2_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f2 = ui->font2->text();
    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(f2, variables.value("DefaultBackgroundColor"), f2));
}

void MainWindow::on_font3_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f3 = ui->font3->text();
    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(f3, variables.value("DefaultBackgroundColor"), f3));
}

void MainWindow::on_font4_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f4 = ui->font4->text();
    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(f4, variables.value("DefaultBackgroundColor"), f4));
}

void MainWindow::on_font5_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f5 = ui->font5->text();
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_font6_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f6 = ui->font6->text();
    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(f6, variables.value("DefaultBackgroundColor"), f6));
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_font7_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f7 = ui->font7->text();
    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(f7, variables.value("DefaultBackgroundColor"), f7));
}

void MainWindow::on_font8_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f8 = ui->font8->text();
    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(f8, variables.value("DefaultBackgroundColor"), f8));
}

void MainWindow::on_actionChange_backgrounds_triggered()
{
    newWin = new backgrounds(this);
    newWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    newWin->setAttribute(Qt::WA_DeleteOnClose);

    newWin->show();
}

void MainWindow::on_pushButton_3_clicked()
{
    SaveWin = new savepreset(this);
    connect(SaveWin->ui->Save, SIGNAL(clicked()), this, SLOT(savedone()));
    SaveWin->show();
}

void MainWindow::savedone()
{
    QString presetname = SaveWin->ui->FileName->text();
    presetname.remove(QChar('\"'));
    presetname.remove(QChar(' '));
    presetname.simplified();
    QFile file("/opt/theme-customizer/presets/" + presetname);
    if (presetname.isEmpty()) {
 //       system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:'You must give name for the preset' uint32:0 string:'OK'");

        QMaemo5InformationBox::information(this, "You must give name for the preset.",
                                           QMaemo5InformationBox::DefaultTimeout);

    } else if (file.exists()) {
        QMessageBox msgBox;
        msgBox.setWindowTitle(tr("Overwrite color preset?"));
        msgBox.setText(tr("Color preset with this name already exists, do you want to overwrite it?"));
        msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        msgBox.setDefaultButton(QMessageBox::Yes);
        msgBox.button(msgBox.Yes)->setText(tr("Yes"));
        msgBox.button(msgBox.No)->setText(tr("No"));
        int ret = msgBox.exec();

        if ( ret == QMessageBox::Yes ) {

            if (file.exists()) file.remove();
            file.open(QIODevice::WriteOnly | QIODevice::Text);
            QTextStream out(&file);
            out << "DefaultTextColor=" << f1 << "\n" << "SecondaryTextColor=" << f2 << "\n" << "ActiveTextColor=" << f3 << "\n" << "DisabledTextColor=" << f4 << "\n" << "PaintedTextColor=" << f5 << "\n" << "SelectionColor=" << f6 << "\n" << "ButtonTextColor=" << f7 << "\n" << "ButtonTextPressedColor=" << f8 << "\n";

            // optional, as QFile destructor will already do it:
            file.close();
            SaveWin->hide();
            QMaemo5InformationBox::information(this, "Preset saved!",
                                               QMaemo5InformationBox::DefaultTimeout);

        }
    } else {
        file.open(QIODevice::WriteOnly | QIODevice::Text);
        QTextStream out(&file);
        out << "DefaultTextColor=" << f1 << "\n" << "SecondaryTextColor=" << f2 << "\n" << "ActiveTextColor=" << f3 << "\n" << "DisabledTextColor=" << f4 << "\n" << "PaintedTextColor=" << f5 << "\n" << "SelectionColor=" << f6 << "\n" << "ButtonTextColor=" << f7 << "\n" << "ButtonTextPressedColor=" << f8 << "\n";

        // optional, as QFile destructor will already do it:
        file.close();
        SaveWin->hide();
        QMaemo5InformationBox::information(this, "Preset saved!",
                                           QMaemo5InformationBox::DefaultTimeout);
    }
}

void MainWindow::on_pushButton_4_clicked()
{
    ManWin = new managepresets(this);
  //  connect(ManWin->ui->presetslist, SIGNAL(currentIndexChanged(int)), this, SLOT(on_presetslist_currentIndexChanged(int)));
    connect(ManWin->ui->loadbutton, SIGNAL(clicked()), this, SLOT(loadclicked()));
    connect(ManWin->ui->delbutton, SIGNAL(clicked()), this, SLOT(delclicked()));
    ManWin->show();
}

void MainWindow::loadclicked()
{
    if (ManWin->ui->presetslist->currentIndex() == 1) {
        loadpr = "/etc/hildon/theme/colors.config";
    } else if (ManWin->ui->presetslist->currentIndex() == 2) {
        QString colorfile = QFileInfo("/etc/hildon/theme/colors.config").canonicalFilePath();
        QString originalcolorfile = "/opt/theme-customizer/backups/" + colorfile;
        if (QFile(originalcolorfile).exists()) {
            loadpr = originalcolorfile;
        } else {
            loadpr = "/etc/hildon/theme/colors.config";
        }
    } else {
    loadpr = "/opt/theme-customizer/presets/" + ManWin->ui->presetslist->currentText();
    }
    oldfonts(loadpr);
    ManWin->hide();
    QMaemo5InformationBox::information(this, "Preset loaded.",
                                       QMaemo5InformationBox::DefaultTimeout);
}

void MainWindow::delclicked()
{
    QFile file("/opt/theme-customizer/presets/" + ManWin->ui->presetslist->currentText());
    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("Delete color preset?"));
    msgBox.setText(tr("Are you sure you want to delete this preset?"));
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    msgBox.setDefaultButton(QMessageBox::Yes);
    msgBox.button(msgBox.Yes)->setText(tr("Yes"));
    msgBox.button(msgBox.No)->setText(tr("No"));
    int ret = msgBox.exec();

    if ( ret == QMessageBox::Yes ) {

        if (file.exists()) file.remove();
        ManWin->hide();
        QMaemo5InformationBox::information(this, "Preset deleted.",
                                           QMaemo5InformationBox::DefaultTimeout);

    }
}

void MainWindow::on_actionRestore_theme_files_triggered()
{
    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("Theme Customizer - restore files"));
    msgBox.setText(tr("Do you want to restore all original theme files?"));
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    msgBox.setDefaultButton(QMessageBox::Yes);
    msgBox.button(msgBox.Yes)->setText(tr("Yes"));
    msgBox.button(msgBox.No)->setText(tr("No"));
    int ret = msgBox.exec();

    if ( ret == QMessageBox::Yes ) {

        QString varattu2;
        varattu2 = tr("Restoring files from backup");
        progress4.setWindowModality(Qt::WindowModal);
        progress4.setWindowTitle(varattu2);
        progress4.setCancelButton(0);
        QStringList arguments2;
        arguments2 << "restorefilespushed";
        QProcess *process4 = new QProcess(this);
        connect(process4, SIGNAL(finished(int)), this, SLOT(process2Finished2(int)));
        process4->start("/sbin/launchcustomizer", arguments2);
        progress4.show();

    }
}

void MainWindow::process2Finished2(int)
{
    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:'Restarting services, your screen will blink! After all is done, rebooting the device is recommended to reload all new values' uint32:0 string:'OK'");
    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Restarting hildon-home...'");
    system("run-standalone.sh /usr/sbin/dsmetool -k /usr/bin/hildon-home");
    system("sleep 2");
    system("run-standalone.sh /usr/sbin/dsmetool -t /usr/bin/hildon-home");
    system("sleep 2 && killall hildon-status-menu");
    system("sleep 2 && killall systemui");
    system("sleep 2 && killall hildon-desktop");
    system("killall theme-customizer");
}
