using Gtk;
using GLib;

public class Tear.UIManager : Gtk.UIManager {
	public ActionGroup action_group;
  	public string merge_ui_path;
  	public uint m_id;
	
	private static UIManager instance;
  	private ActionGroup collection_action_group;
  	private string current_group;
  	
#if FREMANTLE
	public const ActionEntry[] page = {
	
		{ "windows-new", Gtk.STOCK_NEW, "New window", null, "New window", null },
		{ "windows-undo", Gtk.STOCK_UNDO, "Undo Close", "<ctrl>Z", "Undo Close", null },

//		{ "page-saveas", null, "Save as...", null, "Save as...", null },
		{ "tools-downloads", null, "Downloads...", "<ctrl>Y", "Downloads...", null },
		{ "tools-options", null, "Options...", "<ctrl>O", "Options...", null },
		
		{ "close-remember", null, "Close and Save All", null, "Close and Save All", null }
	};

	public const ActionEntry[] tools = {
		{ "tools-find", null, "Find on page", "<ctrl>F", "Find on page", null },
		{ "tool-dashboard", null, "Open Dashboard", null, "Open Dashboard", null }
	};

	public const ToggleActionEntry[] toggles = {
		{ "view-fullscreen", null, "Full Screen", null, "Full Screen", null, false },
		{ "tool-showimages", null, "Show Images", "<ctrl>I", "auto_load_images", null, true },
		{ "tool-plugins", null, "Enable Plugins", "<ctrl>P", "enable_plugins", null, true },
		{ "tool-javascript", null, "Enable Javascript", null, "enable_scripts", null, true }
	};
	
	public const ActionEntry[] private_data = {
		{ "tools-clearcookies", null, "Clear Cookies...", null, "Clear Cookies...", null },
		{ "tools-clearhistory", null, "Clear History...", null, "Clear History...", null },
		{ "tools-clearsearches", null, "Purge Searches...", null, "Purge Searches...", null }
	};
	
	public const ActionEntry[] additional = {
		{ "tool-zoomin", null, "Zoom in", null, "Zoom in", null },
		{ "tool-zoomout", null, "Zoom out", null, "Zoom out", null },
		{ "page-remove-bookmark", null, "Remove Bookmark", null, "Remove Bookmark", null }
	};
	
	public const ActionEntry[] page_actions = {
		{ "page-add-bookmark", null, "Add Bookmark", null, "Add Bookmark", null },
		{ "tool-bookmarks", null, "Bookmarks...", null, "Bookmarks...", null },
		{ "page-set-homepage", null, "Set Homepage", null, "Set Homepage", null },
		{ "tools-rss", null, "Open RSS Feed...", null, "Open RSS Feed...", null },
		{ "tools-find", null, "Find on Page", null, "Find on Page", null },
		{ "page-details", null, "Details", null, "Details", null }
	};
	
#else
	private const ActionEntry[] actions = {
	
		{ "windows", null, "_Windows" },
		{ "windows-new", Gtk.STOCK_NEW, "New window", null, "New window", null },
		{ "windows-opennew", Gtk.STOCK_NEW, "Open in new window", null, "Open in new window", null },
		{ "windows-open", Gtk.STOCK_OPEN, "Open", null, "Open", null },
		{ "windows-undo", Gtk.STOCK_UNDO, "Undo Close", "<ctrl>Z", "Undo Close", null },

		{ "page", null, "_Page" },
		{ "page-openloc", null, "Open location...", null, "Open location...", null },
		{ "page-openfile", null, "Open file...", null, "Open file...", null },
		{ "page-saveas", null, "Save as...", null, "Save as...", null },
		{ "page-add-bookmark", null, "Add bookmark...", null, "Add bookmark...", null },
		{ "page-set-homepage", null, "Set home page", null, "Set home page", null },
		{ "page-details", null, "Details", null, "Details", null },
		
		{ "edit", null, "_Edit" },
		{ "edit-cut", null, "Cut", null, "Cut", null },
		{ "edit-copy", null, "Copy", null, "Copy", null },
		{ "edit-paste", null, "Paste", null, "Paste", null },
		{ "edit-select-all", null, "Select All", null, "Select All", null },
		
		{ "view", null, "_View" },
		{ "view-encoding", null, "Encoding...", null, "Encoding...", null },
		{ "view-zoom100", null, "Zoom to 100%", null, "Zoom to 100%", null },
		{ "view-toolbar", null, "Toolbar", null, "Toolbar", null },
		
		{ "tools", null, "_Tools" },
		{ "tools-find", null, "Find on page", "<ctrl>F", "Find on page", null },
		{ "tools-downloads", null, "Download Manager...", "<ctrl>Y", "Downloads...", null },
		{ "tools-options", null, "Options...", "<ctrl>O", "Options...", null },
		{ "tools-clearcookies", null, "Clear Cookies...", null, "Clear Cookies...", null },
		{ "tools-clearhistory", null, "Clear History...", null, "Clear History...", null },
		{ "tools-clearsearches", null, "Purge Searches...", null, "Purge Searches...", null },
		
		{ "devel", null, "_Developer" },
		{ "devel-inspect", null, "Inspect Element", null, "Inspect Element", null },
		{ "devel-something", null, "Something", null, "Placeholder", null },
		
		{ "help", null, "_Help" },
		{ "help-about", Gtk.STOCK_ABOUT, "About", null, "About", null },
		
		{ "close", null, "_Close" },
		{ "close-window", null, "Close Window", "<ctrl>W", "Close Window", null },
		{ "close-all-windows", null, "Close All Windows", "<ctrl>Q", "Close All Windows", null },
		{ "close-remember", null, "Close and Save All", null, "Close and Save All", null },
		
		{ "tool-bookmarks", null, "Bookmarks", null, "Bookmarks", null },
		{ "tool-zoomin", null, "Zoom in", null, "Zoom in", null },
		{ "tool-zoomout", null, "Zoom out", null, "Zoom out", null },
		{ "tool-dashboard", null, "Open Dashboard", null, "Open Dashboard", null },

		{ "toolbar-back", null, "Back in history", null, "Back in history", null },
		{ "toolbar-forward", null, "Forward in history", null, "Forward in history", null },
		{ "toolbar-reload", null, "Reload page", "<ctrl>R", "Reload page", null },
		
		{ "toolbar-add", null, null, null, null, null },
		{ "toolbar-entry", null, null, null, null, null },
		{ "toolbar-go", null, null, null, null, null },
		{ "toolbar-menu", null, null, null, null, null }
	};
	
	public const ToggleActionEntry[] toggles = {
		{ "view-fullscreen", null, "Full Screen", null, "Full Screen", null, false },
		{ "tool-showimages", null, "Show Images", "<ctrl>I", "auto_load_images", null, true },
		{ "tool-plugins", null, "Enable Plugins", "<ctrl>P", "enable_plugins", null, true },
		{ "tool-javascript", null, "Enable Javascript", null, "enable_scripts", null, true },
		{ "view-show-toolbar", null, "Show Toolbar", null, "show_toolbar", null, true },
		{ "view-show-toolbar-full", null, "Show Toolbar in Fullscreen", null, "show_toolbar_fullscreen", null, true },
		{ "view-show-progressline", null, "Show Progress Line", null, "show_progressline", null, true },
		{ "view-show-progressline-full", null, "Show Progress Line in Fullscreen", null, "show_progressline_fullscreen", null, true },
		{ "view-show-toolbar-bottom", null, "Show at Bottom", null, "toolbar_orientation", null, true },
		{ "view-show-toolbar-bottom-full", null, "Show at Bottom in Fullscreen", null, "toolbar_orientation_fullscreen", null, true }
	};
		
#endif

	construct {
		add_ui_from_string (uidef, -1);
		
		action_group = new ActionGroup ("general");

#if FREMANTLE 
		action_group.add_actions(page, null);
		action_group.add_actions(tools, null);
		action_group.add_actions(private_data, null);
		action_group.add_actions(additional, null);
		action_group.add_actions(page_actions, null);
#else
		action_group.add_actions(actions, null);
#endif
		action_group.add_toggle_actions(toggles, null);
		insert_action_group (action_group, 0);
	}
	
	public void update_toggles () {
	    for ( var i = 0; i < toggles.length; i++ ) {  
		    if (toggles[i].name != "view-fullscreen") {
		    	unowned ToggleAction act = (ToggleAction) this.action_group.get_action(toggles[i].name);
		    	act.action_group = null;
			    if (toggles[i].name == "view-show-toolbar-bottom" || toggles[i].name == "view-show-toolbar-bottom-full")
				    act.active = (options.get_option( toggles[i].tooltip ) == "bottom" ? true : false);
			    else
	    			act.active = options.get_bool(toggles[i].tooltip);
	    		
		    	act.action_group = this.action_group;
	    	}
    	}
	}

	public static UIManager get_instance () {
		if (instance == null)
			instance = new UIManager ();
		return instance;
	}

	public new Action get_action (string name) {
		return this.action_group.get_action (name);
	}

    public void collection_activate (Action action) {
        var url = action.tooltip;
        
		get_topmost_window().web_view.stop_loading ();
        get_topmost_window().start(url);
    }

	public void update_action_collection (HashTable<string,string> collection, string group_name) {
		
		this.remove_ui (this.m_id);
	
		this.collection_action_group = new ActionGroup (group_name);
		this.insert_action_group (this.collection_action_group, 0);
	
		weak List<Action> actions = collection_action_group.list_actions ();
		foreach (Action act in actions) {
			act.activate -= collection_activate;
			collection_action_group.remove_action (act);
		}
	
//		this.m_id = this.new_merge_id ();

		this.current_group = group_name;
	
		collection.for_each((k, v) => {
			string action_name = this.current_group + Random.int_range(0, 10000).to_string();
			string label = shorten_string( (string) k );
			string tip = (string) v;

			Action action = new Action (action_name, label, tip, null);
			
			action.activate += collection_activate;
			this.collection_action_group.add_action (action);
			
			this.add_ui (this.m_id, this.merge_ui_path, action_name, action_name,  // Needs a collection of merge_ids and
			             UIManagerItemType.MENUITEM, false);						   // merge_ui_paths to support more menu placeholders
		});																			   // can be accessed with group_name
	}

	private string uidef="""
	<ui>
		<menubar name="menu">
			<menu action="windows">
				<placeholder name="windows-placeholder">
					<separator/>
				</placeholder>
				<menuitem action="windows-new"/>
				<separator/>
				<menuitem action="windows-undo"/>
			</menu>
			
			<menu action="page">
				<!--menuitem action="page-openloc"/-->
				<menuitem action="page-openfile"/>
				<!--menuitem action="page-saveas"/-->
				<separator/>
				<menuitem action="page-add-bookmark"/>
				<menuitem action="page-set-homepage"/>
				<!--separator/>
				<menuitem action="page-details"/-->
			</menu>
			
			<menu action="edit">
				<menuitem action="edit-copy"/>
				<menuitem action="edit-cut"/>
				<menuitem action="edit-paste"/>
				<!--separator/>
				<menuitem action="edit-select-all"/-->
			</menu>
			
			<menu action="view">
				<menuitem action="toolbar-back"/>
				<menuitem action="toolbar-forward"/>
				<menuitem action="toolbar-reload"/>
				<separator/>
				<menuitem action="tool-zoomin" />
				<menuitem action="tool-zoomout" />
				<menuitem action="view-zoom100" />
				<separator/>
				<menu action="view-toolbar">
					<menuitem action="view-show-toolbar" />
					<menuitem action="view-show-toolbar-full" />
					<separator/>
					<menuitem action="view-show-progressline" />
					<menuitem action="view-show-progressline-full" />
					<separator/>
					<menuitem action="view-show-toolbar-bottom" />
					<menuitem action="view-show-toolbar-bottom-full" />
				</menu>
				<separator/>
				<!--menuitem action="view-encoding"/-->
				<menuitem action="view-fullscreen"/>
			</menu>
			
			<menu action="tools">
				<menuitem action="tools-find"/>
				<separator/>
				<menuitem action="tool-dashboard" />
				<separator/>
				<menuitem action="tool-javascript" />
				<menuitem action="tool-plugins" />
				<menuitem action="tool-showimages" />
				<menuitem action="tools-clearcookies" />
				<menuitem action="tools-clearhistory" />
				<menuitem action="tools-clearsearches" />
				<separator/>
				<menuitem action="tools-downloads"/>
				<separator/>
				<menuitem action="tools-options"/>
			</menu>
			
			<menu action="help">
				<menuitem action="help-about"/>
			</menu>
			
			<menu action="close">
				<menuitem action="close-window"/>
				<menuitem action="close-all-windows"/>
				<separator/>
				<menuitem action="close-remember"/>
			</menu>
		
		</menubar>
		
#if !FREMANTLE
		<popup name="tool-popup">
			<placeholder name="tool-booklet-placeholder">
				<separator/>
			</placeholder>
			<separator/>
			<menu action="tool-bookmarks">
				<placeholder name="tool-book-placeholder">
					<separator/>
				</placeholder>
			</menu>
			<menuitem action="tool-dashboard" />
			<!--menuitem action="tool-zoomin" />
			<menuitem action="tool-zoomout" /-->
			<separator/>
			<menuitem action="tools-find" />
			<menuitem action="tool-javascript" />
			<menuitem action="tool-plugins" />
			<menuitem action="tool-showimages" />
		</popup>
#endif

		<popup name="web-popup">
			<!--menuitem action="windows-open" />
			<menuitem action="windows-opennew" />
			<separator/-->
			<menuitem action="edit-cut" />
			<menuitem action="edit-copy" />
			<menuitem action="edit-paste" />
			<menuitem action="edit-select-all" />
			<separator/>
			<menuitem action="devel-inspect" />
		</popup>

		<toolbar name="toolbar">
			<toolitem action="toolbar-back" />
			<toolitem action="toolbar-forward" />
			<toolitem action="toolbar-reload" />
			<separator/>
			<toolitem action="toolbar-add" />
			<toolitem action="toolbar-entry" />
			<separator/>
			<toolitem action="toolbar-go" />
			<separator/>
			<toolitem action="toolbar-menu"/>
		</toolbar>

	</ui>""";
}
