using GLib;
using DBus;
using ConIc;
using WebKit;

public class Tear.ConnectionManager : GLib.Object {
	
	public ConIc.ConnectionStatus status;
	
	private ConIc.Connection connection;
	private WebKit.WebView requested_view;
	private string requested_uri;
	
	construct {
		requested_view = null;
		requested_uri = "";
		
		connection = new ConIc.Connection();
		
		connection.connection_event += (s, ce) => {
			status = ce.get_status();

			if (requested_view != null && requested_uri != "" && status == ConIc.ConnectionStatus.CONNECTED) {
				requested_view.open( requested_uri );
				
				requested_view = null;
				requested_uri = "";
			}
		};
	
		connection.automatic_connection_events =  true;
	}

	public void ensure_connection (WebKit.WebView view, string uri) {
		if (uri != "") {
			requested_view = view;
			requested_uri = uri;
		}
		
		connection.connect ( ConIc.ConnectFlags.NONE );
	}
	
}