using GLib; 
using Gtk;
using Hildon;

public class Tear.About: Gtk.AboutDialog {

	private Note note;

    construct {

#if FREMANTLE
		this.note = new Note.information ( this, "Tear " + Config.VERSION_MAJOR_MINOR + """
		
Tear is a browser using the WebKitGtk engine. Still beta, so don't expect everything to work.

Tear is free software: you can redistribute it and/or modify it under the terms of the GNU GPL 3 or later.

Website: http://www.bundyo.org/maemo/tear

Copyright © 2008-2009 Bundyo""" );
#else
        this.version = Config.VERSION_MAJOR_MINOR;
        this.copyright = "Copyright © 2008-2009 Bundyo";

        this.comments = _("""Tear is a WebKitGtk wrapper browser. Still early in development (considered beta at best), so don't expect everything to work.""");

        this.license = _("""Tear is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by 
the Free Software Foundation, either version 3 of the License, or 
(at your option) any later version.

Tear is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with Tear. If not, see <http://www.gnu.org/licenses/>.""");
        this.wrap_license = true;
        this.set_url_hook (open_link);
        this.set_website( "http://www.bundyo.org/maemo/tear" );
        
        string[] authors = {Config.MAINTAINER, "Ignacius <pvaneck@gmail.com>"};
        this.set_authors(authors);

        this.logo = new Gdk.Pixbuf.from_file(Config.PIXMAPS_DIR + "/" + Config.PACKAGE + ".png");
        this.response += (about) => {
       		this.hide();
        };
#endif
    }
    
#if FREMANTLE
    public void go () {
   		note.run();
		note.hide();
    }
#endif
    
	public void open_link (Gtk.AboutDialog about, string link) {
		this.hide();
		get_topmost_window ().web_view.open(link);
	}
}