# -*- coding: utf-8 -*-
'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
"""
Module implementing CategoryProperties.
"""

from PyQt4.QtGui import QMainWindow
from PyQt4.QtCore import *
from PyQt4.QtCore import pyqtSignature
from PyQt4.QtGui import QStandardItem, QItemSelectionModel
import time

from xml.etree.ElementTree import *
from Ui_categoryProperties import Ui_CategoryProperties

class CategoryProperties(QMainWindow, Ui_CategoryProperties):
    """
    Class documentation goes here.
    """
    def __init__(self, parent,  category = None, qSICategory = None, parentCategory = None, etree = None, qSIRow = None, categoryModel = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        
        self.__parent = parent
        self.__category = category
        #print self.__category
        self.__qSICategory = qSICategory
        self.__qSIRow = qSIRow
        self.__parentCategory = parentCategory
        self.__etree = etree
        self.__action = None
        self.__categoryModel = categoryModel
        
        #Edit category - there will be only a category passed (since it is already in the model with a parent)
        if etree == None and parentCategory == None:
            self.__action = "modify"
            #print "Modifying an existing category"
            self.loadCategoryInfo()
            
        elif parentCategory == self.__etree.getroot():
            #New category - there will be a etree & parent item (or something special for a top level item? but no need to load anything, it is a new category)
            self.__action = "newCategory"
            #print "Creating a new top level category"
        else: #A parent is passed, so will be adding as a subelement of that parent to the existing etree
            #print "Creating a new subcategory"
            self.__action = "newSubCategory"
            
        self.__temp0 = self.genQSI()
    
    @pyqtSignature("")
    def on_buttonOk_released(self):
        """
        Slot documentation goes here.
        """
        if self.__action == "newSubCategory": #subCategory, append it to the tree
            #print "Making a new subCategory"
            self.__category = SubElement(self.__parentCategory, "category")
            
            parent_node = self.__qSIRow[0]
            self.__qSIRow = [self.__temp0]
            #print self.__qSIRow
            parent_node.appendRow(self.__qSIRow)
            
            #set the current QSI category to the first category in that row
            self.__qSICategory = self.__temp0
            
            #id(self) should return the python id of an object which is unique, and time.time() is added to further guarantee uniqueness
            #code from original sourse:  self.__id = kwargs.pop('id', None) or '%s:%s'%(id(self), time.time())
            
            #Generate the category id, this  is a new category
            self.__category.set("id", str(id(self)) + ":" + str(time.time()))
            
            self.readFormInfo()
            #print self.__category.attrib["id"]
            
            self.updateCategoryModelLabels()
            
            #was re-reading the entire tree each time an item was added, but that is inefficient
            #self.__parent.update()
            index = self.__qSICategory.index()
            self.__parent.categoryTreeView.selectionModel().setCurrentIndex(index, QItemSelectionModel.NoUpdate)
            #self.__parent.modelFilter.refreshFilter()
            
            #append the list to category model
            #self.__categoryModel.appendRow()
        elif self.__action == "newCategory": #new root category
            #print "Making a new category"
            self.__category = SubElement(self.__etree.getroot(), "category")
            
            #The parent is the qStandardItem categoryModel in this case, cause it is a new item
            parent_node = self.__categoryModel
            
            #Generate a blank row
            self.__qSIRow = [self.__temp0]
            #append the qStandardItemModel row
            parent_node.appendRow(self.__qSIRow)
            #set the current QSI category to the first category in that row
            self.__qSICategory = self.__temp0
            
            #Generate the category id, this  is a new category
            self.__category.set("id", str(id(self)) + ":" + str(time.time()))
            
            self.readFormInfo()
            
            #Append the category to the 
            #self.__categoryModel.appendRow(self.__category)
            
            self.updateCategoryModelLabels()
            #if it is the first category, need to update categoryview so column headers get set correctly
#            if self.__categoryModel.rowCount() == 1:
#                self.__parent.updateCategoryView()
            
            #was re-reading the entire tree each time an item was added, but that is inefficient
            #self.__parent.update()
            index = self.__qSICategory.index()
            self.__parent.categoryTreeView.selectionModel().setCurrentIndex(index, QItemSelectionModel.NoUpdate)
        else:  #action is modify
            #Just read the form info and modify the existing task item
            self.readFormInfo()
            self.updateCategoryModelLabels()
#            self.__parent.modelFilter.refreshFilter()
        self.__parent.parent.autoSave()
        self.__categoryModel.setHeaderData(0, Qt.Horizontal, QVariant("Category"))
        self.close()

    def genQSI(self):
        temp = QStandardItem()
        temp.setData(self.__category)
        temp.setText("category")
        return temp
    
    def readFormInfo(self):
        #Set the task subject to the subject from the form, cast as str or elementtree won't know how to deal with it
        #TODO: testing to see if need to save values (don't create empty values)
        self.__category.set("subject", str(self.inputSubject.text()))
        #self.__category.set("description", str(self.inputDescription.toPlainText()))

        #description
        #print self.inputDescription.toPlainText()
        if self.inputDescription.toPlainText() == "":
            pass
            #print "there is no description"
            #for children in self.__category.getchildren():
               # if children.tag == "description":
                  #  self.__category.remove(children)
        else:
            descriptionSet = False
            #print self.inputDescription.toPlainText()
            for children in self.__category.getchildren():
                if children.tag == "description":
                    descriptionSet = True
                    children.text = str(self.inputDescription.toPlainText())
                    break
            if not descriptionSet == True:
                description = SubElement(self.__category,"description")
                description.text = str(self.inputDescription.toPlainText())

    def updateCategoryModelLabels(self):
        global maemo5
        completed = False
        overdue = False
        dueToday = False
        #print subelement.attrib
#        self.__parent.model.setUpdatingModel(True)
        
        try:
            self.__category.attrib["subject"]
        except KeyError:
            #Just a closing tag, not a valid task
            pass
        else:
#            try:
#                self.__category.attrib["completiondate"]
#            except KeyError:
            check = Qt.Unchecked
#                completed = False
#            else:
                #print self.__category.attrib["completiondate"]
#                check = Qt.Checked
#                completed = True
            self.__qSICategory.setData(QVariant(check), Qt.CheckStateRole)
            
            #root_subject = QStandardItem()
            root_subject = self.__qSIRow[0]
            root_subject.setData(self.__category)
            root_subject.setText(self.__category.attrib["subject"])
            
            #ItemIsSelectable was needed on the first row, or did not highlight the whole row when it was selected
            root_subject.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled | Qt.ItemIsSelectable) 
        
            
            self.__qSIRow[0].setText(root_subject.text())
            
            #TODO: self.__parent.sortModel()

    def loadCategoryInfo(self):
        #print "the task is: " + self.__category.attrib["subject"]
        try:
            self.__category.attrib["id"]
        except KeyError:
            self.__category.attrib = []
        else:
            try:
                self.__category.attrib["subject"]
            except KeyError:
                pass
            else:
                self.inputSubject.setText(self.__category.attrib["subject"])
                
            for children in self.__category.getchildren():
                if children.tag == "description":
                    #Get rid of beginning and ending new lines or the text in the box has them
                    children.text = children.text.rstrip()
                    children.text = children.text.lstrip()
                    self.inputDescription.setPlainText(children.text)
