# -*- coding: utf-8 -*-
'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
"""
Module implementing MainWindow.
"""
from PyQt4 import QtGui
from PyQt4.QtGui import QMainWindow
from PyQt4 import QtCore
from PyQt4.QtCore import pyqtSignature, QSize
from PyQt4.QtGui import *

from PyQt4.QtCore import *

from Ui_categoryProperties import Ui_CategoryProperties
from categoryProperties import CategoryProperties
from Ui_categories import Ui_CategoryWindow
from model.categorySelection import *

global EXPANDALL
EXPANDALL = False

class RowHeightDelegate(QItemDelegate):
    def __init__(self):
        QItemDelegate.__init__(self)

    def sizeHint(self, option, index):  
        return QSize(40,40)
        
class CategoryWindow(QMainWindow, Ui_CategoryWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None, etree = None,  categoryModel = None, maemo5 = None, viewSelectedCategories = None, viewSelectedCategoryItemIds = None, settings = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        
        #hide the header in the treeview
        self.categoryTreeView.header().hide()
        
        QApplication.desktop().resized.connect(self.on_desktop_resized)
        global EXPANDALL
        
        self.maemo5 = maemo5
        self.settings = settings
        self.qSIRow = []
        self.toolBar = QtGui.QToolBar(self)
        self.toolBar.setAllowedAreas(QtCore.Qt.BottomToolBarArea)
        self.toolBar.setFloatable(False)
        self.toolBar.setObjectName("toolBar")
        self.addToolBar(QtCore.Qt.BottomToolBarArea, self.toolBar)
        self.loadToolBar()
        
        self.__etree = etree
        self.parent = parent
        self.__viewSelectedCategories = viewSelectedCategories
        self.__viewSelectedCategoryItemIds = viewSelectedCategoryItemIds
        
        if categoryModel == None:
            print "Category Model is empty, there are no categories"
        else:
            self.categoryModel = categoryModel
            
            #this is temporary until I decide if I want to fill the model here or in tskxml
            self.categoryModel.clear()
            
            #if viewSelectedCategories != None:
            self.loadCategoryModel()
        
        self.categoryModel.itemChanged.connect(self.on_itemChanged)
        
        if self.__viewSelectedCategories != None:
            pass
        
        #proxyCat = QSortFilterProxyModel()
        #proxyCat.setSourceModel(self.categoryModel)
        if self.maemo5:
            delegate = RowHeightDelegate()
            self.categoryTreeView.setItemDelegate(delegate) 
        
        #Enable multiple selection mode
        #self.categoryTreeView.setSelectionMode(QtGui.QAbstractItemView.ExtendedSelection)

        #self.categoryTreeView.setModel(proxyCat)
        self.categoryTreeView.setModel(self.categoryModel)
        self.categoryTreeView.setColumnWidth(0,250)
        self.categoryTreeView.sortByColumn(0,QtCore.Qt.AscendingOrder)
        #hide the id column
        self.categoryTreeView.hideColumn(1)
        if EXPANDALL:
            self.categoryTreeView.expandAll()
        self.selection = CategoryModelSelectionTracker(self)
        connection = QObject.connect(self.categoryTreeView.selectionModel(), SIGNAL("selectionChanged(QItemSelection, QItemSelection)"), self.selection.slot)
    
    def loadToolBar(self):
        global AUTOSAVE
        #self.toolBar.setOrientation(Qt.Orientation(1))
        
        #Category buttons only on this toolbar
        #New Category
        if self.maemo5:
          self.newCategory = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/filenew.png'), 'New Category', self)
        else:
          self.newCategory = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/filenew.png'), 'New Category', self)
        self.newCategory.setShortcut('Ctrl+T')
        self.connect(self.newCategory, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnNew_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.newCategory)
        
        #New subCategory
        if self.maemo5:
          self.newSubCategory = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/custom_newsub.png'), 'New SubCategory', self)
        else:
          self.newSubCategory = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/custom_newsub.png'), 'New SubCategory', self)
        self.newSubCategory.setShortcut('Ctrl+Shift+T')
        self.connect(self.newSubCategory, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnSubCategory_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.newSubCategory)
        
        #Edit Category
        #self.editCategory = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/edit.png'), 'Edit Category', self)
        if self.maemo5:
          self.editCategory = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/edit.png'), 'Edit Category', self)
        else:
          self.editCategory = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/edit.png'), 'Edit Category', self)
        self.editCategory.setShortcut('Ctrl+E')
        self.connect(self.editCategory, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnEdit_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.editCategory)
        
        #Delete Category
        if self.maemo5:
          self.delCategory = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/editdelete.png'), 'Delete Category', self)
        else:
          self.delCategory = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/editdelete.png'), 'Delete Category', self)
        self.delCategory.setShortcut('Ctrl+D')
        self.connect(self.delCategory, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnDelete_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.delCategory)
        
        #self.addToolBarBreak()
        
        #Spacer to move the app wide buttons all the way to the right
        spacer = QWidget()
        spacer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        self.toolBar.addWidget(spacer) 
        
        #Expand All
        if self.maemo5:
          self.expandAll = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/edit_add.png'), 'Expand All', self)
        else:
          self.expandAll = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/edit_add.png'), 'Expand All', self)
        #self.expandAll.setShortcut('Ctrl+D')
        self.connect(self.expandAll, QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnExpandAll_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.expandAll)
        
        #Collapse All
        if self.maemo5:
          self.collapseAll = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/edit_remove.png'), 'Collapse All', self)
        else:
          self.collapseAll = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/edit_remove.png'), 'Collapse All', self)
        #self.categories.setShortcut('Ctrl+D')
        self.connect(self.collapseAll , QtCore.SIGNAL('triggered()'), QtCore.SLOT('on_btnCollapseAll_released()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.collapseAll )
        
        #Spacer to move the app wide buttons all the way to the right
        spacer = QWidget()
        spacer.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)
        self.toolBar.addWidget(spacer) 
        
        #Exit button
        if self.maemo5:
          self.exit = QtGui.QAction(QtGui.QIcon('/opt/usr/share/icons/hicolor/48x48/actions/exit.png'), 'Exit', self)
        else:
          self.exit = QtGui.QAction(QtGui.QIcon('icons/nuvola/48x48/actions/exit.png'), 'Exit', self)
        self.exit.setShortcut('Ctrl+Q')
        #self.connect(self.exit, QtCore.SIGNAL('triggered()'), QtCore.SLOT('close()'))
        self.connect(self.exit, QtCore.SIGNAL('triggered()'), QtCore.SLOT('closeParent()'))
        #self.exit.setEnabled(False)
        self.toolBar.addAction(self.exit)

    @pyqtSignature("")
    def closeParent(self):
        """
        Slot documentation goes here.
        """
        self.parent.close()
    
    @pyqtSignature("")
    def on_btnNew_released(self):
        """
        Slot documentation goes here.
        """
        # Create a new category to edit & pass to the categoryProperties window
        #Be sure there is actually a file created to add tasks to or this will throw an error
        try:
            self.__etree.getroot()
        except AttributeError:
            #print "No file open"
            reply = QtGui.QMessageBox.question(self, 'Message',
                                               "No task file currently open, create a new file?", QtGui.QMessageBox.Yes | 
                                               QtGui.QMessageBox.No |QtGui.QMessageBox.Cancel, QtGui.QMessageBox.Yes)

            if reply == QtGui.QMessageBox.Yes:
                self.newFile()
                self.addNewCategory()
            if reply == QtGui.QMessageBox.No:
                pass
            #Otherwise cancel opening file
        else:
            self.addNewCategory()

    def addNewCategory(self):
        win = CategoryProperties(self, None, None, self.__etree.getroot(), self.__etree, None, self.categoryModel)
        #win = CategoryProperties(self)
        if self.maemo5:
            win.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            win.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
            #win.setAttribute(QtCore.Qt.WA_Maemo5PortraitOrientation, True)
            #except:print("Cannot set orientation to portrait")
        win.show()

    @pyqtSignature("")
    def on_btnSubCategory_released(self):
        """
        Slot documentation goes here.
        """
        #Ensure selection variable is defined and a valid element
        if (type(self.selection.currentSelection()) == bool):
            #Show a message no item selected, cannot delete
            QtGui.QMessageBox.information(self, "Alert", "No category currently selected. Please select a parent category before trying to create a subcategory.", QtGui.QMessageBox.Ok)
        else:
            try:
                self.selection.currentSelection().attrib["id"]
            except AttributeError:
                #Show a message no item selected, cannot delete
                QtGui.QMessageBox.information(self, "Alert", "No category currently selected. Please select a parent category before trying to create a subcategory.", QtGui.QMessageBox.Ok)
            else:
                try:
                    self.selection.currentSelection()
                except NameError:
                    pass
                else:
                #if self.model.selection.currentSelection():
                    #print self.qSIRow
                    win = CategoryProperties(self, None, None, self.selection.currentSelection(), self.__etree, self.qSIRow, self.categoryModel)
                    #win = CategoryProperties(self, None, None, self.model.selection.currentSelection(), self.model.etree, self.model.taskModel, self.model.qSIRow, self.model.categoryModel, self.settings)
                    if self.maemo5:
                        win.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
                        win.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
                    win.show()
                    
                    
    @pyqtSignature("")
    def on_btnCheckAll_released(self):
        """
        Slot documentation goes here.
        """
        
        #check all items in cat model
        if self.categoryModel.item(0, 0):
            self.parentOperations(Qt.Checked)
    
    @pyqtSignature("")
    def on_btnUncheckAll_released(self):
        """
        Slot documentation goes here.
        """
        if self.categoryModel.item(0, 0):
            self.parentOperations(Qt.Unchecked)
            

    @pyqtSignature("")
    def on_btnCollapseAll_released(self):
        """
        Slot documentation goes here.
        """
        self.categoryTreeView.collapseAll()
        self.scrollToSelection()
        
    @pyqtSignature("")
    def on_btnExpandAll_released(self):
        """
        Slot documentation goes here.
        """
        self.categoryTreeView.expandAll()
        self.scrollToSelection()
        
    @pyqtSignature("")
    def on_btnDelete_released(self):
        """
        Slot documentation goes here.
        """
        if (type(self.selection.currentSelection()) == bool):
            #Show a message no item selected, cannot delete
            QtGui.QMessageBox.information(self, "Alert", "No category currently selected. Please make a selection before trying to delete.", QtGui.QMessageBox.Ok)
        else:
            try:
                self.selection.currentSelection().attrib["id"]
            except AttributeError:
                #Show a message no item selected, cannot delete
                QtGui.QMessageBox.information(self, "Alert", "No category currently selected. Please make a selection before trying to delete.", QtGui.QMessageBox.Ok)
            else:
            #if self.model.selection.currentSelection():
                if self.settings.getboolean("file", "promptOnDeletion"):
                    reply = QtGui.QMessageBox.question(self, 'Message',
                                               "Delete Category?", QtGui.QMessageBox.Yes | 
                                               QtGui.QMessageBox.No, QtGui.QMessageBox.Yes)

                    if reply == QtGui.QMessageBox.Yes:
                        delCategory = True
                    else:
                        delCategory = False
                else:
                    delCategory = True
                    
                if delCategory:
                    idToRemove = self.selection.currentSelection().attrib["id"]
                    #print selection.attrib["subject"]
                    
                    if self.selection.qItemSelection().parent() == None:
                        #print "Delete a top level item"
                        #get root of tree and delete item
                        parentItem = self.__etree.getroot()
                        parentItem.remove(self.selection.currentSelection())
                        #remove from qtstandarditemmodel too
                        self.categoryModel.removeRow(self.selection.qItemSelection().row())
                    else:
                        #print "Delete a child item"
                        #delete item
                        
                        parentItem = self.selection.qItemSelection().parent().data().toPyObject()
                        parentItem.remove(self.selection.currentSelection())
                        
                        self.categoryModel.removeRow(self.selection.qItemSelection().row(), self.categoryModel.indexFromItem(self.selection.qItemSelection().parent()))
                    
                    self.parent.autoSave()
        
    @pyqtSignature("")
    def on_btnEdit_released(self):
        """
        Slot documentation goes here.
        """
        self.editCurrentCategory()
        
    def editCurrentCategory(self):
        # Ensure selection variable is defined and not a bool (meaning not a real element)
        if (type(self.selection.currentSelection()) == bool):
            #Show a message no item selected, cannot delete
            QtGui.QMessageBox.information(self, "Alert", "No category currently selected. Please make a selection to edit.", QtGui.QMessageBox.Ok)
        else:
            try:
                self.selection.currentSelection().attrib["id"]
            except AttributeError:
                #Show a message no item selected, cannot delete
                QtGui.QMessageBox.information(self, "Alert", "No category currently selected. Please make a selection to edit.", QtGui.QMessageBox.Ok)
            else:
                try:
                    self.selection.currentSelection()
                except NameError:
                    pass
                else:
                    win = CategoryProperties(self, self.selection.currentSelection(), self.selection.qItemSelection(), None,  None, self.qSIRow, self.categoryModel)
                    #if self.model.selection.currentSelection:
                    
                    win = CategoryProperties(self, self.selection.currentSelection(), self.selection.qItemSelection(), None,  None, self.qSIRow, self.categoryModel)
                    if self.maemo5:
                        win.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)
                        win.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
                        
                    win.show()

    def checkItem(self, item):
        pass
        
    
    @pyqtSlot(QStandardItem)
    def on_itemChanged(self,  item):
        state = ['UNCHECKED', 'TRISTATE',  'CHECKED'][item.checkState()]
        task = item.data().toPyObject()
        if state == "CHECKED":
            #print "An item was checked"
            pass
            #change colors
        elif state == "UNCHECKED":
            #print "An item was unchecked"
            pass
            #delete start date if there was one, now we don't want it

    def parentOperations(self, operation):
        if operation == Qt.Checked:
            #print "Should be checked"
            pass
        elif operation == Qt.Unchecked:
            #print "Should be unchecked"
            pass
        elif operation == "load models":
            #clear both models (but do not set to a new list, want to keep same list for data sharing
            self.parent.modelFilter.clearViewSelections()
                
        for i in range (0, self.categoryModel.rowCount()):
            #print self.categoryModel.index(j, 0, self.categoryModel.indexFromItem(parent))
            itemIndex = self.categoryModel.index(i, 0)
            if operation == Qt.Checked or operation == Qt.Unchecked:
                self.categoryModel.itemFromIndex(itemIndex).setData(QVariant(operation), Qt.CheckStateRole)
            elif operation == "load models":
                #get ids from categories that are checked for self.__viewSelectedCategories
                state = ['UNCHECKED', 'TRISTATE',  'CHECKED'][self.categoryModel.itemFromIndex(itemIndex).checkState()]
                if state == 'CHECKED':
                    element = self.categoryModel.itemFromIndex(itemIndex).data().toPyObject()
                    self.parent.modelFilter.addViewCategory(element)
                
            if self.categoryModel.item(i, 0).hasChildren():
                self.childOperations(operation, self.categoryModel.item(i, 0))
        
        #if self.__viewSelectedCategories == []:
            #self.__viewSelectedCategories = ["NONE"]
            #if self.__viewSelectedCategoryItemIds == []:
                #self.parent.modelFilter.preventEmptyFilter()
        #print self.__viewSelectedCategories
        #print self.__viewSelectedCategoryItemIds
        
        
    def childOperations(self, operation, parent):
        for j in range (0, self.categoryModel.rowCount(self.categoryModel.indexFromItem(parent))):
            #print self.categoryModel.index(j, 0, self.categoryModel.indexFromItem(parent))
            itemIndex = self.categoryModel.index(j, 0, self.categoryModel.indexFromItem(parent))
            if operation == Qt.Checked or operation == Qt.Unchecked:
                self.categoryModel.itemFromIndex(itemIndex).setData(QVariant(operation), Qt.CheckStateRole)
            elif operation == "load models":
                #get ids from categories that are checked for self.__viewSelectedCategories
                state = ['UNCHECKED', 'TRISTATE',  'CHECKED'][self.categoryModel.itemFromIndex(itemIndex).checkState()]
                if state == 'CHECKED':
                    element = self.categoryModel.itemFromIndex(itemIndex).data().toPyObject()
                    self.parent.modelFilter.addViewCategory(element)
                    
            if self.categoryModel.itemFromIndex(itemIndex).hasChildren():
                self.childOperations(operation, self.categoryModel.itemFromIndex(itemIndex))
                
    def checkOrNot(self, categoryId):
        checkIt = False
        for id in self.__viewSelectedCategories:
            if categoryId == id:
                #print "the match is: " + categoryId
                #want to return checked or unchecked
                checkIt = True
                #need to exit loop
                
        if checkIt:
            return Qt.Checked
        else:
            return Qt.Unchecked
        
    def loadCategoryModel(self):
        '''
        construct qstandarditemlist from ElementTree
        '''        
        root_e = self.__etree.getroot()
        
        for parent in root_e:
            if parent.tag == "category" and parent.attrib["id"]:
                #print parent.attrib["subject"] + parent.attrib["id"]
                
                try:
                    parent.attrib["subject"]
                except KeyError:
                    #Just a closing tag, not a valid task
                    pass
                else:
                    task_root_subject = QStandardItem()
                    task_root_subject.setData(parent)
                    task_root_subject.setText(parent.attrib["subject"])
                    
                try:
                    parent.attrib["id"]
                except KeyError:
                    #Just a closing tag, not a valid task
                    pass
                else:
                    task_root_id = QStandardItem()
                    task_root_id.setData(parent)
                    task_root_id.setText(parent.attrib["id"])
                    
                    #Figure out when to check and uncheck these items
                    check = self.checkOrNot(parent.attrib["id"])
                    task_root_subject.setData(QVariant(check), Qt.CheckStateRole)
                    
                    #ItemIsSelectable was needed on the first row, or did not highlight the whole row when it was selected
                    task_root_subject.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled | Qt.ItemIsSelectable)
                
                self.categoryModel.appendRow([task_root_subject, task_root_id])
                
                #check to see if the parent id matches one from our list, if it does set it to checked, otherwise not checked
                for id in self.__viewSelectedCategories:
                    if parent.attrib["id"] == id:
                        #print "the match is: " + parent.attrib["id"]
                        pass
                        
                for children in parent.getchildren():
                    if children.tag == "category":
                        self.loadChildCategory(children, parent, task_root_subject)
        
        #self.categoryModel.setHeaderData(0, Qt.Horizontal, QVariant("To filter tasks by category check boxes & \"Apply Filter\""))
        self.categoryModel.setHeaderData(0, Qt.Horizontal, QVariant("Category"))
        #self.categoryModel.setHeaderData(1, Qt.Horizontal, QVariant("ID"))
    
    def loadChildCategory(self,  child, parent,  parent_node):
        try:
            child.attrib["subject"]
        except KeyError:
            #set to text instead of a qstandarditem and skip adding it cause its not a real task, just a closing tag
            node_subject = ""
            pass
        else:
            node_subject = QStandardItem()
            node_subject.setData(child)
            node_subject.setText(child.attrib["subject"])
                                
            node_id = QStandardItem()
            node_id.setData(child)
            try:
                child.attrib["id"]
            except KeyError:
                node_id.setText("")
            else:
                node_id.setText(child.attrib["id"])
                check = self.checkOrNot(child.attrib["id"])
                
                node_subject.setData(QVariant(check), Qt.CheckStateRole)
        
            #ItemIsSelectable was needed on the first row, or did not highlight the whole row when it was selected
            node_subject.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled | Qt.ItemIsSelectable)
                
            parent_node.appendRow([node_subject, node_id])
            
            # recurse over children
            for child_element in child.getchildren():
                self.loadChildCategory(child_element, child, node_subject)
        
        #check to see if the child id matches one from our list, if it does set it to checked, otherwise not checked
        for id in self.__viewSelectedCategories:
            if child.attrib["id"] == id:
                #print "the match is: " + child.attrib["id"]
                pass
                
        return node_subject
    
    @pyqtSignature("")
    def on_btnApplyFilter_released(self):
        """
        Slot documentation goes here.
        """
        #re.sub(pattern, repl, string[, count, flags])
        
        #filtering
        #taskIds = "1122523944:1316750205.88|1176369096:1317327419.7|1123226512:1317356543.57|1291769800:1317337073.24|77650192:1317420674.31|1129674912:1317334895.1|1138778952:1317321323.3"
        
        #self.parent.filterTasks(re.sub(' ', '|', taskIds))
        
        #self.proxy.setFilterRegExp(QRegExp(string, Qt.CaseInsensitive))
        #self.proxy.setFilterKeyColumn(4);
        
        #update selections
        self.parentOperations("load models")
        #print self.parent.categorizablesIds
        #print "Now the filter set:"
        #print re.sub(' ', '|', self.parent.categorizablesIds
        if self.__viewSelectedCategories == []:
            #print "Nothing checked"
            pass
        else:
            #print "Categories checked"
            if self.__viewSelectedCategoryItemIds == []:
                #print "But there are no tasks in these categories"
                self.parent.modelFilter.preventEmptyFilter()
            #else:
                #print "There are tasks"
            
                #self.parent.modelFilter.preventEmptyFilter()
        #print self.__viewSelectedCategories
        #print self.__viewSelectedCategoryItemIds
        self.parent.modelFilter.filterTasks()
        
        
        #force an update on the parent window so only selected tasks are visible once it is made aware of viewSelectedCategories and viewSelectedCategoryItemIds
        #self.parent.update()
        
        self.close()
        
    
    @pyqtSignature("")
    def on_desktop_resized(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        #print screenGeometry
        
        if (screenGeometry.height() > screenGeometry.width()):
            pass
            #print "Do portrait layout"
            #self.centralWidget.resize(480, 770)
        else:
            pass
            #print "Do landscape layout" 
            
            #self.centralWidget.resize(800, 430)

    def scrollToSelection(self):
        if self.categoryTreeView.selectedIndexes() != []:
            item = self.categoryTreeView.selectedIndexes()[0]
            self.categoryTreeView.scrollToTop()
            self.categoryTreeView.scrollTo(item, QAbstractItemView.PositionAtCenter)
