from pymixer import *
import time, ConfigParser


numsoundgroups=7

class SoundManager(AMPlayer):

    recording = False
    recorddata =[[],[],[],[],[],[],[],[],[],[],[],[]]
    nextplaypos=0
    loopslot=9
    queuedslot=0

    def savedata(self,filename):
        configfile = open(filename, "w")
        config = ConfigParser.RawConfigParser()

        for i in range(len(self.recorddata)):
            try:
                config.add_section('loop'+str(i))
            except ConfigParser.DuplicateSectionError:
                pass            

            elcount = len(self.recorddata[i])
            config.set('loop'+str(i),'elcount',elcount)
            for j in range(elcount):
                config.set('loop'+str(i),'el'+str(j)+'time',
self.recorddata[i][j][2])
                if self.recorddata[i][j][1]:
                    config.set('loop'+str(i),'el'+str(j)+'first',1)
                else:
                    config.set('loop'+str(i),'el'+str(j)+'first',0)

                config.set('loop'+str(i),'el'+str(j)+'instr',self.recorddata[i][j][0])
        config.write(configfile)


    def getdefint(self,config,sct,key,val):
        try: 
            return config.getint(sct, key)
        except:
            return val
    
    def loaddata(self,filename):
        configfile = open(filename, "r")
        self.recorddata =[[],[],[],[],[],[],[],[],[],[],[],[]]

        config = ConfigParser.RawConfigParser()
        config.readfp(configfile)
        for i in range(len(self.recorddata)):
            elcount=self.getdefint(config,'loop'+str(i),'elcount',0)
            for j in range(elcount):
                self.recorddata[i].append(
                    [
                     self.getdefint(config,'loop'+str(i),'el'+str(j)+'instr',0),
                     self.getdefint(config,'loop'+str(i),'el'+str(j)+'first',0)==1,
                     self.getdefint(config,'loop'+str(i),'el'+str(j)+'time',0)
                    ])
                        

    def startrecording(self,slot):
        print "recording started"
        self.recording = True
        self.loopslot = slot        
        self.firstsound = True
        self.recorddata[self.loopslot] = []
        self.mixer.tickcount =0

    def stoprecording(self):
        print "recording done, events:" +str(len(self.recorddata))
        #put end event and we can loop
        self.recorddata[self.loopslot].append([-1,False,self.mixer.tickcount])
        self.recording = False

    def playrecording(self,slot):
        print "SM playback"
        self.recording = False
        self.loopslot = slot
        self.mixer.tickcount =0
        self.nextplaypos=0
        self.queuedslot = slot

    def queuerecording(self,slot):
        print 'queueing loop'
        self.queuedslot = slot

    def playtick(self, mixer, tickcount):
        if not self.recording:
            while (self.nextplaypos < len(self.recorddata[self.loopslot])) and (self.recorddata[self.loopslot][self.nextplaypos][2] <= tickcount):
                i = self.nextplaypos

                if self.recorddata[self.loopslot][i][0] == -1:
                    self.nextplaypos =0
                    self.loopslot= self.queuedslot                 
                    tickcount =0
                    self.mixer.tickcount =0                    

                else:
                    self.playsound(self.recorddata[self.loopslot][i][0],self.recorddata[self.loopslot][i][1])
                    self.nextplaypos = self.nextplaypos +1

    def __init__(self,snddir):
        self.mixer=AudioMixer()
        for i in range(1, 5):
            self.mixer.addwav(snddir + "/KickDrums1/kickdrum" +str(i ) + ".wav")
            self.mixer.addwav(snddir +"/HiHats1/hihat" +str(i) + ".wav")
            self.mixer.addwav(snddir +"/SnareDrums1/snaredrum" +str(i) + ".wav")
            self.mixer.addwav(snddir +"/Cymbals1/cymbal" +str(i) + ".wav")
            self.mixer.addwav(snddir +"/TomTomDrums/tomtomdrum" +str(i) + ".wav")
            self.mixer.addwav(snddir +"/TomTomDrums/tomtomdrum" +str(4+i) + ".wav")
            self.mixer.addwav(snddir +"/BassDrums1/bassdrum" +str(i) + ".wav")
    
    def init_audio(self):
        self.mixer.players = [self]        
        self.mixer.init_audio()
    
    def playsound (self, num, first=False):
        if self.recording:
            if self.firstsound:
                #threadsafety to be improved
                self.mixer.tickcount = 0
                self.firstsound = False
            self.recorddata[self.loopslot].append([num,first,self.mixer.tickcount])  
        if first:
            self.mixer.playsound(num)             
        else:
            self.mixer.playsound(num + (numsoundgroups*random.randrange(0,4)))             
    

    def pause(self):
        self.mixer.pause()

    def play(self):
        self.mixer.play()

    def endgracefully(self):
        self.mixer.endgracefully()

    def process(self):
        pass        