# License: This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at your
# option) any later version. This program is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.

# credits 
# code: Tony Day

# Unit to support accelerometer based drumming

#import dbus
import pydrumbase

def getrotation():
    f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", "r")
    coords = [int(w) for w in f.readline().split()]
    f.close()
    return coords

class AccelAudioEvent(pydrumbase.AudioEvent):

    cords1 = (0,0,0)
    cords2 = (0,0,0)
    lastplayed=[0,0,0,0,0,0]
    run=0

    def process(self):
        retsnds = []
        self.cords3 = getrotation()
        for axis in range(0, 3):
            if abs(self.cords3[axis] - self.cords2[axis]) > 100:
                if (self.lastplayed[axis] < self.run -10):
                    self.lastplayed[axis] = self.run
                    if self.cords3[axis] > self.cords2[axis]:
                        retsnds.append(axis+3)
                    else:
                        retsnds.append(axis)           

        self.cords1=self.cords2            
        self.cords2=self.cords3 
        self.run=self.run+1   
        return retsnds

    def reset(self):
        self.cords1 = (0,0,0)
        self.cords2 = (0,0,0)
        self.lastplayed=[0,0,0,0,0,0]
        self.run=0
