#!/usr/bin/env pythonstart
#-*- coding: utf-8 -*-

from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import QCoreApplication, Qt
from PyQt4.QtGui import QApplication
from PyQt4.QtCore import pyqtSignature, QEvent, SIGNAL, QRect, Qt
from PyQt4.QtGui import QMainWindow, QGraphicsScene, QTransform, QMessageBox, QGraphicsView, QPixmap, QImage, QGraphicsPixmapItem, QPushButton, QRadioButton
import sys
import time

import threading

import gobject
gobject.threads_init()

from pydrumsoundmanager import *
from pydrumaccel import *

appdir = sys.argv[0]
appdir = os.path.dirname(appdir)
appdir =os.path.abspath(appdir)

keymap = []
for i in range(256):
    keymap.append([])

keymap[Qt.Key_Q] = [0]
keymap[Qt.Key_W] = [1]
keymap[Qt.Key_E] = [2]
keymap[Qt.Key_R] = [3]
keymap[Qt.Key_T] = [4]
keymap[Qt.Key_Y] = [5]
keymap[Qt.Key_U] = [6]

keymap[Qt.Key_A] = [0]
keymap[Qt.Key_S] = [0,1]
keymap[Qt.Key_D] = [0,2]
keymap[Qt.Key_F] = [0,3]
keymap[Qt.Key_G] = [0,4]
keymap[Qt.Key_H] = [0,5]
keymap[Qt.Key_J] = [0,6]

keymap[Qt.Key_Z] = [0,1]
keymap[Qt.Key_X] = [1]
keymap[Qt.Key_C] = [1,2]
keymap[Qt.Key_V] = [1,3]
keymap[Qt.Key_B] = [1,4]
keymap[Qt.Key_N] = [1,5]
keymap[Qt.Key_M] = [1,6]

Drumname = ['kick','hat','snare','cym','tom1','tom2','bass']
keychar=['Q','W','E','R','T','Y','U']
Shortname = ['k','ht','snr','cym','tm1','tm2','bs']
showdrumkit = False


class AccelThread(threading.Thread):

    def __init__(self, soundmanager):
        self.soundmanager = soundmanager
        self.terminated = False
        self.aae = AccelAudioEvent()
        threading.Thread.__init__(self)

    def terminate(self):
        self.terminated = True

    def run ( self ):
        print "running from thread"
        self.aae.reset()
        self.terminated = False
        while not self.terminated:
            playarray = self.aae.process()
            for j in range(len(playarray)):
                self.soundmanager.playsound(playarray[j])

class MainWindow(QMainWindow):

    playaccel=False

    def clickdrumpad(self):
        sender = self.sender()
        self.soundmanager.playsound(sender.psn[1])
        if (sender.psn[0]>0) and (sender.psn[0]-1!=sender.psn[1]):
            self.soundmanager.playsound(sender.psn[0]-1)

    def toggleaccel(self):
        sender = self.sender()
        self.playaccel= not self.playaccel
        
        if self.playaccel:
            self.accelthread = AccelThread(self.soundmanager)
            self.accelthread.start()
        else:
            self.accelthread.terminate()

    def keyPressEvent(self, event):
        ek = event.key()
        if ek < 256:
            for i in range(len(keymap[ek])):
                self.soundmanager.playsound(keymap[ek][i])
            self.soundmanager.playsound(0)
        super(MainWindow, self).keyPressEvent(event)

    storedcheckbtn=0
    def managecheckedbtn(self,btn):
        if self.storedcheckbtn != 0:
            print "unchecking btn"
            self.storedcheckbtn.setChecked(False)
        self.storedcheckbtn=btn
#        btn.setChecked(True)

    def addloopat(self, num,x,y):
        pad = QPushButton('Loop: ' +str(num+1),self)
        pad.setGeometry(x,y,100,65)
        pad.setCheckable(True)
        pad.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,64);background-color: rgb(127, 127, 64);alternate-background-color: rgb(127, 127, 255);border-radius:10;padding:2;margin:2;color: rgb(0,0,0)}QPushButton:pressed{background-color: rgb(192, 192, 128);}QPushButton:checked{background-color: rgb(192, 192, 128);};")
        pad.slot = num
        self.connect(pad, SIGNAL('pressed()'), self.loopplay)

        pad = QPushButton('REC',self)
        pad.setGeometry(x + 100, y, 55,65)
        pad.setCheckable(True)
        pad.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,64);background-color: rgb(127, 127, 64);alternate-background-color: rgb(127, 127, 255);border-radius:10;padding:2;margin:2;color: rgb(0,0,0)}QPushButton:pressed{background-color: rgb(192, 192, 128);}QPushButton:checked{background-color: rgb(192, 192, 128);};")
        pad.slot = num
        self.connect(pad, SIGNAL('pressed()'), self.looprec)

        pad = QPushButton('Queue',self)
        pad.setGeometry(x + 155, y, 80,65)
        pad.setCheckable(True)
        pad.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,64);background-color: rgb(127, 127, 64);alternate-background-color: rgb(127, 127, 255);border-radius:10;padding:2;margin:2;color: rgb(0,0,0)}QPushButton:pressed{background-color: rgb(192, 192, 128);}QPushButton:checked{background-color: rgb(192, 192, 128);};")
        pad.slot = num
        self.connect(pad, SIGNAL('pressed()'), self.loopqueue)
            
    def __init__(self, parent = None):        
        QMainWindow.__init__(self, parent)
        
        self.setStyleSheet("background-color: rgb(0, 0, 0);") 

        if showdrumkit:
            pixmap = QtGui.QPixmap(appdir +"/dsnn2.jpg")
            lbl = QtGui.QLabel(self)
            lbl.setPixmap(pixmap)
            lbl.setGeometry(12,480 - pixmap.height()-12,pixmap.width(),pixmap.height())
    
        self.soundmanager = SoundManager(appdir+'/sounds')
        self.soundmanager.loaddata(appdir+'/default.tiam')


        self.soundmanager.init_audio()

        self.loopbtn = QPushButton('HELP',self)
        self.loopbtn.setGeometry(0,0,100,55)
        self.loopbtn.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2;color: rgb(255,255,255)}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  

        self.loopbtn = QPushButton('Open',self)
        self.loopbtn.setGeometry(100,0,100,55)
        self.loopbtn.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2;color: rgb(255,255,255)}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  
        self.connect(self.loopbtn, SIGNAL('clicked()'), self.fileopen)

        self.loopbtn = QPushButton('Save',self)
        self.loopbtn.setGeometry(200,0,100,55)
        self.loopbtn.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2;color: rgb(255,255,255)}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  
        self.connect(self.loopbtn, SIGNAL('clicked()'), self.filesave)


        accelbtn = QPushButton('Shake',self)
        accelbtn.setGeometry(300,0,115,55)
        accelbtn.flat=True
        accelbtn.setCheckable(True)
        accelbtn.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2;color: rgb(127,127,127)}QPushButton:pressed{background-color: rgb(128, 128, 192);color: rgb(255,255,255)}QPushButton:checked{color: rgb(255,255,255)}")  
        self.connect(accelbtn, SIGNAL('clicked()'), self.toggleaccel)

        quit = QPushButton('Close',self)
        self.connect(quit, SIGNAL('clicked()'), QtGui.qApp, QtCore.SLOT('quit()'))
        quit.setGeometry(415,0,100,55)
        quit.flat=True
        quit.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  

        for i in range(5):
            self.addloopat(i, 10, 65+(65*i))
                          
        for i in range(4):
            self.addloopat(i+5, 265,65+(65*i))        

        nlbtn = QPushButton('No Loop',self)
        nlbtn.slot = 9
        self.connect(nlbtn, SIGNAL('pressed()'), self.loopplay)
        nlbtn.setGeometry(265,65+(65*4),235,65)
        nlbtn.setCheckable(True)        
        nlbtn.flat=True
        nlbtn.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,64);background-color: rgb(127, 64, 127);alternate-background-color: rgb(127, 127, 255);border-radius:10;padding:2;margin:2;color: rgb(0,0,0)}QPushButton:pressed{background-color: rgb(192, 128, 192);}QPushButton:checked{background-color: rgb(192, 128, 192);};")
        self.managecheckedbtn(nlbtn)
        nlbtn.setChecked(True)        
 
        for i in range(numsoundgroups):
            pad = QPushButton(keychar[i] + '\n' + Drumname[i],self)
            pad.setGeometry(73*i,404,73,70)
            pad.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(255,255,255);background-color: rgb(0, 0, 0);alternate-background-color: rgb(255, 255, 255);border-radius:10;padding:2;margin:2;color: rgb(127,127,127)}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  
            pad.psn=(0,i)                
            self.connect(pad, SIGNAL('pressed()'), self.clickdrumpad)

        for i in range(3):
            for j in range(numsoundgroups):
                if i == 0:
                    pad = QPushButton(Drumname[j],self)
                elif j == 0:
                     pad = QPushButton('+'+Drumname[i-1],self)
                else:
                     pad = QPushButton('',self)

                pad.setGeometry(530+(90*i),0+(68*j),90,68)
                pad.psn=(i,j)                
                self.connect(pad, SIGNAL('pressed()'), self.clickdrumpad)
                pad.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,64);background-color: rgb(64, 64, 127);alternate-background-color: rgb(127, 127, 255);border-radius:10;padding:2;margin:2;color: rgb(127,127,127)}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  

    @pyqtSignature("")
    def on_closeButton_pressed(self):
        self.soundmanager.endgracefully()
        sys.exit()

    def fileopen(self):
        print "loading data"
        self.soundmanager.loaddata(appdir+'/savedloops.tiam')

    def filesave(self):
        print "saving data"        
        self.soundmanager.savedata(appdir+'/savedloops.tiam')

    def loopplay(self):
        sender =self.sender()
        self.managecheckedbtn(sender)
        if self.soundmanager.recording:
            self.soundmanager.stoprecording()      
        self.soundmanager.playrecording(sender.slot)            

    def looprec(self):
        sender =self.sender()
        self.managecheckedbtn(sender)
        if self.soundmanager.recording:
            self.soundmanager.stoprecording()      
        self.soundmanager.startrecording(sender.slot)

    def loopqueue(self):        
        sender =self.sender()
        self.managecheckedbtn(sender)
        self.soundmanager.queuerecording(sender.slot)

    def on_menu_pressed(self):
        if not self.soundmanager.recording:
            self.soundmanager.startrecording(0)
            self.loopbtn.setText("Play")
            print "recording"
        else:
            self.soundmanager.stoprecording()      
            self.soundmanager.playrecording(0)            
            self.loopbtn.setText("Rec")       
            print "playback"

if __name__ == "__main__":
    #gobject.threads_init()
    app = QApplication(sys.argv)
    palette = QtGui.QPalette()
    app.setPalette(palette)
    QCoreApplication.flush()
    ui = MainWindow()
    ui.setAttribute(Qt.WA_Maemo5StackedWindow)
    ui.showFullScreen()
    sys.exit(app.exec_())
