# License: This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at your
# option) any later version. This program is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.

# credits 
# code: Tony Day

import pydrumbase
from pygame import *

class PGScreenPressAudioEvent(pydrumbase.AudioEvent):
    
    internalqueue =[]

    def getpossounds(self, event):
        retval=False
        if (event.pos[0] >= 550) and (event.pos[1] >= 5):
            self.internalqueue.append(int((event.pos[1]-5)/70))
            retval=True
        if (event.pos[0] >= 710):
            self.internalqueue.append(1)
            retval=True    
        elif (event.pos[0] >= 630):
            self.internalqueue.append(0)    
            retval=True
        return retval
    
    internalqueue =[]
    def handleevent(self, event):
        if event.type == MOUSEBUTTONDOWN:
            return self.getpossounds(event) 
        return False

    def process(self):
        retsnds = self.internalqueue
        self.internalqueue =[]
        return retsnds
