#!/usr/bin/env python
#-*- coding: utf-8 -*-

from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import QCoreApplication, Qt
from PyQt4.QtGui import QApplication
from PyQt4.QtCore import pyqtSignature, QEvent, SIGNAL, QRect, Qt
from PyQt4.QtGui import QMainWindow, QGraphicsScene, QTransform, QMessageBox, QGraphicsView, QPixmap, QImage, QGraphicsPixmapItem, QPushButton
import sys
import time

import threading

import gobject
gobject.threads_init()

from pydrumsoundmanager import *
from pydrumaccel import *

appdir = sys.argv[0]
appdir = os.path.dirname(appdir)
appdir =os.path.abspath(appdir)

keymap = []
for i in range(256):
    keymap.append([0])

keymap[Qt.Key_Q] = [0]
keymap[Qt.Key_W] = [1]
keymap[Qt.Key_E] = [2]
keymap[Qt.Key_R] = [3]
keymap[Qt.Key_T] = [4]
keymap[Qt.Key_Y] = [5]
keymap[Qt.Key_U] = [6]

keymap[Qt.Key_A] = [0]
keymap[Qt.Key_S] = [0,1]
keymap[Qt.Key_D] = [0,2]
keymap[Qt.Key_F] = [0,3]
keymap[Qt.Key_G] = [0,4]
keymap[Qt.Key_H] = [0,5]
keymap[Qt.Key_J] = [0,6]

keymap[Qt.Key_Z] = [0,1]
keymap[Qt.Key_X] = [1]
keymap[Qt.Key_C] = [1,2]
keymap[Qt.Key_V] = [1,3]
keymap[Qt.Key_B] = [1,4]
keymap[Qt.Key_N] = [1,5]
keymap[Qt.Key_M] = [1,6]


class AccelThread(threading.Thread):

    def __init__(self, soundmanager):
        self.soundmanager = soundmanager
        self.terminated = False
        self.aae = AccelAudioEvent()
        threading.Thread.__init__(self)

    def terminate(self):
        self.terminated = True

    def run ( self ):
        print "running from thread"
        self.aae.reset()
        self.terminated = False
        while not self.terminated:
            #should check how to yield but think largely irrelevant with how the
#            time.sleep(5)            
            playarray = self.aae.process()
            for j in range(len(playarray)):
                self.soundmanager.playsound(playarray[j])

class MainWindow(QMainWindow):

    playaccel=False

    def clickdrumpad(self):
        sender = self.sender()
        self.soundmanager.playsound(sender.psn[1])
        if (sender.psn[0]>0) and (sender.psn[0]-1!=sender.psn[1]):
            self.soundmanager.playsound(sender.psn[0]-1)

    def toggleaccel(self):
        sender = self.sender()
        self.playaccel= not self.playaccel
        sender.setChecked(self.playaccel)
#        if sender.getChecked()!=self.playaccel:
#            print "HUH???"
        if self.playaccel:
            #Hideous.... couldn't get checked working
            sender.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2;color: rgb(255,255,255)}QPushButton:pressed{background-color: rgb(128, 128, 192);color: rgb(255,255,255)};QPushButton:checked{color: rgb(255,255,255)}")
            self.accelthread = AccelThread(self.soundmanager)
            self.accelthread.start()
        else:
            #Hideous.... couldn't get checked working
            sender.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2;color: rgb(127,127,127)}QPushButton:pressed{background-color: rgb(128, 128, 192);color: rgb(255,255,255)};QPushButton:checked{color: rgb(255,255,255)}")
            self.accelthread.terminate()

    def keyPressEvent(self, event):
        ek = event.key()
        if ek < 256:
            for i in range(len(keymap[ek])):
                self.soundmanager.playsound(keymap[ek][i])
            self.soundmanager.playsound(0)
            
    def __init__(self, parent = None):        
        QMainWindow.__init__(self, parent)
        
        self.setStyleSheet("background-color: rgb(0, 0, 0);") 

        pixmap = QtGui.QPixmap(appdir +"/dsnn2.jpg")
        lbl = QtGui.QLabel(self)
        lbl.setPixmap(pixmap)
        lbl.setGeometry(12,480 - pixmap.height()-12,pixmap.width(),pixmap.height())

        self.soundmanager = SoundManager(appdir+'/sounds')
        self.soundmanager.init_audio()
#        self.accelthread = AccelThread(self.soundmanager)
        menu = QPushButton('Menu',self)
        menu.setGeometry(15,15,100,55)
        menu.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2;color: rgb(255,255,255)}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  

        accelbtn = QPushButton('Accelerometer',self)
        accelbtn.setGeometry(115,15,325,55)
        accelbtn.flat=True
        accelbtn.setCheckable(True)
        accelbtn.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2;color: rgb(127,127,127)}QPushButton:pressed{background-color: rgb(128, 128, 192);color: rgb(255,255,255)};QPushButton:checked{color: rgb(255,255,255)}")  
        self.connect(accelbtn, SIGNAL('clicked()'), self.toggleaccel)


        quit = QPushButton('Close',self)
        self.connect(quit, SIGNAL('clicked()'), QtGui.qApp, QtCore.SLOT('quit()'))
        quit.setGeometry(440,15,100,55)
        quit.flat=True
        quit.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,0);background-color: rgb(64, 64, 64);border-radius:10;padding:2;margin:2}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  

        for i in range(3):
            for j in range(numsoundgroups):
                pad = QPushButton('',self)
                pad.setGeometry(550+(80*i),15+(65*j),80,65)
                pad.psn=(i,j)                
                self.connect(pad, SIGNAL('pressed()'), self.clickdrumpad)
                pad.setStyleSheet("QPushButton{border-width: 1px;border-style: ridge;border-color: rgb(0,0,64);background-color: rgb(64, 64, 127);alternate-background-color: rgb(127, 127, 255);border-radius:10;padding:2;margin:2}QPushButton:pressed{background-color: rgb(128, 128, 192);};")  

    @pyqtSignature("")
    def on_closeButton_pressed(self):
        #self.close()
        self.soundmanager.endgracefully()
        sys.exit()


if __name__ == "__main__":
    #gobject.threads_init()
    app = QApplication(sys.argv)
    palette = QtGui.QPalette()
    app.setPalette(palette)
    QCoreApplication.flush()
    ui = MainWindow()
    ui.setAttribute(Qt.WA_Maemo5StackedWindow)
    ui.showFullScreen()
    sys.exit(app.exec_())
