#!/usr/bin/env python

# License: This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at your
# option) any later version. This program is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.

# credits 
# code: Tony Day
# drumkit by Pbroks13 (Own work) [CC-BY-3.0 (www.creativecommons.org/licences/by/3.0)], via wikimedia Commons
# drum wavs downloaded from drumsamples.org (which is all the accrediation I have) 

import os, sys, pygame, math, random, ConfigParser
from pygame.locals import *
import gst
import struct
import gobject
import wave
import array
import Numeric
import numpy
import threading
import time
import datetime

from pymixer import *

gobject.threads_init()

bpp=16
playsounds=True
busychannels=[False,False,False,False,False,False,False,False]

#f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", "r")

import dbus
bus = dbus.SystemBus()             
accel = bus.get_object('com.nokia.mce',
        '/com/nokia/mce/request',
        'com.nokia.mce.request') 

def dbusgetrotation():
    orientation , stand , face , x , y , z = accel.get_device_orientation()
    return (x,y,z)

def getrotation():
    f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", "r")
    coords = [int(w) for w in f.readline().split()]
    f.close()
    return coords

def main():
    global drumsound
    global appdir
    appdir = sys.argv[0]
    appdir = os.path.dirname(appdir)
    appdir =os.path.abspath(appdir)
    print "PATH: " + appdir
    pygame.init()
    pygame.mouse.set_visible(False)

    flags=0 
#    flags=FULLSCREEN
    screen=pygame.display.set_mode((800,480),flags,bpp)
    pygame.display.set_caption('Take it away Marco')
    print pygame.display.get_driver()
    print pygame.display.get_surface()

    mixer=AudioMixer()
    for i in range(1, 5):
        mixer.addwav(appdir + "/sounds/KickDrums1/kickdrum" +str(i ) + ".wav")
        mixer.addwav(appdir +"/sounds/HiHats1/hihat" +str(i) + ".wav")
        mixer.addwav(appdir +"/sounds/SnareDrums1/snaredrum" +str(i) + ".wav")
        mixer.addwav(appdir +"/sounds/Cymbals1/cymbal" +str(i) + ".wav")
        mixer.addwav(appdir +"/sounds/TomTomDrums/tomtomdrum" +str(i) + ".wav")
        mixer.addwav(appdir +"/sounds/BassDrums1/bassdrum" +str(i) + ".wav")


    play(screen,mixer)

def playsound (mixer, num):
    mixer.playsound(num + (6*random.randrange(0,4)))             

def getpossounds(event):
    snds =[]
    if (event.pos[0] >= 550) and (event.pos[1] >= 5):
        snds.append(int((event.pos[1]-5)/70))
    if (event.pos[0] >= 710):
        snds.append(1)    
    elif (event.pos[0] >= 630):
        snds.append(0)    

    return snds

def play(screen,mixer):
    global drumsound
    global busychannels
    background = pygame.image.load(appdir + '/dsnn2.jpg')
    screen.blit(background,(0,20))
    for i in range(3):
        for j in range(6):
            pygame.draw.rect(screen, (127,127,200),(550+(80*i),5 +(70*j),70,60))    


    font = pygame.font.Font(None, 48)
    text = font.render('Accelerometer', True, (64,64,64), (0,0,0))        
    text.set_colorkey((0,0,0))
    textRect = text.get_rect(centerx=380,centery=30)
    screen.blit(text,textRect)

    pygame.display.flip()
    mixer.init_audio()
    active=True
    playaccel=False
#    playaccel=True

    clock = pygame.time.Clock()
    cords1 = (0,0,0)
    cords2 = (0,0,0)
    busychannels=[0,0,0,0,0,0,0,0] 

    lastplayed=[0,0,0]
    run = 0
    tps = 200
    t1 = datetime.datetime.utcnow()
    while True:        
        clock.tick(tps)
        run += 1 

        for i in range(0,8):
            busychannels[i] = busychannels[i] -1

        for event in pygame.event.get():
            if event.type == QUIT:
                print str(t1.ctime())
                print str(datetime.datetime.utcnow().ctime())
                print "run " + str(run) + " times"               
                mixer.endgracefully                
                return False
            if event.type == MOUSEBUTTONDOWN:
                
#                for i in range(4):
#                    print str(textRect[i])

                if (event.pos[0] >= textRect.x):
                  if (event.pos[0] <= textRect.x +textRect.width):
                    if (event.pos[1] >= textRect.top ): 
                     if (event.pos[1] <= textRect.top + textRect.height):
                        playaccel= not playaccel

                        if playaccel:
                            clr = (255,255,255)
                        else:
                            clr = (64,64,64)

                        font = pygame.font.Font(None, 48)
                        text = font.render('Accelerometer', True, clr, (0,0,0))        
                        text.set_colorkey((0,0,0))
                        textRect = text.get_rect(centerx=380,centery=30)
                        screen.blit(text,textRect)
                        pygame.display.flip()                    

                snds = getpossounds(event)
                for snd in snds:
                    playsound(mixer,snd)
            if event.type == KEYDOWN:
                    playsound(mixer,0)

            elif event.type == pygame.ACTIVEEVENT:
                print "Active changed"
                if active:
                    tps=10
                    mixer.pause()
                    active=False
                else:
                    tps=10
                    mixer.play()
                    active=False

        if playaccel:
            cords3 = getrotation()
            for axis in range(0, 3):
                if abs(cords3[axis] - cords2[axis]) > 100:
                    if (lastplayed[axis] < run -10):
                        lastplayed[axis] = run
                        if playaccel:    
                            if cords3[axis] > cords2[axis]:
                                mixer.playsound(axis+3)
                            else:
                                mixer.playsound(axis)
                            pass            
            cords1=cords2            
            cords2=cords3    
    
        mixer.process()


if __name__ == "__main__":
    main()