.TH SYNCTERM 1 "27 May 2007"
.SH NAME
syncterm \- BBS terminal program
.SH SYNOPSIS
\fBsyncterm\fP [-e\fIdly\fP] [-i\fIifc\fP] [-l\fIlns\fP] [-t|-r|-h] [-s] [\fIURL\fP]
.SH DESCRIPTION
\fBSyncTERM\fP is a terminal program designed specifically for connecting to
a Bulletin Board System (\fBBBS\fP)
.SS Options
.IP \fB-e\fIdly\fR
Specify the "escape delay" in milliseconds for curses(3) mode. Since curses
uses the escape key for its own purposes, using the escape key for other
control requires a timeout. If this timeout is too low, extended keystrokes
such as arrow keys will be interpreted as an escape keypress followed by other
characters. If this delay is too high, there will be a large delay after a
single escape is pressed. If an escape delay of less than 10ms is specified, it
is forced to 25ms.
.IP \fB-i\fIifc\fR
.RS
Specify the interface to use. Depending on compile options and library
availability, not all interfaces will be available for all installations.
If \fI-i\fP is not specified, SyncTERM will choose the "best" mode in the
following order: SDL, X11, curses, ANSI. The SDL mode specifically can fail
in ways that the automatic fallback can not properly detect (most notably with
libGGI when it is enabled in SDL.) When this occurs, a specific mode will need
to be forced.
.LP
When \fI-i\fP \fBis\fP specified, only the specified mode will be attempted. No
automatic fallback will be performed.
.LP
Further, some available modes (such as SDL windowed) can not be expressly selected.
.LP
The possible
values for \fIiface\fP are:
.IP \fBS\fP
Require SyncTERM to run in full-screen SDL mode. This requires SDL support to
have been compiled in, and the library ``libSDL.so'' to be in the library
search path. Some distributions do not create this symlink when SDL is
installed, but instead only install it when the development package is
installed. In these cases, the development package must be installed to use SDL
modes.
.IP \fBX\fP
Require SyncTERM to run in X11 mode. This requires X11 support to have been
compiled in, and the library ``libX11.so'' to be in the library search path.
As above, this may require the development package to be installed.
.IP \fBC\fP
Require SyncTERM to run in curses mode. This mode as well as the ANSI mode have
special caveats listed in \fB\fITEXT MODE CAVEATS\fR
.IP \fBF\fP
Require SyncTERM to run in curses mode and assume that it is valid to assume
that the display in use will display Codepage 437 glyphs for characters above
127.
special caveats listed in \fB\fITEXT MODE CAVEATS\fR
.IP \fBA\fP
Require SyncTERM to run in ANSI mode. This mode as well as the curses mode have
special caveats (see \fBTEXT MODE CAVEATS\fP)
.RE
.IP \fB-l\fIlns\fR
Sets the number of screen lines to \fIlns\fR. Only specific values are allowed
for \fIlns\fR and they are: 14, 21, 25, 28, 43, and 50. If any other value is
chosen, a value of 50 is used.
.IP \fB-t\fP
Specifies the default scheme for \fIURL\fP to be telnet://
.IP \fB-r\fP
Specifies the default scheme for \fIURL\fP to be rlogin://
.IP \fB-r\fP
Specifies the default scheme for \fIURL\fP to be ssh://
.IP \fB-s\fP
Run in "safe mode" which disables the modification of local files such as the
dialing list.
.SH RUN-TIME LINKING
For some features, specifically SSH support, SDL support, and X11 support,
run-time linking is employed using dlopen(). Using this, it is possible to
build a version which will use SDL, X11, and cryptlib if they are present, but
not fail to run if they are not.
.LP
Unfortunately, due to some packagers decisions, this can result in a binary
which supports SDL, X11, and SSH but can not find the required libraries. To
solve this issue, the development package needs to be installed. The files that
are used are libSDL.so for SDL support, libcl.so for SSH support, and libX11.so
for X11 support.
.SH TEXT MODE CAVAETS
When running in one of the text modes such as curses or ANSI, many of the
control functions are modified since there is no reliable way to use extra
modifier keys. As a result, CTRL-S and CTRL-Q can not be sent to the remote
system. Since these are the flow control characters, this should not present
major usability issues.
.LP
The escape character (ASCII 27) is used in curses and ANSI modes to begin a
control sequence. As such, there is a delay to detect if the next character
continues the escape sequence or is a base escape. Because of this, there will
be a perceptible delay when the escape key is used. This delay can be adjusted
using the \fI-e\fP parameter, but selecting the "correct" value is a dark art
since any value is provably incorrect.
.LP
The curses and ANSI modes are not necessarily the correct number of lines for
a traditional screen mode. As such, filler will be added around the terminal
screen. For some display sizes, unpredictable results may occur.
.SH FILES
.IP \fC/etc/syncterm.lst\fR
The system wide dialing directory.
.IP \fC~/.syncterm/syncterm.lst\fR
The users dialing directory
.IP \fC~/.syncterm/syncterm.ini\fR
The users SyncTERM configuration file
.IP \fClibSDL.so\fR
When this file exists in the library path, SyncTERM will support the use of SDL
for input and output. This file is part of the Simple Directmedia Layer
available from ``http://www.libsdl.org''. See \fBRUN-TIME LINKING\fP for
details.
.IP \fClibX11.so\fR
When this file exists in the library path, SyncTERM will support the use of X11
for input and output. See \fBRUN-TIME LINKING\fP for details.
.IP \fClibcl.so\fR
When this file exists in the library path, SyncTERM will support the use of SSH
connections. This file is part of Peter Gutmann's Cryptlib library available
from ``http://www.cs.auckland.ac.nz/~pgut001/cryptlib/''. See
\fBRUN-TIME LINKING\fP for details.
.SH AUTHOR
Stephen Hurd <shurd@sasktel.net>
.SH BUGS
Commodore PETSCII and Atari ATASCII are lightly tested and most likely have
problems.
.LP
The modem support is untested at this time. Further, it assumes the Hayes
command set and 115200 bps rate on the serial port.
