#include <QListWidgetItem>
#include <QMessageBox>
#include <QDebug>
#include <QMaemo5InformationBox>
#include <QListWidgetItem>
#include "symfonietimerwindow.h"
#include "ui_symfonietimerwindow.h"

SymfonieTimerWindow::SymfonieTimerWindow(QWidget *parent) :
        QMainWindow(parent),
        isEnabledState(false),
        ui(new Ui::SymfonieTimerWindow)
{
    ui->setupUi(this);
    this->setWindowTitle(tr("Timer Window"));

    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(this->windowFlags() | Qt::Window);

    for(int hour=0; hour <= 24; hour++){
        QListWidgetItem *item = new QListWidgetItem(
          QVariant(hour).toString() + tr(" hour"),
          this->ui->listWidgetHour
        );
        item->setData(SymfonieTimerWindow::ROLE_VALUE, hour);
    }

    for(int min=0; min <= 60; min+=5){
        QListWidgetItem *item = new QListWidgetItem(
          QVariant(min).toString() + tr(" minute"),
          this->ui->listWidgetMinute
        );
        item->setData(SymfonieTimerWindow::ROLE_VALUE, min);
    }



    this->connect(this->ui->btnSetTimer, SIGNAL(released()), this, SLOT(setTimerSlot()));
    this->connect(this->ui->btnClearTimer, SIGNAL(released()), this, SLOT(clearTimerSlot()));

   this->setTimerStateEnabled(false);

}

SymfonieTimerWindow::~SymfonieTimerWindow()
{
    delete ui;
}




void SymfonieTimerWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SymfonieTimerWindow::setTimerSlot(){
    int hour, minute;

    if(this->ui->listWidgetHour->currentItem() != NULL){
        hour = this->ui->listWidgetHour->currentItem()->data(SymfonieTimerWindow::ROLE_VALUE).toInt();
    }else{
        hour = 0;
    }

    if(this->ui->listWidgetMinute->currentItem() != NULL){
        minute = this->ui->listWidgetMinute->currentItem()->data(SymfonieTimerWindow::ROLE_VALUE).toInt();
    }else{
        minute = 0;
    }

    if(hour < 0){
        hour = 0;
    }

    if(minute < 0){
        minute = 0;
    }


    this->ui->labelTimerDesc->setText(this->getTimerDescription(hour, minute));


    qDebug() << "selected time: hour: " << hour << "minute: "<< minute << minute;

    if(hour <= 0 && minute <= 0){
        QMessageBox::warning(this, tr(""),
                             tr("Please select a time."), QMessageBox::Close);
        return;
    }

    this->setTimerStateEnabled(true);
    emit setTimerSignal(SymfonieTimerWindow::hourMinuteToMsec(hour, minute));


    QMaemo5InformationBox::information(this, tr("Timer has been set: ") + SymfonieTimerWindow::getTimerDescription(hour, minute),
                                       QMaemo5InformationBox::DefaultTimeout);

    this->hide();
}

void SymfonieTimerWindow::setTimerStateEnabled(bool isEnabled){
    if(isEnabled){
        this->isEnabledState = true;
        this->ui->listWidgetHour->setEnabled(false);
        this->ui->listWidgetMinute->setEnabled(false);
        this->ui->btnSetTimer->setEnabled(false);
        this->ui->btnClearTimer->setEnabled(true);
    }else{
        this->isEnabledState = false;
        this->updateStateInfo();
        this->ui->listWidgetHour->setEnabled(true);
        this->ui->listWidgetMinute->setEnabled(true);
        this->ui->btnClearTimer->setEnabled(false);
        this->ui->btnSetTimer->setEnabled(true);
    }

}

void SymfonieTimerWindow::clearTimerSlot(){
    this->setTimerStateEnabled(false);
    emit clearTimerSignal();
}


QString SymfonieTimerWindow::getNoTimerDescription(){
    return "Timer is not set";
}


QString SymfonieTimerWindow::getTimerDescription(int time){
    /** @todo check if this is right */
    int hour = (int) time / 3600000;
    int minute = (int) (time % 3600000) / 60000;
    QString buff = "Zzz in ";
    if(hour > 0){
        buff += QVariant(hour).toString() + " hour ";
    }

    buff += QVariant(minute).toString() + " minute";

    return buff;
}

int SymfonieTimerWindow::hourMinuteToMsec(int hour, int minute){
  return hour * 3600000 + minute * 60000;
}

QString SymfonieTimerWindow::getTimerDescription(int hour, int minute){
    int time = SymfonieTimerWindow::hourMinuteToMsec(hour, minute);
    return SymfonieTimerWindow::getTimerDescription(time);
}

void SymfonieTimerWindow::updateStateInfo(){
    if(this->isEnabledState){
    }else{
        this->ui->labelTimerDesc->setText(this->getNoTimerDescription());
    }
}

void SymfonieTimerWindow::updateStateInfo(int time){


    if(this->isEnabledState){
        this->ui->labelTimerDesc->setText(this->getTimerDescription(time));
    }else{
        this->ui->labelTimerDesc->setText(this->getNoTimerDescription());
    }
}

