#include <QTimer>
#include "symfoniethread.h"
#include "symfoniemetareader.h"
#include "symfoniesong.h"

SymfonieMetaReader::SymfonieMetaReader(QObject*) :
        QThread(),
         metaPlayer(new Phonon::MediaObject),
         audioOutput(new Phonon::AudioOutput),
        isBusy(false)
{

    moveToThread(this);

    Phonon::createPath(metaPlayer, audioOutput);

    connect(this->metaPlayer, SIGNAL(stateChanged(Phonon::State,Phonon::State)),
                    this, SLOT(metaStateChangedSlot(Phonon::State,Phonon::State)));


}

SymfonieMetaReader::~SymfonieMetaReader(){
    delete this->metaPlayer;
    delete this->audioOutput;
    this->exit();

    //delete this->metaFuture;
  //  delete this->metaWatcher;
}


void SymfonieMetaReader::run(){
    msleep(5000);
    qDebug() << "run called";
     this->processMetaQueue();
     exec();
}


void SymfonieMetaReader::processMetaQueue()
{
    if(this->isFinished()){
        qDebug() << "processMetaQueue is running";
        return;
    }

    qDebug() << "processMetaQueue called";
    SymfonieSong *song = SymfonieSong::getNextUnIndexedSong();

    if(song == NULL){
        qDebug() << "no more song long sleep";
        msleep(60000);
        this->processMetaQueue();
        return;
    }
    qDebug() << "*******************Started**************" << song->getTitle() + song->getFilePath();

    QString path = song->getFilePath();

    qDebug() << "processMetaQueue: " << path;
   this->metaPlayer->stop();
    this->metaPlayer->clearQueue();
    this->metaPlayer->setCurrentSource(path);
     this->metaPlayer->pause();

     qDebug() << "has more song short sleep";
     msleep(500);
}





void SymfonieMetaReader::metaStateChangedSlot(Phonon::State newState, Phonon::State){
    qDebug() << "metaStateChangedSlot";
    Phonon::MediaObject *mediaObject = this->metaPlayer;
    SymfonieSong *song;
    QString path;
    QMap<QString, QString> metaData;

    switch (newState) {
        case Phonon::ErrorState:
               qDebug() << tr("Fatal Error") << mediaObject->errorString();
               path = mediaObject->currentSource().fileName();
               song = SymfonieSong::findByFilePath(path);

                song->setIsInfoFetched(true);
                song->save();
                delete song;
                this->processMetaQueue();
            break;
        case Phonon::PlayingState:
                qDebug() << "meta playing";
                break;
        case Phonon::StoppedState:
              qDebug() << "meta stoped";
              this->processMetaQueue();
                break;
    case Phonon::PausedState:{
              qDebug() << "puased";
              metaData = mediaObject->metaData();
              path  = mediaObject->currentSource().fileName();
              song = SymfonieSong::findByFilePath(path);

              if(song == NULL){
                song = new SymfonieSong();
                song->setFilePath(path);
             }

              song->setTitle(metaData.value("TITLE"));
              song->setAlbumName(metaData.value("ALBUM"));
              song->setArtistName(metaData.value("ARTIST"));
              song->setLength(mediaObject->totalTime());
              song->setIsInfoFetched(true);
              song->save();
              delete song;

              qDebug() << "-----------saved:" << metaData.value("TITLE") << path;
              this->metaPlayer->stop();

          }
                break;
        case Phonon::BufferingState:
                 qDebug() << "meta loading";
                 break;
        case Phonon::LoadingState:
                qDebug() << "meta buffering";
                break;
        default:
                break;
    }

}
