#ifndef SYMFONIEQSLIDER_H
#define SYMFONIEQSLIDER_H

#include <QWidget>

class QSlider;
class QLabel;
class QVBoxLayout;

class SymfonieQSlider: public QWidget
{
Q_OBJECT
public:
    explicit SymfonieQSlider(int groupIndex, QWidget *parent = 0);
    ~SymfonieQSlider();
    void setText(QString);
    QSlider* getSlider();
    void setName(QString text);
    int getValue();
    void setValue(int);
    int getGroupIndex();


signals:
    void valueChangedSignal (int groupIndex, int value );

public slots:
    void valueChangedSlot ( int value );

private:
    int groupIndex;
    QSlider *slider;
    QLabel *valueLabel;
    QLabel *nameLabel;
    QVBoxLayout *vLayout;
};

#endif // SYMFONIEQSLIDER_H
