#ifndef SYMFONIESONG_H
#define SYMFONIESONG_H

#include <QObject>

class QSqlQuery;

class SymfonieSong : public QObject
{
Q_OBJECT
public:
    explicit SymfonieSong(QObject *parent = 0);

    void setId(int id);
    int getId();

    void setTitle(QString title);
    QString getTitle();

    void setLength(qint64);
    qint64 getLength();

    void setFileSize(qint64);
    qint64 getFileSize();

    void setFilePath(QString);
    QString getFilePath();

    QString getFileDir();
    QString getFileName();
    QString getNameForDisplay();

    void setArtistName(QString);
    QString getArtistName();

    void setAlbumName(QString);
    QString getAlbumName();

    void setIsInfoFetched(bool);
    bool getIsInfoFetched();


    static QString getTableName();


    void save();
    bool isNew();
    void setIsNew(bool);
    static SymfonieSong *findById(int id);
    static SymfonieSong *findByFilePath(QString &path);
    static SymfonieSong *findByQuery(QSqlQuery &query);
    static SymfonieSong *hydrateInfoByQuery(QSqlQuery &query);
    //get a list of songs which information have not been fetched
    static QList<SymfonieSong*> *getUnIndexedSongList();
    static SymfonieSong* getNextUnIndexedSong();

    QString toString();

signals:

public slots:

private:
    int id;
    QString title;
    int length;
    int file_size;
    QString file_path;
    QString artist_name;
    QString album_name;
    bool is_info_fetched;
    bool isSongNew;

};

#endif // SYMFONIESONG_H
