#include <QtGui>
#include <QLabel>
#include <QFileSystemModel>
#include <QTreeView>
#include <QListWidget>
#include <phonon>
#include <QSlider>
#include <QPushButton>
//#include <QMaemo5InformationBox>
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "symfoniemediaplayer.h"
#include "symfonieplaylistitem.h"
#include <qglobal.h>
#include "symfonieinfowindow.h"
#include <QHBoxLayout>
#include <QWidget>
#include "symfonierichtextdelegate.h"
#include "symfonieplaylist.h"
#include "symfoniedb.h"
#include "symfonieaboutdialog.h"
#include "symfonietimerwindow.h"
#include "symfonieequalizerwindow.h"
#include "symfoniefiletypesdialog.h"
#include "symfoniefullscreenexitbutton.h"
#include "symfonieoptionsdialog.h"
#include "symfonievolumeslider.h"
#include "symfonievolumedialog.h"
#include "symfonieseekslider.h"
#include "symfonielabelignoreevent.h"
#include "symfonieqmenu.h"
#include "symfoniespeeddialog.h"


MainWindow::MainWindow(const QApplication *app, SymfonieMediaPlayer* player, QWidget *parent) :
        QMainWindow(parent),
        app(app),
        ui(new Ui::MainWindow),
        timerWindow(NULL),
        fileTypesDialog(NULL),
        optionsDialog(NULL),
        volumeDialog(NULL),
        speedDialog(NULL),
        player(player),
        equalizerWindow(new SymfonieEqualizerWindow(this)),
        currentOrientationMode(Qt::WA_Maemo5LandscapeOrientation),
        isInPortait(false),
        isResumePlayback(false),
        isMainToolbarVisible(false),
        fileListWidgetItemFileToDelete(QString())
{
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->setupUi(this);

    setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);


    this->ui->mainToolBar2->hide();





    //set up menus
    orientationGroup = new QActionGroup(this);
    orientationGroup->setExclusive(true);

    orientationLandscape = new QAction(QIcon::fromTheme("general_landscape", QIcon(QLatin1String(":/images/landscape"))), tr("Landscape"), orientationGroup);
    orientationLandscape->setCheckable(true);
    orientationLandscape->setChecked(true);

    orientationAuto = new QAction(tr("Auto"), orientationGroup);
    orientationAuto->setCheckable(true);
    orientationAuto->setChecked(false);

    orientationPortrait = new QAction(QIcon::fromTheme("general_portrait", QIcon(QLatin1String(":/images/portrait"))), tr("Portrait"), orientationGroup);
    orientationPortrait->setCheckable(true);

    this->ui->menuBar->addActions(orientationGroup->actions());





    // connect(a1, SIGNAL(triggered()), this, SLOT(toggleFullScreenOn()));
    //connect(a2, SIGNAL(triggered()), this, SLOT(toggleFullScreenOff()));




    connect(this->ui->menuActionFileTypes, SIGNAL(triggered()), this, SLOT(showFileTypesWindowSlot()));

    connect(this->ui->menuActionOptions, SIGNAL(triggered()), this, SLOT(showOptionsWindowSlot()));


    this->toggleFullScreenAction = new QAction(QIcon::fromTheme("general_fullsize"), QString(), this);
    this->toggleFullScreenAction->setCheckable(true);
    connect(this->toggleFullScreenAction, SIGNAL(toggled(bool)), this, SLOT(toggleFullScreen(bool)));




    connect(this->getPlayer(), SIGNAL(timerStoppedSignal()), this, SLOT(playerTimerStoppedSlot()));
    connect(this->getPlayer(), SIGNAL(timerRemainTimeChangedSignal(int)), this, SLOT(playerTimerRemainTimeChangedSlot(int)));



    this->timerWindow = new SymfonieTimerWindow(this);
    this->connect(this->timerWindow, SIGNAL(setTimerSignal(int)), this, SLOT(updateTimerSlot(int)));
    this->connect(this->timerWindow, SIGNAL(clearTimerSignal()), this, SLOT(clearTimerSlot()));

    this->setMenuActionTimerText(0);

    connect(this->ui->menuActionTimer, SIGNAL(triggered()), this, SLOT(showTimerWindowSlot()));



    //init equalizer window
    bool isEqualizerEnabled = SymfonieDb::getInstance()->getSetting("is_equalizer_enabled", QVariant(0)).toInt() == 0 ? false : true;

    connect(this->equalizerWindow,  SIGNAL(enabledStateChanged(bool)), this, SLOT(equalizerWindowEnabledStateChangedSlot(bool)));
    qDebug() << " this->equalizerWindow->setWindowEnabled(isEqualizerEnabled);" << isEqualizerEnabled;
    this->equalizerWindow->setWindowEnabled(isEqualizerEnabled);


    connect(this->ui->menuActionEqualizer, SIGNAL(triggered()), this, SLOT(showEqualizerWindowSlot()));



    connect(this->ui->menuActionAbout, SIGNAL(triggered()), this, SLOT(showAboutWindowSlot()));


    this->ui->subToolBar->hide();


    //this->ui->fileListWidget->setItemDelegate(new SymfonieRichTextDelegate());

    this->seekSlider = new SymfonieSeekSlider(this);
    this->seekSlider->setMediaObject(player->getMediaObject());

    this->ui->sliderPanel->layout()->addWidget(this->seekSlider);
    SymfonieLabelIgnoreEvent *l = new SymfonieLabelIgnoreEvent(this);
    this->ui->sliderPanel->layout()->addWidget(l);




    //this->volumeSlider->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);



    this->setAttribute(Qt::WA_Maemo5StackedWindow);



    this->fullScreenExitButton = new SymfonieFullScreenExitButton(this);




    playAction = new QAction(style()->standardIcon(QStyle::SP_MediaPlay), tr("Play"), ui->mainToolBar);
    // playAction->setShortcut(tr("Crl+A"));
    //playAction->setDisabled(true);

    stopAction = new QAction(style()->standardIcon(QStyle::SP_MediaStop), tr("Stop"), ui->mainToolBar);
    // stopAction->setShortcut(tr("Crl+S"));
    // stopAction->setDisabled(true);

    prevAction = new QAction(style()->standardIcon(QStyle::SP_MediaSkipBackward), tr("Previous"), ui->mainToolBar);
    //  prevAction->setShortcut(tr("Crl+R"));


    nextAction = new QAction(style()->standardIcon(QStyle::SP_MediaSkipForward), tr("Next"), ui->mainToolBar);
    // nextAction->setShortcut(tr("Crl+N"));





    this->goUpAction =  new QAction(QIcon::fromTheme("filemanager_folder_up"), tr("Go Up"), ui->mainToolBar);
    connect(goUpAction, SIGNAL(triggered()), this, SLOT(goUpSlot()));

    this->switchOrientationAction = new QAction(style()->standardIcon(QStyle::SP_BrowserReload),
                                                tr("Switch Orientation"), ui->mainToolBar);


    this->showInfoWindowAction  = new QAction(tr("Seek"), ui->mainToolBar);
    this->showInfoWindowAction->setCheckable(true);
    connect(showInfoWindowAction, SIGNAL(triggered()), this, SLOT(showInfoWindowSlot()));


    this->showToolBar2Action  = new QAction(QIcon::fromTheme("general_speaker"), tr("Show Volume Control"), ui->mainToolBar);
    //this->showToolBar2Action->setCheckable(true);
    connect(this->showToolBar2Action, SIGNAL(triggered()), this, SLOT(showVolumeDialogSlot()));


    this->goHomeAction = new QAction(QIcon::fromTheme("general_device_root_folder"), tr("Go Home"), ui->mainToolBar);
    connect(goHomeAction, SIGNAL(triggered()), this, SLOT(goHomeSlot()));



    this->showSpeedDialogAction = new QAction(QIcon::fromTheme("general_clock"), tr("Go Home"), ui->mainToolBar);
    this->connect(showSpeedDialogAction, SIGNAL(triggered()), this, SLOT(showSpeedDialogSlot()));


    this->goToCurDir = new QAction(QIcon::fromTheme("imageviewer_rotate"), tr("Go to current directory"), ui->mainToolBar);
    connect(goToCurDir, SIGNAL(triggered()), this, SLOT(goToCurDirSlot()));

    connect(playAction, SIGNAL(triggered()), this, SLOT(playSlot()));
    connect(stopAction, SIGNAL(triggered()), this, SLOT(stopSlot()));
    connect(prevAction, SIGNAL(triggered()), this, SLOT(playPrevSlot()));
    connect(nextAction, SIGNAL(triggered()), this, SLOT(playNextSlot()));
    connect(player, SIGNAL(mediaStateChangedSignal(Phonon::State,Phonon::State)),
            this, SLOT(mediaStateChangedSlot(Phonon::State,Phonon::State)));

    connect(this->player->getMediaObject(), SIGNAL(tick(qint64)), this, SLOT(playerTickSlot(qint64)));


    connect(nextAction, SIGNAL(triggered()), this, SLOT(showInfoWindowSlot()));


    // this->ui->volumePanel->layout()->addWidget(this->volumeSlider);




    //ui->mainToolBar->addAction(switchOrientationAction);
    // QObject::connect(playAction, SIGNAL(triggered()), button2, SLOT(show()));

    //ui->mainToolBar->addWidget(slider);
    connect(this->player, SIGNAL(scanDirCompletedSignal(SymfoniePlayList*, QString)),
            this, SLOT(playerScanDirCompletedSlot(SymfoniePlayList*, QString)));


    this->setupToolBarButtonsLandscape();


    QString lastPlayedFile = SymfonieDb::getInstance()->getSetting("last_played_file").toString();
    QString lastPlayedDir;
    

    if(lastPlayedFile.length() == 0){
        lastPlayedDir = SymfonieDb::getInstance()->getSetting("last_browsed_dir").toString();
    }else{
        lastPlayedDir = QFileInfo(lastPlayedFile).canonicalPath();
    }

    QFileInfo info = QFileInfo(lastPlayedDir);
    if(info.exists()){
        if(SymfonieDb::getInstance()->getSetting("is_auto_resume_playback") != 0){
            this->isResumePlayback = true;
        }else{
            this->isResumePlayback = false;
        }
        this->getPlayer()->scanDir(lastPlayedDir);
    }else{
        this->goHomeSlot();
    }



    
    // this->player->scanDir(this->getCurrentDiretory(), true);


    this->ui->fileListWidget->setContextMenuPolicy(Qt::CustomContextMenu);

    // connect(this->ui->fileListWidget, SIGNAL(customContextMenuRequested(const QPoint &)), this, SLOT(fileListItemContextMenu(const QPoint &)));




    connect(this->ui->fileListWidget, SIGNAL(activated(QModelIndex)),
            this, SLOT(itemActivatedSlot(QModelIndex)));



    if(SymfonieDb::getInstance()->getSetting("is_show_main_toolbar", 1).toInt() == 1){
        this->isMainToolbarVisible = true;
        this->ui->mainToolBar->show();
    }else{
        this->isMainToolbarVisible = false;
        this->ui->mainToolBar->hide();
    }


    if(SymfonieDb::getInstance()->getSetting("is_show_volume_slider", 0).toInt() == 1){
        this->ui->volumePanel->show();
    }else{
        this->ui->volumePanel->hide();
    }

    //this->setHO();

    int testOrientationMode = SymfonieDb::getInstance()->getSetting("orientation_mode", QVariant(Qt::WA_Maemo5LandscapeOrientation)).toInt();

    if(testOrientationMode == Qt::WA_Maemo5AutoOrientation){
        this->orientationAuto->trigger();
        setOrientationMode(Qt::WA_Maemo5AutoOrientation);
    }else if(testOrientationMode == Qt::WA_Maemo5PortraitOrientation){
        this->orientationPortrait->trigger();
        setOrientationMode(Qt::WA_Maemo5PortraitOrientation);
    }else{
        this->orientationLandscape->trigger();
        setOrientationMode(Qt::WA_Maemo5LandscapeOrientation);
    }


    connect(orientationGroup, SIGNAL(triggered(QAction *)), this, SLOT(orientationChanged(QAction *)));


}

void MainWindow::deleteFileSlot(){
    qDebug() << "Trying to delete file: " <<this->fileListWidgetItemFileToDelete;

    QMessageBox msgBox;
    // msgBox.setText(tr("File Deletion"));
     msgBox.setInformativeText(tr("Are you sure you want to delete this file?\n") + this->fileListWidgetItemFileToDelete);
     msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
     msgBox.setDefaultButton(QMessageBox::No);
     int ret = msgBox.exec();

     if(ret != QMessageBox::Yes){
         qDebug() << "use cancelled.";
         return;
     }


    QFileInfo info = QFileInfo(this->fileListWidgetItemFileToDelete);
    if(!info.exists() || !info.isFile()){
        qDebug() << "deleteFileSlot: not a filed, operation skipped.";
        return;
    }

  //  this->getPlayer()->getMediaObject()->stop();

    if(!QFile::remove(this->fileListWidgetItemFileToDelete)){
        qDebug() << "deleteFileSlot: deletion failed: "<< this->fileListWidgetItemFileToDelete;
        return;
    }

    this->getPlayer()->scanDir(this->getCurrentDiretory());


}

void MainWindow::fileListItemContextMenu(const QPoint &pos){

    QListWidgetItem *item = this->ui->fileListWidget->itemAt(pos);
    int itemIndex;

    if(item == NULL){
        return;
    }

    itemIndex = item->data(Qt::UserRole).toInt();

    SymfonieQMenu *menu = new SymfonieQMenu();


    if(this->getPlayer()->getPlayList()->get(itemIndex)->getItemType() == SymfoniePlayListItemFile::File){
        this->fileListWidgetItemFileToDelete = this->getPlayer()->getPlayList()->get(itemIndex)->getName();
        menu->addAction(tr("Delete File"), this, SLOT(deleteFileSlot()));
    }
    menu->exec(this->mapToGlobal(pos));
   // delete menu;
    this->fileListWidgetItemFileToDelete = QString();


}

Ui::MainWindow* MainWindow::getUi(){
    return this->ui;
}

MainWindow::~MainWindow()
{

    this->saveState();
    delete ui;
    delete playAction;
    delete stopAction;
    delete prevAction;
    delete nextAction;

    delete toggleFullScreenAction;
    delete switchOrientationAction;
    delete showInfoWindowAction;
    delete showToolBar2Action;

    delete showSpeedDialogAction;

    delete goUpAction;
    delete goHomeAction;
    delete goToCurDir;
    if(this->timerWindow != NULL){
        delete this->timerWindow;
    }
    delete this->player;

    delete this->equalizerWindow;

    if(this->fileTypesDialog != NULL){
        delete this->fileTypesDialog;
    }

    if(this->optionsDialog != NULL){
        delete this->optionsDialog;
    }

    if(this->volumeDialog != NULL){
        delete this->volumeDialog;
    }

    if(this->speedDialog != NULL){
        delete this->speedDialog;
    }

}

void MainWindow::showSpeedDialogSlot(){
    if(this->speedDialog == NULL){
        this->speedDialog = new SymfonieSpeedDialog(this);
        this->connect(
                speedDialog,
                SIGNAL(speedChangedSignal(float)),
                this,
                SLOT(showSpeedDialogSliderChangedSlot(float))
                );
    }

    this->speedDialog->exec();
}

void MainWindow::showSpeedDialogSliderChangedSlot(float value){
    qDebug() << "Speed value from dialog: " << value;
    this->getPlayer()->setSpeed(value);
}



void MainWindow::setupToolBarButtonsLandscape(){

    this->ui->mainToolBar->clear();
    this->ui->mainToolBar->addAction(this->goHomeAction);
    this->ui->mainToolBar->addAction(this->goUpAction);
    this->ui->mainToolBar->addAction(this->goToCurDir);

    this->ui->mainToolBar->addAction(prevAction);
    this->ui->mainToolBar->addAction(playAction);
    this->ui->mainToolBar->addAction(nextAction);

    this->ui->mainToolBar->addAction(showInfoWindowAction);
    this->ui->mainToolBar->addAction(this->showToolBar2Action);

    this->ui->mainToolBar->addAction(this->showSpeedDialogAction);
    //this->ui->mainToolBar->addAction(this->toggleFullScreenAction);

    this->ui->mainToolBar2->hide();
    this->setToolbarVisibility(this->isMainToolbarVisible);
}


void MainWindow::setupToolBarButtonsPortrait(){


    this->ui->mainToolBar->clear();
    this->ui->mainToolBar2->clear();


    this->ui->mainToolBar2->addAction(prevAction);
    this->ui->mainToolBar2->addAction(playAction);
    this->ui->mainToolBar2->addAction(nextAction);

    this->ui->mainToolBar2->addAction(showInfoWindowAction);
    this->ui->mainToolBar2->addAction(this->showToolBar2Action);


    this->ui->mainToolBar->addAction(this->goHomeAction);
    this->ui->mainToolBar->addAction(this->goUpAction);
    this->ui->mainToolBar->addAction(this->goToCurDir);
    this->ui->mainToolBar->addAction(this->showSpeedDialogAction);

    // this->ui->mainToolBar->addAction(this->toggleFullScreenAction);


    this->ui->mainToolBar2->show();
    this->setToolbarVisibility(this->isMainToolbarVisible);
}


void MainWindow::playerTimerStoppedSlot(){
    if(this->timerWindow != NULL){
        this->timerWindow->setTimerStateEnabled(false);
    }
}

void MainWindow::orientationChanged(QAction *action)
{
    if (action == this->orientationAuto){
        this->setOrientationMode(Qt::WA_Maemo5AutoOrientation);
    }else if (action == this->orientationPortrait){
        this->setOrientationMode(Qt::WA_Maemo5PortraitOrientation);
    }else{
        this->setOrientationMode(Qt::WA_Maemo5LandscapeOrientation);
    }
}

void MainWindow::setOrientationMode(int mode){
    if (mode == Qt::WA_Maemo5AutoOrientation){
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);
        this->setupToolBarButtonsLandscape();
    }else if (mode == Qt::WA_Maemo5PortraitOrientation){
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
        this->setupToolBarButtonsPortrait();
    }else{
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
        this->setupToolBarButtonsLandscape();
    }
    /*
    this->orientationLandscape->setChecked(mode == Qt::WA_Maemo5LandscapeOrientation);
    this->orientationPortrait->setChecked(mode == Qt::WA_Maemo5PortraitOrientation);
    this->orientationAuto->setChecked(mode == Qt::WA_Maemo5AutoOrientation);
  */
    this->currentOrientationMode = mode;

}


void MainWindow::toggleFullScreenOn(){
    toggleFullScreen(true);
}

void MainWindow::toggleFullScreenOff(){
    toggleFullScreen(false);
}

void MainWindow::toggleFullScreen(){
    bool isFullScreen = this->windowState() & Qt::WindowFullScreen;
    this->toggleFullScreen(!isFullScreen);

}

void MainWindow::toggleFullScreen(bool b)
{
    qDebug() << "toggleFullScreen: " << b;
    this->ui->volumePanel->hide();
    setWindowState(b ? windowState() | Qt::WindowFullScreen
        : windowState() & ~Qt::WindowFullScreen);
}


void MainWindow::updateTimerSlot(int time){
    this->setMenuActionTimerText(time);
    this->timerWindow->updateStateInfo(time);
    this->getPlayer()->doTimer(time);
}

void MainWindow::clearTimerSlot(){
    this->getPlayer()->stopTimer();
}

void MainWindow::setMenuActionTimerText(int time){
    //qDebug() << "--------------------------setMenuActionTimerText: "<< time;
    if(time == 0){
        this->ui->menuActionTimer->setText("Sleep Timer");
    }else{
        this->ui->menuActionTimer->setText(SymfonieTimerWindow::getTimerDescription(time));
    }

}

void MainWindow::equalizerWindowEnabledStateChangedSlot(bool value){
    qDebug() << "equalizerWindowEnabledStateChangedSlot called" << value;
    if(value){
        if(this->getPlayer()->insertEqualizerEffect()){
            this->equalizerWindow->setEqualizerEffect(this->getPlayer()->getEqualizerEffect());

        }
    }else{
        this->getPlayer()->removeEqualizerEffect();
    }
}


void MainWindow::showFileTypesWindowSlot(){
    if(this->fileTypesDialog == NULL){
        this->fileTypesDialog = new SymfonieFileTypesDialog(this);
        connect(this->fileTypesDialog, SIGNAL(fileTypesChanged(QStringList)),
                this, SLOT(fileTypesChangedSlot(QStringList)));
    }

    qDebug() << "this->fileTypesDialog->exec()" << this->fileTypesDialog->exec();
}


int MainWindow::getCurrentOrientation(){
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        return Qt::WA_Maemo5LandscapeOrientation;
    }else{
        return Qt::WA_Maemo5PortraitOrientation;
    }
}

void MainWindow::showOptionsWindowSlot(){
    if(this->optionsDialog == NULL){
        this->optionsDialog = new SymfonieOptionsDialog(this);
        connect(this->optionsDialog, SIGNAL(finished(int)),
                this, SLOT(optionsChangedSlot(int)));
    }

    this->optionsDialog->exec();
}

void MainWindow::showVolumeDialogSlot(){
    
    if(this->volumeDialog == NULL){
        this->volumeDialog = new SymfonieVolumeDialog(this);
        this->volumeSlider = new SymfonieVolumeSlider(this->getPlayer()->getAudioOutput(), this);

        this->volumeDialog->layout()->addWidget(this->volumeSlider);

        /*
        connect(this->volumeDialog, SIGNAL(finished(int)),
                this, SLOT(volumeDialogClosedSlot(int)));
                */
    }

    this->volumeDialog->exec();
}

void MainWindow::volumeDialogClosedSlot(){

}


void MainWindow::setToolbarVisibility(bool isShow){
    if(isShow){
        this->ui->mainToolBar->show();
        if(this->getCurrentOrientation() == Qt::WA_Maemo5PortraitOrientation){
            this->ui->mainToolBar2->show();
        }
    }else{

        this->ui->mainToolBar->hide();
        this->ui->mainToolBar2->hide();
    }
    this->resize(this->sizeHint());
}

void MainWindow::optionsChangedSlot(int){
    this->isMainToolbarVisible = this->optionsDialog->getOptionIsShowToolbar();
    this->setToolbarVisibility(this->isMainToolbarVisible);
}


void MainWindow::fileTypesChangedSlot(QStringList list){
    this->getPlayer()->setFileFilter(list);
}

void MainWindow::playerTimerRemainTimeChangedSlot(int time){
    qDebug() << "playerTimerRemainTimeChangedSlot: " << time;

    //this->ui->menuActionTimer
    if(this->timerWindow->isVisible()){
        this->timerWindow->updateStateInfo(time);
    }



    //  if(this->ui->mainMenu->isActiveWindow()){
    /** @todo optimize this, only do this when menu is shown */
    this->setMenuActionTimerText(time);
    // }

}


void MainWindow::goUpSlot(){

    QDir homeDir = QDir(QDir::homePath() + "/MyDocs");
    QDir mediaDir = QDir("/media");
    qDebug() << "sdflskjadf=-===========: "<< homeDir.canonicalPath() << this->getCurrentDiretory();


    if(this->getCurrentDiretory().length() == 0 ||
       QString::compare(homeDir.canonicalPath(), this->getCurrentDiretory()) == 0 ||
       QString::compare(mediaDir.canonicalPath(), this->getCurrentDiretory()) == 0
       ){
        this->goHomeSlot();
    }else{
        QFileInfo info = QFileInfo(this->getCurrentDiretory() + "/..");
        this->getPlayer()->scanDir(info.canonicalFilePath());
    }
}

bool MainWindow::saveLastDir(){
    qDebug() << "trying to save dir: " << this->currentPlayList->getCurrentDirectory();

    QFileInfo info = QFileInfo(this->getCurrentDiretory());
    if(info.exists()){
        SymfonieDb::getInstance()->saveSetting("last_browsed_dir", info.canonicalFilePath());
        return true;

    }
    SymfonieDb::getInstance()->saveSetting("last_browsed_dir", QVariant(""));
    return false;
}


void MainWindow::saveState(){
    this->saveLastDir();
    // qDebug() << "curent time: "<<this->getPlayer()->getMediaObject()->currentTime();


    SymfonieDb::getInstance()->saveSetting("is_seekSlider_visible", QVariant(this->ui->subToolBar->isVisible() ? 1:0));
    //qDebug() << "is_seekSlider_visible" << SymfonieDb::getInstance()->getSetting("is_seekSlider_visible");

    SymfonieDb::getInstance()->saveSetting("orientation_mode", QVariant(this->currentOrientationMode));

    if(this->optionsDialog != NULL){
        SymfonieDb::getInstance()->saveSetting("is_show_main_toolbar", QVariant(this->optionsDialog->getOptionIsShowToolbar() ? 1:0));
        SymfonieDb::getInstance()->saveSetting("is_auto_resume_playback", QVariant(this->optionsDialog->getOptionIsAutoResumePlayback() ? 1:0));
    }
    SymfonieDb::getInstance()->saveSetting("is_show_volume_slider", QVariant(this->ui->volumePanel->isVisible() ? 1:0));
}

void MainWindow::showAboutWindowSlot(){
    SymfonieAboutDialog *dialog = new SymfonieAboutDialog(this);
    dialog->show();
    //auto deleted
}

void MainWindow::showTimerWindowSlot(){
    this->timerWindow->show();
}

void MainWindow::showEqualizerWindowSlot(){
    this->equalizerWindow->show();
}


void MainWindow::goToCurDirSlot(){
    //QString filePath = this->getPlayer()->getFilePathAt(this->getPlayer()->getCurrentDirectory());
    // QFileInfo dirInfo = QFileInfo(filePath);
    QString currentPath = this->getPlayer()->getCurrentDirectory();

    if(currentPath.length() == 0){
        return;
    }else if(QString::compare(this->getCurrentDiretory(), currentPath) == 0){
        return;
    }else{
        this->getPlayer()->scanDir(currentPath);
    }
}

void MainWindow::playerTickSlot(qint64 time)
{

    if(this->ui->sliderPanel->isVisible()){
        QTime displayTime(0, (time / 60000) % 60, (time / 1000) % 60);
        int tt = this->getPlayer()->getMediaObject()->totalTime();
        QTime totalTime(0, (tt / 60000) % 60, (tt / 1000) % 60);
        this->seekSlider->setText(displayTime.toString("mm:ss") + "/" + totalTime.toString("mm:ss"));

    }

}

SymfoniePlayList* MainWindow::createHomePlayList(){
    SymfoniePlayList *playList = new SymfoniePlayList();

    QStringList stringList;

    stringList
            << QDir::homePath () + "/MyDocs/.sounds"
            << "Audio clips"
            << QDir::homePath () + "/MyDocs"
            << "MyDocs";



    for(int index=0; index < stringList.size(); index++){
        QFileInfo fileInfo(stringList.at(index));
        index++;
        QString dirName = stringList.at(index);

        SymfoniePlayListItemFolder *folder = new SymfoniePlayListItemFolder(
                fileInfo.absoluteFilePath()
                );
        folder->setDisplayName(dirName);
        playList->addFolder(folder);
    }









    QString mediaPath = "/media";
    QDir mediaDir = QDir(mediaPath);
    QStringList mediaList = mediaDir.entryList(
            QStringList(),
            QDir::Dirs|QDir::NoDotAndDotDot|QDir::Drives|QDir::AllDirs
            );

    for (int i = 0; i < mediaList.size(); i++) {
        QFileInfo fileInfo(mediaPath + "/" +mediaList.at(i));
        if(!fileInfo.isDir()){
            continue;
        }

        SymfoniePlayListItemFolder *folder =  new SymfoniePlayListItemFolder(fileInfo.canonicalFilePath());
        folder->setDisplayName(fileInfo.fileName());
        playList->addFolder(folder);

    }


    return playList;
}

void MainWindow::goHomeSlot(){
    this->currentPlayList = this->createHomePlayList();
    this->insertItem(this->currentPlayList);
    this->setCurrentDirectory("");
}


void MainWindow::showInfoWindowSlot(){
    if(this->ui->sliderPanel->isVisible()){
        this->ui->sliderPanel->hide();

        this->showInfoWindowAction->setChecked(false);
    }else{
        this->ui->sliderPanel->show();

        this->showInfoWindowAction->setChecked(true);
    }

    this->setActionToggleState();
}

void MainWindow::setActionToggleState(){
    this->showInfoWindowAction->setChecked(this->ui->subToolBar->isVisible());
    this->showToolBar2Action->setChecked(this->ui->volumePanel->isVisible());
}




void MainWindow::showToolBar2Slot(){
    qDebug() << "showToolBar2Slot()";
    if(this->ui->volumePanel->isVisible()){
        this->ui->volumePanel->hide();
    }else{
        this->ui->volumePanel->show();
    }
    //this->resize(this->sizeHint());
    this->setActionToggleState();
}


void MainWindow::stopSlot(){

}


void MainWindow::setHO(){
    qDebug() << "HO";
    // setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    //setAttribute(Qt::WA_Maemo5ForcePortraitOrientation, false);
    //this->setAttribute(Qt::WA_Maemo5StackedWindow);
    //this->setAttribute(Qt::WA_Maemo5StackedWindow, false);
    this->isInPortait = false;
}

void MainWindow::setPO(){
    qDebug() << "PO";
    //setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    //setAttribute(Qt::WA_Maemo5ForcePortraitOrientation, true);
    //  this->setAttribute(Qt::WA_Maemo5StackedWindow, true);

    this->isInPortait = true;
}

void MainWindow::switchOrientationSlot(){
    if(this->isInPortait){
        this->setHO();
    }else{
        this->setPO();
    }
}

void MainWindow::playerDirectoryChangedSlot(QString dir){
    qDebug() << "dir changed:" << dir;

}



void MainWindow::insertItem(SymfoniePlayList* playList){
    qDebug() << "MainWindow::insertItem" ;
    this->ui->fileListWidget->clear();
    int currentPlaybackIndex =  this->player->getCurrentPlaybackIndex();
    QString currentPlaybackFile;
    if(currentPlaybackIndex != -1){
        currentPlaybackFile = this->getPlayer()->getFilePathAt(currentPlaybackIndex);
    }



    QList<SymfoniePlayListItem*> *itemList = playList->getItemList();
    int counter=0;
    foreach (SymfoniePlayListItem *item, *itemList){
        //
        QListWidgetItem *newItem = new QListWidgetItem;



        if(item->getItemType() == SymfoniePlayListItem::Directory){
            newItem->setIcon(QIcon::fromTheme("filemanager_audio_folder"));
        }else if(item->getItemType() == SymfoniePlayListItem::File){
            newItem->setIcon(QIcon::fromTheme("general_audio_file"));
        }else if(item->getItemType() == SymfoniePlayListItem::DotDot){
            newItem->setIcon(QIcon::fromTheme("filemanager_folder_up"));

        }


        newItem->setText(item->getDisplayName());
        //qDebug() << QVariant(itemList->indexOf(item)) ;
        newItem->setData(Qt::UserRole, QVariant(itemList->indexOf(item)));
        ui->fileListWidget->insertItem(counter, newItem);




        if(item->getItemType() == SymfoniePlayListItem::File){
            qDebug() << currentPlaybackIndex << this->getCurrentDiretory() << this->getPlayer()->getCurrentDirectory();
            if(currentPlaybackIndex != -1 && QString::compare(this->getCurrentDiretory(), this->getPlayer()->getCurrentDirectory()) == 0){
                if(QString::compare(item->getName(), currentPlaybackFile) == 0){
                    newItem->setSelected(true);
                    qDebug() << currentPlaybackFile << "selected";

                }
            }
        }

        counter++;
    }
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;

    default:
        break;
    }
}

void MainWindow::itemActivatedSlot(QModelIndex index)
{
    int row = index.row();
    SymfoniePlayList *playList = this->currentPlayList;
    SymfoniePlayListItem *item = playList->get(row);

    if(item == NULL){
        qFatal("play list is empty when itemActivated event received.");
    }

    QString path = item->getName();
    // qDebug() << "item index: " << index << " item at: " << path << item->getItemTypeName() << " curdir:" << this->getCurrentDiretory();

    if(item->getItemType() == SymfoniePlayListItem::Directory){
        this->setCurrentDirectory(path);
        this->getPlayer()->scanDir(this->getCurrentDiretory());
    }else if(item->getItemType() == SymfoniePlayListItem::DotDot){
        //this->setCurrentDirectory(path);
        this->goUpSlot();
    }else if(item->getItemType() == SymfoniePlayListItem::File){
        if(QString::compare(this->getCurrentDiretory(), this->getPlayer()->getCurrentDirectory()) == 0){

        }else{
            //this->getPlayer()->scanDir(this->getCurrentDiretory(), true);

            this->getPlayer()->setPlayList(this->currentPlayList);

        }

        if(row == this->getPlayer()->getCurrentPlaybackIndex() && (
                this->player->getMediaObject()->state() == Phonon::PlayingState ||
                this->player->getMediaObject()->state() == Phonon::PausedState
                )){
            this->getPlayer()->playOrPause();
        }else{
            this->player->enqueue(row);
            this->player->play();

        }

    }

}


void MainWindow::setPlayer(SymfonieMediaPlayer *player){
    this->player = player;
}

SymfonieMediaPlayer * MainWindow::getPlayer(){
    return this->player;
}


void MainWindow::playSlot(){
    this->player->playOrPause();

}

void MainWindow::playNextSlot(){
    qDebug() << "next";
    this->player->playNext();


}

void MainWindow::playPrevSlot(){
    qDebug() << "prev";
    this->player->playPrevious();

}

void MainWindow::mediaStateChangedSlot(Phonon::State newState, Phonon::State){  //oldState
    Phonon::MediaObject *mediaObject = this->getPlayer()->getMediaObject();
    switch (newState) {
    case Phonon::ErrorState:
        if (mediaObject->errorType() == Phonon::FatalError) {
            QMessageBox::warning(this, tr("Fatal Error"),
                                 mediaObject->errorString());
        } else {
            QMessageBox::warning(this, tr("Error"),
                                 mediaObject->errorString());
        }
        break;
       case Phonon::PlayingState:
        // playAction->setEnabled(false);
        playAction->setIcon(style()->standardIcon(QStyle::SP_MediaPause));
        //pauseAction->setEnabled(true);
        stopAction->setEnabled(true);

        qDebug() << "Current playback index: " << this->player->getCurrentPlaybackIndex() ;

        if(QString::compare(this->getCurrentDiretory(), this->getPlayer()->getCurrentDirectory()) == 0){
            this->ui->fileListWidget->setCurrentItem( this->ui->fileListWidget->item(
                    this->player->getCurrentPlaybackIndex()
                    ),
                                                      QItemSelectionModel::SelectCurrent);
        }

        break;
       case Phonon::StoppedState:
        stopAction->setEnabled(false);
        playAction->setEnabled(true);
        playAction->setIcon(style()->standardIcon(QStyle::SP_MediaPlay));
        //pauseAction->setEnabled(false);
        // timeLcd->display("00:00");
        break;
       case Phonon::PausedState:
        //pauseAction->setEnabled(false);
        stopAction->setEnabled(true);
        //playAction->setEnabled(true);
        playAction->setIcon(style()->standardIcon(QStyle::SP_MediaPlay));
        break;
       case Phonon::BufferingState:
        qDebug() << "buffering";
        break;
       default:
        ;
    }
}



QString MainWindow::getCurrentDiretory(){
    return this->curentDirectory;
}

void MainWindow::setCurrentDirectory(QString path){
    this->curentDirectory = path;
}



void MainWindow::playerScanDirCompletedSlot(SymfoniePlayList* playList, QString path){
    qDebug() << "playerScanDirCompletedSlot done scaned: " << path << " item found: " << playList->getSize();
    this->currentPlayList = playList;
    this->setCurrentDirectory(playList->getCurrentDirectory());
    this->insertItem(playList);





    if(this->isResumePlayback == true){
        this->isResumePlayback = false;
        QVariant indexBuff = SymfonieDb::getInstance()->getSetting("last_played_index");
        /** @todo QVariant doesn't seem to take qint64, potential information loss */
        qint64 seekTo = SymfonieDb::getInstance()->getSetting("last_played_position").toInt();
        if(indexBuff.toString().length() != 0){
            int index = indexBuff.toInt();
            if(index != -1){
                this->getPlayer()->setPlayList(playList);
                this->getPlayer()->enqueue(index);
                qDebug() << " queue index: " << index;
                if(seekTo > 0){
                    this->getPlayer()->play(seekTo);
                }else{
                    this->getPlayer()->play();
                }
            }
        }
    }


}
