#ifndef SYMFONIEDB_H
#define SYMFONIEDB_H

#include <QObject>
#include <QtSql>
#include <QSqlDatabase>


class SymfonieDb : public QObject
{
Q_OBJECT
public:
    bool executeQuery(QSqlQuery &query);
    bool executeSql(QString &sql);
    bool executeSql(QString &sql, QSqlQuery &quer);

    void saveSetting(QString name, QVariant value);
    QVariant getSetting(QString name, QVariant defaultValue=QVariant());
    bool isSettingExists(QString name);
    static void createInstance(QObject *parent = 0);
    static SymfonieDb* getInstance();
    


signals:
    void queryErrorSignal(QSqlQuery &query);

public slots:

protected:
    explicit SymfonieDb(QObject *parent = 0);
    void init();
    virtual ~SymfonieDb();
    static SymfonieDb* instance;

private:
    void handlePostQueryExecute(QSqlQuery &query, bool result);
    QSqlDatabase db;


};

#endif // SYMFONIEDB_H
