/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QDateTime>

class QLabel;
class QPaintEvent;
class QResizeEvent;
class QTimer;
class QPushButton;

class Widget : public QWidget
{
    Q_OBJECT
public:
    Widget();
public slots:
    void resetClicked();
    void startClicked();
    void fireNextTimerEvent();
protected:
    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);
    virtual bool x11Event ( XEvent * event );
private:
    void updateTimeLabel(int secsToAlarm);
    void reset();
private:
    int alarmSeconds;
    bool error;
    QWidget *buttonControls;
    QDateTime alarmTime;
    QLabel *timeLabel;
    QTimer *countdownTimer;
    QPushButton *startButton;
};

#endif
