#ifndef STICKYNOTESWIDGET_HPP
#define STICKYNOTESWIDGET_HPP

#include <QtCore>
#include <QtGui>
#include "qmaemo5dynamichomescreenwidget.h"

namespace Ui {
    class StickyNotesWidget;
}

class StickyNotesWidget : public QMaemo5DynamicHomescreenWidget
{
    Q_OBJECT

private:
    Ui::StickyNotesWidget *ui;
    QColor _color;
    bool _isChanged;
    QTimer *_timer;

protected:
    void paintEvent(QPaintEvent *event);
    void changeEvent(QEvent *e);
    void showSettingsDialog();
    bool restoreWidgetState();

public:
    static void createAndShowNew();

    explicit StickyNotesWidget(QWidget *parent = 0);
    ~StickyNotesWidget();
    bool isChanged();

public slots:
    void saveText();

private slots:
    void on_txtNote_textChanged();
    void on_btnAdd_clicked();
    void on_btnOptions_clicked();
    void on_btnExit_clicked();
};

#endif // STICKYNOTESWIDGET_HPP
