#define QT_NO_KEYWORDS

#include "qmaemo5dynamicwidgethelper.h"
#include "qmaemo5dynamichomescreenwidget.h"
#include "qsettingsmanager.h"
#include <gtk-2.0/gtk/gtk.h>
#include <gconf/2/gconf/gconf.h>
#include <gconf/2/gconf/gconf-value.h>
#include <gconf/2/gconf/gconf-client.h>

#define DESKTOP_GCONF_ENTRY "/apps/osso/hildon-desktop/views/current"
#define SETTING_SAVED_WIDGET_IDS "QMaemo5DynamicWidgetHelper-SavedWidgetIds"

static GConfClient *gconfClient;
static int _currentHomeScreen = -1;
static QList<int> *restoredHomescreens;

static void gconf_key_changed_callback(GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer user_data)
{
    Q_UNUSED(client);
    Q_UNUSED(cnxn_id);
    Q_UNUSED(user_data);
    qDebug() << "gconf callback received";
    if (gconf_entry_get_value (entry) != NULL && gconf_entry_get_value (entry)->type == GCONF_VALUE_INT)
    {
        _currentHomeScreen = (int)gconf_value_get_int(gconf_entry_get_value(entry));
        qDebug() << "gconf says, current home screen =" << _currentHomeScreen;

        QMaemo5DynamicWidgetHelper::globalInstance()->updateCurrentHomeScreen();
    }
}

QMaemo5DynamicWidgetHelper *QMaemo5DynamicWidgetHelper::_globalInstance = NULL;

QMaemo5DynamicWidgetHelper *QMaemo5DynamicWidgetHelper::globalInstance()
{
    if (_globalInstance == NULL)
        _globalInstance = new QMaemo5DynamicWidgetHelper();

    return _globalInstance;
}

QMaemo5DynamicWidgetHelper::QMaemo5DynamicWidgetHelper()
    : _widgets(new QList<QMaemo5DynamicHomescreenWidget*>()), _savedAppletIds(new QList<QString>(QSettingsManager::retrieveBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS)))
{

    qDebug() << "initalizing widget helper";
    if (!gconf_is_initialized())
    {
        gconf_init(NULL, NULL, NULL);
        qDebug() << "gconf initialized";
    }
    restoredHomescreens = new QList<int>();

    gconfClient = gconf_client_get_default();
    gconf_client_add_dir(gconfClient, DESKTOP_GCONF_ENTRY, GCONF_CLIENT_PRELOAD_NONE, NULL);
    gconf_client_notify_add(gconfClient, DESKTOP_GCONF_ENTRY, gconf_key_changed_callback, NULL, NULL, NULL);

    _currentHomeScreen = gconf_value_get_int(gconf_entry_get_value(gconf_client_get_entry(gconfClient, DESKTOP_GCONF_ENTRY, NULL, true, NULL)));
    qDebug() << "current home screen=" << _currentHomeScreen;

}

void QMaemo5DynamicWidgetHelper::updateCurrentHomeScreen()
{
    if (!restoredHomescreens->contains(currentHomeScreen()))
    {
        restoredHomescreens->append(currentHomeScreen());
        qDebug() << "re-adding widgets to homescreen:" << currentHomeScreen();
        for (int i = 0; i < _widgets->count(); i++)
        {
            QMaemo5DynamicHomescreenWidget *current = _widgets->operator [](i);
            qDebug() << "examining widget:" << current->appletId() << "supposed desktop:" << current->homescreenNumber();
            if (current->homescreenNumber() == currentHomeScreen())
            {
                current->show();
                qDebug() << "widget shown:" << current->appletId();
            }
        }
    }
    for (int i = 0; i < _widgets->count(); i++)
    {
        QMaemo5DynamicHomescreenWidget *current = _widgets->operator [](i);
        if (current->_isVisibleOnCurrentHomescreen && current->_hackSequenceForSavingFromCallback >= 2 && current->_hackSequenceCount > 2)
        {
            qDebug() << "applet:" << current->appletId() << "is now saved by helper";
            current->savePosition();
        }
        current->_hackSequenceForSavingFromCallback = 0;
    }
}

int QMaemo5DynamicWidgetHelper::currentHomeScreen()
{
    //qDebug() << "someone asked for current homescreen";
    //qDebug() << "according to gconf, it is:" << gconf_value_get_int(gconf_entry_get_value(gconf_client_get_entry(gconfClient, DESKTOP_GCONF_ENTRY, NULL, true, NULL)));
    return _currentHomeScreen;
}

void QMaemo5DynamicWidgetHelper::registerWidget(QMaemo5DynamicHomescreenWidget *widget)
{
    if (!_widgets->contains(widget))
        _widgets->append(widget);;
    if (!_savedAppletIds->contains(widget->appletId()))
        _savedAppletIds->append(widget->appletId());

    QSettingsManager::storeBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS, *_savedAppletIds);
    qDebug() << "widget registered:" << widget->appletId();
}

void QMaemo5DynamicWidgetHelper::unregisterWidget(QMaemo5DynamicHomescreenWidget *widget)
{
    if (_widgets->contains(widget))
        _widgets->removeOne(widget);
    if (_savedAppletIds->contains(widget->appletId()))
        _savedAppletIds->removeOne(widget->appletId());
    QSettingsManager::storeBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS, *_savedAppletIds);
    qDebug() << "widget unregistered:" << widget->appletId();
}

bool QMaemo5DynamicWidgetHelper::isWidgetRegistered(QMaemo5DynamicHomescreenWidget *widget)
{
    return _widgets->contains(widget);
}

const QList<QString> &QMaemo5DynamicWidgetHelper::savedAppletIds()
{
    return *_savedAppletIds;
}

const QList<QMaemo5DynamicHomescreenWidget*> &QMaemo5DynamicWidgetHelper::widgets()
{
    return *_widgets;
}

void QMaemo5DynamicWidgetHelper::forgetAllWidgets()
{
    _savedAppletIds->clear();
    QSettingsManager::removeSettingsStartingWith(SETTING_SAVED_WIDGET_IDS);
    QSettingsManager::removeSettingsStartingWith(WIDGET_SETTINGS_BASE_APPLETID);
    qDebug() << "forgot all widgets";
}
