/*
 * Stellarium
 * Copyright (C) 2010 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "ProjectionDialog.hpp"
#include "StelApp.hpp"
#include "StelCore.hpp"

ProjectionDialog::ProjectionDialog(QWidget *parent) : QDialog(parent)
{
	setupUi(this);

	StelCore* core = StelApp::getInstance().getCore();
	projectionListWidget->blockSignals(true);
	projectionListWidget->clear();
	const QStringList mappings = core->getAllProjectionTypeKeys();
	foreach (QString s, mappings)
	{
		projectionListWidget->addItem(core->projectionTypeKeyToNameI18n(s));
	}
	projectionListWidget->setCurrentItem(projectionListWidget->findItems(core->projectionTypeKeyToNameI18n(core->getCurrentProjectionTypeKey()), Qt::MatchExactly).at(0));
	projectionListWidget->blockSignals(false);
	projectionTextBrowser->setHtml(core->getProjection(Mat4d())->getHtmlSummary());

	connect(projectionListWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(projectionChanged(QListWidgetItem*)));
}

void ProjectionDialog::projectionChanged(QListWidgetItem* item)
{
	StelCore* core = StelApp::getInstance().getCore();
	core->setCurrentProjectionTypeKey(core->projectionNameI18nToTypeKey(item->text()));
	projectionTextBrowser->setHtml(core->getProjection(Mat4d())->getHtmlSummary());
}
